/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.GenericResponseWrapper;
import net.sf.ehcache.constructs.web.ResponseUtil;
import net.sf.ehcache.constructs.web.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipFilter
extends Filter {
    private static final Logger LOG = LoggerFactory.getLogger(GzipFilter.class);

    protected void doInit(FilterConfig filterConfig) throws Exception {
    }

    protected void doDestroy() {
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        if (!this.isIncluded(request) && this.acceptsEncoding(request, "gzip")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(request.getRequestURL() + ". Writing with gzip compression");
            }
            ByteArrayOutputStream compressed = new ByteArrayOutputStream();
            GZIPOutputStream gzout = new GZIPOutputStream(compressed);
            GenericResponseWrapper wrapper = new GenericResponseWrapper(response, gzout);
            chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
            wrapper.flush();
            gzout.close();
            int statusCode = wrapper.getStatus();
            if (statusCode != 200) {
                return;
            }
            byte[] compressedBytes = compressed.toByteArray();
            boolean shouldGzippedBodyBeZero = ResponseUtil.shouldGzippedBodyBeZero(compressedBytes, request);
            boolean shouldBodyBeZero = ResponseUtil.shouldBodyBeZero(request, wrapper.getStatus());
            if (shouldGzippedBodyBeZero || shouldBodyBeZero) {
                compressedBytes = new byte[]{};
            }
            ResponseUtil.addGzipHeader(response);
            response.setContentLength(compressedBytes.length);
            response.getOutputStream().write(compressedBytes);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(request.getRequestURL() + ". Writing without gzip compression because the request does not accept gzip.");
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean isIncluded(HttpServletRequest request) {
        boolean includeRequest;
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        boolean bl = includeRequest = uri != null;
        if (includeRequest && LOG.isDebugEnabled()) {
            LOG.debug(request.getRequestURL() + " resulted in an include request. This is unusable, because" + "the response will be assembled into the overrall response. Not gzipping.");
        }
        return includeRequest;
    }

    protected boolean acceptsGzipEncoding(HttpServletRequest request) {
        return this.acceptsEncoding(request, "gzip");
    }
}

