/*
 * Decompiled with CFR 0.152.
 */
package emulib.emustudio.debugtable;

import emulib.plugins.cpu.AbstractDebugColumn;
import emulib.plugins.cpu.DisassembledInstruction;
import emulib.plugins.cpu.Disassembler;
import emulib.runtime.exceptions.InvalidInstructionException;
import java.util.Objects;

public class MnemoColumn
extends AbstractDebugColumn {
    private final Disassembler disassembler;

    public MnemoColumn(Disassembler disassembler) {
        super("mnemonics", String.class, false);
        this.disassembler = Objects.requireNonNull(disassembler);
    }

    @Override
    public void setDebugValue(int location, Object value) {
    }

    @Override
    public Object getDebugValue(int location) {
        try {
            DisassembledInstruction instr = this.disassembler.disassemble(location);
            return instr.getMnemo();
        }
        catch (InvalidInstructionException e) {
            return "[invalid]";
        }
        catch (IndexOutOfBoundsException e) {
            return "[incomplete]";
        }
    }

    @Override
    public int getDefaultWidth() {
        return -1;
    }
}

