/*
 * Decompiled with CFR 0.152.
 */
package emulib.emustudio.debugtable;

import emulib.plugins.cpu.AbstractDebugColumn;
import emulib.plugins.cpu.Disassembler;
import emulib.runtime.exceptions.InvalidInstructionException;
import java.util.Objects;

public class OpcodeColumn
extends AbstractDebugColumn {
    private final Disassembler disassembler;

    public OpcodeColumn(Disassembler disassembler) {
        super("opcode", String.class, false);
        this.disassembler = Objects.requireNonNull(disassembler);
    }

    @Override
    public void setDebugValue(int location, Object value) {
    }

    @Override
    public Object getDebugValue(int location) {
        try {
            return this.disassembler.disassemble(location).getOpCode();
        }
        catch (InvalidInstructionException | IndexOutOfBoundsException e) {
            return "";
        }
    }

    @Override
    public int getDefaultWidth() {
        return -1;
    }
}

