/*
 * Decompiled with CFR 0.152.
 */
package emulib.plugins.compiler;

import emulib.annotations.PluginType;
import emulib.emustudio.SettingsManager;
import emulib.plugins.compiler.Compiler;
import emulib.plugins.compiler.Message;
import emulib.runtime.exceptions.PluginInitializationException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompiler
implements Compiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCompiler.class);
    protected int programStart = 0;
    protected final long pluginID;
    private final Set<Compiler.CompilerListener> compilerListeners = new CopyOnWriteArraySet<Compiler.CompilerListener>();

    public AbstractCompiler(Long pluginID) {
        this.pluginID = pluginID;
    }

    @Override
    public void initialize(SettingsManager settings) throws PluginInitializationException {
    }

    @Override
    public String getTitle() {
        return this.getClass().getAnnotation(PluginType.class).title();
    }

    @Override
    public int getProgramStartAddress() {
        return this.programStart;
    }

    @Override
    public boolean addCompilerListener(Compiler.CompilerListener listener) {
        return this.compilerListeners.add(listener);
    }

    @Override
    public boolean removeCompilerListener(Compiler.CompilerListener listener) {
        return this.compilerListeners.remove(listener);
    }

    protected void notifyCompileStart() {
        this.compilerListeners.forEach(listener -> {
            try {
                listener.onStart();
            }
            catch (Exception e) {
                LOGGER.error("Compiler listener error", (Throwable)e);
            }
        });
    }

    protected void notifyCompileFinish(int errorCode) {
        this.compilerListeners.forEach(listener -> {
            try {
                listener.onFinish(errorCode);
            }
            catch (Exception e) {
                LOGGER.error("Compiler listener error", (Throwable)e);
            }
        });
    }

    public void notifyOnMessage(Message message) {
        this.compilerListeners.forEach(listener -> {
            try {
                listener.onMessage(message);
            }
            catch (Exception e) {
                LOGGER.error("Compiler listener error", (Throwable)e);
            }
        });
    }

    public void notifyError(String mes) {
        this.notifyOnMessage(new Message(Message.MessageType.TYPE_ERROR, mes));
    }

    public void notifyInfo(String mes) {
        this.notifyOnMessage(new Message(Message.MessageType.TYPE_INFO, mes));
    }

    public void notifyWarning(String mes) {
        this.notifyOnMessage(new Message(Message.MessageType.TYPE_WARNING, mes));
    }

    @Override
    public void reset() {
    }
}

