/*
 * Decompiled with CFR 0.152.
 */
package emulib.plugins.compiler;

public class Message {
    public static final String INFO_FORMAT = "[Info    (%03d)] ";
    public static final String ERROR_FORMAT = "[Error   (%03d)] ";
    public static final String WARNING_FORMAT = "[Warning (%03d)] ";
    public static final String POSITION_FORMAT = "(%3d,%3d) ";
    public static final String SOURCE_FILE_FORMAT = "<%s> ";
    private final MessageType messageType;
    private final String message;
    private final String sourceFile;
    private final int line;
    private final int column;
    private final int errorCode;

    public Message(MessageType message_type, String message, int line, int column, String sourceFile, int error_code) {
        this.messageType = message_type;
        this.message = message;
        this.sourceFile = sourceFile;
        this.line = line;
        this.column = column;
        this.errorCode = error_code;
    }

    public Message(String message) {
        this(MessageType.TYPE_UNKNOWN, message, -1, -1, null, 0);
    }

    public Message(MessageType type, String message) {
        this(type, message, -1, -1, null, 0);
    }

    public Message(MessageType message_type, String message, int error_code) {
        this(message_type, message, -1, -1, null, error_code);
    }

    public Message(MessageType message_type, String message, String sourceFile, int errorCode) {
        this(message_type, message, -1, -1, sourceFile, errorCode);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getFormattedMessage() {
        StringBuilder mes = new StringBuilder();
        switch (this.messageType) {
            case TYPE_WARNING: {
                mes.append(String.format(WARNING_FORMAT, this.errorCode));
                break;
            }
            case TYPE_ERROR: {
                mes.append(String.format(ERROR_FORMAT, this.errorCode));
                break;
            }
            case TYPE_INFO: {
                mes.append(String.format(INFO_FORMAT, this.errorCode));
            }
        }
        if (this.sourceFile != null) {
            mes.append(String.format(SOURCE_FILE_FORMAT, this.sourceFile));
        }
        if (this.line >= 0 || this.column >= 0) {
            mes.append(String.format(POSITION_FORMAT, this.line, this.column));
        }
        mes.append(this.message);
        return mes.toString();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getMessage() {
        return this.message;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    public static enum MessageType {
        TYPE_WARNING,
        TYPE_ERROR,
        TYPE_INFO,
        TYPE_UNKNOWN;

    }
}

