/*
 * Decompiled with CFR 0.152.
 */
package emulib.runtime;

import emulib.plugins.memory.MemoryContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HEXFileManager {
    private final Map<Integer, String> program = new HashMap<Integer, String>();
    private int nextAddress = 0;

    public int putCode(String code) {
        if (code.isEmpty()) {
            return this.nextAddress;
        }
        int addr = this.nextAddress;
        for (int i = 0; i < code.length() - 1; i += 2) {
            String tmp = code.substring(i, i + 2);
            this.program.put(addr, tmp);
            ++addr;
        }
        this.nextAddress += code.length() / 2;
        return this.nextAddress;
    }

    public void setNextAddress(int address) {
        this.nextAddress = address;
    }

    private String checksum(String lin) {
        int sum = 0;
        for (int i = 0; i < lin.length() - 1; i += 2) {
            sum += Integer.parseInt(lin.substring(i, i + 2), 16);
        }
        int chsum = 256 - (sum %= 256);
        return String.format("%1$02X", chsum);
    }

    public void addTable(Map<Integer, String> ha) {
        ArrayList<Integer> adrs = new ArrayList<Integer>(ha.keySet());
        int largestAdr = this.nextAddress;
        for (Integer adr : adrs) {
            this.nextAddress = adr;
            String cd = ha.get(this.nextAddress);
            this.putCode(cd);
            if (this.nextAddress <= largestAdr) continue;
            largestAdr = this.nextAddress;
        }
        this.nextAddress = largestAdr;
    }

    public Map<Integer, String> getTable() {
        return this.program;
    }

    private String generateHEX() {
        String lines = "";
        String lineAddress = "";
        String line = "";
        int address = 0;
        int bytesCount = 0;
        ArrayList<Integer> adrs = new ArrayList<Integer>(this.program.keySet());
        Collections.sort(adrs);
        for (Integer adr : adrs) {
            if (lineAddress.isEmpty()) {
                address = adr;
                lineAddress = String.format("%1$04X", address);
            }
            if (address != adr || bytesCount >= 16) {
                String lin = String.format("%1$02X", bytesCount) + lineAddress + "00" + line;
                lines = lines + ":" + lin + this.checksum(lin) + "\n";
                bytesCount = 0;
                line = "";
                address = adr;
                lineAddress = String.format("%1$04X", address);
            }
            String cd = this.program.get(adr);
            line = line + cd;
            address += cd.length() / 2;
            bytesCount += cd.length() / 2;
        }
        if (!line.isEmpty()) {
            String lin = String.format("%1$02X", bytesCount) + lineAddress + "00" + line;
            lines = lines + ":" + lin + this.checksum(lin) + "\n";
        }
        lines = lines + ":00000001FF\n";
        return lines;
    }

    public boolean loadIntoMemory(MemoryContext<Short> mem) {
        ArrayList<Integer> adrs = new ArrayList<Integer>(this.program.keySet());
        Collections.sort(adrs);
        adrs.forEach(adr -> {
            String code = this.program.get(adr);
            int i = 0;
            int j = 0;
            while (i < code.length() - 1) {
                String hexCode = code.substring(i, i + 2);
                short num = (short)(Short.decode("0x" + hexCode) & 0xFF);
                mem.write(adr + j, num);
                i += 2;
                ++j;
            }
        });
        return true;
    }

    public void generateFile(String filename) throws IOException {
        String fileData = this.generateHEX();
        try (BufferedWriter out = new BufferedWriter(new FileWriter(filename));){
            out.write(fileData);
        }
    }

    public int getProgramStart() {
        ArrayList<Integer> adrs = new ArrayList<Integer>(this.program.keySet());
        Collections.sort(adrs);
        if (!adrs.isEmpty()) {
            return (Integer)adrs.get(0);
        }
        return 0;
    }

    private static char ignoreSpaces(Reader reader) throws IOException {
        int input = reader.read();
        while (input == 32) {
            input = reader.read();
        }
        return (char)input;
    }

    private static char ignoreLine(Reader reader) throws IOException {
        int input = reader.read();
        while (input != -1 && input != 10) {
            input = reader.read();
        }
        return (char)input;
    }

    private static int readWord(Reader reader) throws Exception {
        int input = reader.read();
        if (input == -1) {
            reader.close();
            throw new Exception("Unexpected end of input");
        }
        char wordHigh = (char)input;
        input = reader.read();
        if (input == -1) {
            reader.close();
            throw new Exception("Unexpected end of input");
        }
        char wordLow = (char)input;
        return Integer.decode(String.format("0x%c%c", Character.valueOf(wordHigh), Character.valueOf(wordLow)));
    }

    private static int readDword(Reader reader) throws Exception {
        int input = reader.read();
        if (input == -1) {
            reader.close();
            throw new Exception("Unexpected end of input");
        }
        char dwordHigh = (char)input;
        input = reader.read();
        if (input == -1) {
            reader.close();
            throw new Exception("Unexpected end of input");
        }
        char dwordLow = (char)input;
        input = reader.read();
        if (input == -1) {
            reader.close();
            throw new Exception("Unexpected end of input");
        }
        char wordHigh = (char)input;
        input = reader.read();
        if (input == -1) {
            reader.close();
            throw new Exception("Unexpected end of input");
        }
        char wordLow = (char)input;
        return Integer.decode(String.format("0x%c%c%c%c", Character.valueOf(dwordHigh), Character.valueOf(dwordLow), Character.valueOf(wordHigh), Character.valueOf(wordLow)));
    }

    public static HEXFileManager parseFromFile(File file) throws Exception {
        HEXFileManager hexFile = new HEXFileManager();
        try (FileReader reader = new FileReader(file);){
            int input;
            while ((input = reader.read()) != -1) {
                if (input == 32) {
                    input = HEXFileManager.ignoreSpaces(reader);
                }
                if (input == 59) {
                    HEXFileManager.ignoreLine(reader);
                    continue;
                }
                if (input != 58) {
                    reader.close();
                    throw new IOException("Unexpected character: " + input);
                }
                int bytesCount = HEXFileManager.readWord(reader);
                if (bytesCount == 0) {
                    HEXFileManager.ignoreLine(reader);
                    continue;
                }
                int address = HEXFileManager.readDword(reader);
                int dataType = HEXFileManager.readWord(reader);
                if (dataType != 0) {
                    reader.close();
                    throw new IOException("Unexpected data type: " + dataType);
                }
                hexFile.setNextAddress(address);
                for (int y = 0; y < bytesCount; ++y) {
                    char[] cbuf = new char[2];
                    reader.read(cbuf);
                    if (cbuf[0] == '\n' || cbuf[1] == '\n') {
                        throw new IOException("Unexpected EOL");
                    }
                    hexFile.putCode(new String(cbuf));
                }
                HEXFileManager.ignoreLine(reader);
            }
        }
        return hexFile;
    }

    public static int loadIntoMemory(File file, MemoryContext<Short> memory) throws Exception {
        HEXFileManager hexFile = HEXFileManager.parseFromFile(file);
        hexFile.loadIntoMemory(memory);
        return hexFile.getProgramStart();
    }
}

