/*
 * Decompiled with CFR 0.152.
 */
package emulib.runtime;

public class NumberUtils {
    public static int reverseBits(int value, int numberOfBits) {
        int result = 0;
        for (int i = 0; i < numberOfBits; ++i) {
            result |= (value >>> i & 1) << numberOfBits - i - 1;
        }
        return result;
    }

    public static Byte[] toObjectArray(byte[] array) {
        Byte[] objArray = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            objArray[i] = array[i];
        }
        return objArray;
    }

    public static int readInt(Byte[] word, int strategy) {
        int b3;
        int b2;
        int b1;
        int b0;
        if ((strategy & 4) == 4) {
            b0 = (byte)NumberUtils.reverseBits(word[0].intValue(), 8);
            b1 = (byte)NumberUtils.reverseBits(word[1].intValue(), 8);
            b2 = (byte)NumberUtils.reverseBits(word[2].intValue(), 8);
            b3 = (byte)NumberUtils.reverseBits(word[3].intValue(), 8);
        } else {
            b0 = word[0].intValue();
            b1 = word[1].intValue();
            b2 = word[2].intValue();
            b3 = word[3].intValue();
        }
        int result = (strategy & 2) == 2 ? b3 & 0xFF | (b2 & 0xFF) << 8 | (b1 & 0xFF) << 16 | (b0 & 0xFF) << 24 : b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 24;
        return result;
    }

    public static int readInt(Integer[] word, int strategy) {
        int b3;
        int b2;
        int b1;
        int b0;
        if ((strategy & 4) == 4) {
            b0 = NumberUtils.reverseBits(word[0], 8);
            b1 = NumberUtils.reverseBits(word[1], 8);
            b2 = NumberUtils.reverseBits(word[2], 8);
            b3 = NumberUtils.reverseBits(word[3], 8);
        } else {
            b0 = word[0];
            b1 = word[1];
            b2 = word[2];
            b3 = word[3];
        }
        int result = (strategy & 2) == 2 ? b3 & 0xFF | (b2 & 0xFF) << 8 | (b1 & 0xFF) << 16 | (b0 & 0xFF) << 24 : b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 24;
        return result;
    }

    public static void writeInt(int value, Integer[] output, int strategy) {
        if ((strategy & 2) == 2) {
            output[3] = value & 0xFF;
            output[2] = value >>> 8 & 0xFF;
            output[1] = value >>> 16 & 0xFF;
            output[0] = value >>> 24 & 0xFF;
        } else {
            output[0] = value & 0xFF;
            output[1] = value >>> 8 & 0xFF;
            output[2] = value >>> 16 & 0xFF;
            output[3] = value >>> 24 & 0xFF;
        }
        if ((strategy & 4) == 4) {
            output[0] = NumberUtils.reverseBits(output[0], 8);
            output[1] = NumberUtils.reverseBits(output[1], 8);
            output[2] = NumberUtils.reverseBits(output[2], 8);
            output[3] = NumberUtils.reverseBits(output[3], 8);
        }
    }

    public static void writeInt(int value, Byte[] output, int strategy) {
        Integer[] tmp = new Integer[4];
        NumberUtils.writeInt(value, tmp, strategy);
        for (int i = 0; i < tmp.length; ++i) {
            output[i] = (byte)(tmp[i] & 0xFF);
        }
    }

    public static void writeInt(int value, Short[] output, int strategy) {
        Integer[] tmp = new Integer[output.length];
        NumberUtils.writeInt(value, tmp, strategy);
        for (int i = 0; i < tmp.length; ++i) {
            output[i] = (short)(tmp[i] & 0xFFFF);
        }
    }

    public static final class Strategy {
        public static final int LITTLE_ENDIAN = 1;
        public static final int BIG_ENDIAN = 2;
        public static final int REVERSE_BITS = 4;
    }
}

