/*
 * Decompiled with CFR 0.152.
 */
package emulib.runtime;

import emulib.annotations.EMULIB_VERSION;
import emulib.annotations.PluginType;
import emulib.emustudio.API;
import emulib.plugins.Plugin;
import emulib.runtime.exceptions.InvalidPasswordException;
import emulib.runtime.exceptions.InvalidPluginException;
import emulib.runtime.internal.Unchecked;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PluginLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginLoader.class);
    private static final EMULIB_VERSION CURRENT_EMULIB_VERSION = EMULIB_VERSION.VERSION_9;

    public List<Class<Plugin>> loadPlugins(String password, File ... pluginFiles) throws InvalidPasswordException, IOException {
        API.testPassword(password);
        Objects.requireNonNull(pluginFiles);
        HashSet<URL> urlsToLoad = new HashSet<URL>();
        for (File pluginFile : pluginFiles) {
            urlsToLoad.add(pluginFile.toURI().toURL());
            urlsToLoad.addAll(this.findDependencies(pluginFile));
        }
        LOGGER.debug("Loading {} plugin files", (Object)urlsToLoad.size());
        URLClassLoader pluginsClassLoader = new URLClassLoader(urlsToLoad.toArray(new URL[urlsToLoad.size()]));
        try {
            return Arrays.asList(pluginFiles).stream().map(this::findClassesInJAR).map(l -> this.findMainClass(pluginsClassLoader, (List<String>)l)).collect(Collectors.toList());
        }
        catch (Exception e) {
            if (e instanceof InvalidPluginException || e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
    }

    public List<URL> findDependencies(File pluginFile) throws IOException {
        ArrayList<URL> dependencies = new ArrayList<URL>();
        try (JarFile file = new JarFile(pluginFile);){
            String classPath = file.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (classPath != null) {
                StringTokenizer tokenizer = new StringTokenizer(classPath);
                while (tokenizer.hasMoreTokens()) {
                    dependencies.add(new File(tokenizer.nextToken()).toURI().toURL());
                }
            }
        }
        return dependencies;
    }

    public static boolean doesImplement(Class<?> theClass, Class<?> theInterface) {
        do {
            Class<?>[] interfaces;
            for (Class<?> tmpInterface : interfaces = theClass.getInterfaces()) {
                if (tmpInterface.isInterface() && tmpInterface.equals(theInterface)) {
                    return true;
                }
                if (!PluginLoader.doesImplement(tmpInterface, theInterface)) continue;
                return true;
            }
        } while ((theClass = theClass.getSuperclass()) != null && !theClass.equals(Object.class));
        return false;
    }

    private List<String> findClassesInJAR(File file) {
        ArrayList<String> classes = new ArrayList<String>();
        try (JarInputStream jis = new JarInputStream(new FileInputStream(file));){
            JarEntry jarEntry;
            while ((jarEntry = jis.getNextJarEntry()) != null) {
                String jarEntryName;
                if (jarEntry.isDirectory() || !(jarEntryName = jarEntry.getName()).toLowerCase().endsWith(".class")) continue;
                String className = this.getValidClassName(jarEntryName);
                classes.add(className);
            }
        }
        catch (IOException e) {
            Unchecked.sneakyThrow(e);
        }
        return classes;
    }

    private Class<Plugin> findMainClass(ClassLoader classLoader, List<String> classes) {
        for (String className : classes) {
            try {
                Class<Plugin> definedClass = classLoader.loadClass(className);
                if (definedClass == null || !PluginLoader.trustedPlugin(definedClass)) continue;
                return definedClass;
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                Unchecked.sneakyThrow(new InvalidPluginException("Could not find loaded class: " + className, e));
            }
        }
        Unchecked.sneakyThrow(new InvalidPluginException("Could not find plug-in main class"));
        return null;
    }

    private String getValidClassName(String classFileName) {
        if (classFileName.toLowerCase().endsWith(".class")) {
            classFileName = classFileName.substring(0, classFileName.length() - 6);
        }
        classFileName = classFileName.replace("\\\\", "/").replace('/', '.');
        return classFileName.replace(File.separatorChar, '.');
    }

    static boolean trustedPlugin(Class<?> pluginClass) {
        Objects.requireNonNull(pluginClass);
        if (pluginClass.isInterface()) {
            return false;
        }
        if (!pluginClass.isAnnotationPresent(PluginType.class)) {
            return false;
        }
        PluginType pluginType = pluginClass.getAnnotation(PluginType.class);
        return pluginType.emuLibVersion() == CURRENT_EMULIB_VERSION && PluginLoader.doesImplement(pluginClass, Plugin.class);
    }
}

