/*
 * Decompiled with CFR 0.152.
 */
package emulib.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class RadixUtils {
    private static final double LOG102 = 0.30102999566398114;
    private static final RadixUtils INSTANCE = new RadixUtils();
    private final List<NumberPattern> patterns = new ArrayList<NumberPattern>();

    private RadixUtils() {
        this.initializeDefaultPatterns();
    }

    private void initializeDefaultPatterns() {
        this.patterns.add(new NumberPattern("0x[0-9a-f]+", 16, 2, 0));
        this.patterns.add(new NumberPattern("[0-9a-f]+h", 16, 0, 1));
        this.patterns.add(new NumberPattern("[0-9]+", 10, 0, 0));
        this.patterns.add(new NumberPattern("[0-9]+d", 10, 0, 1));
        this.patterns.add(new NumberPattern("0[0-9]+", 8, 1, 0));
        this.patterns.add(new NumberPattern("[0-9]+o", 8, 0, 1));
    }

    public static RadixUtils getInstance() {
        return INSTANCE;
    }

    public void setDefaults() {
        this.patterns.clear();
        this.initializeDefaultPatterns();
    }

    public void addNumberPattern(NumberPattern pattern) {
        this.patterns.add(pattern);
    }

    public static String convertToRadix(byte[] number, int toRadix, boolean littleEndian) {
        int i;
        String result = "";
        int digitsCount = number.length;
        int bytes = (int)Math.ceil((double)digitsCount * 8.0 * 0.30102999566398114 / Math.log10(toRadix)) + 2;
        if (!littleEndian) {
            for (i = 0; i < digitsCount / 2; ++i) {
                byte tmp = number[i];
                number[i] = number[digitsCount - i - 1];
                number[digitsCount - i - 1] = tmp;
            }
        }
        int[] str = new int[bytes + 1];
        int[] ts = new int[bytes + 1];
        ts[0] = 1;
        for (int k = 0; k < digitsCount; k = (int)((char)(k + 1))) {
            short digit = number[k];
            for (i = 0; i < 8; ++i) {
                int rem;
                int ip;
                int temp;
                int j;
                int val = digit >>> i & 1;
                for (j = 0; j < bytes; ++j) {
                    int n = j;
                    str[n] = str[n] + ts[j] * val;
                    temp = str[j];
                    ip = j;
                    do {
                        rem = temp / toRadix;
                        str[ip++] = temp - rem * toRadix;
                        int n2 = ip;
                        str[n2] = str[n2] + rem;
                    } while ((temp = str[ip]) >= toRadix);
                }
                for (j = 0; j < bytes; ++j) {
                    ts[j] = ts[j] * 2;
                }
                for (j = 0; j < bytes; ++j) {
                    temp = ts[j];
                    ip = j;
                    do {
                        rem = temp / toRadix;
                        ts[ip++] = temp - rem * toRadix;
                        int n = ip;
                        ts[n] = ts[n] + rem;
                    } while ((temp = ts[ip]) >= toRadix);
                }
            }
        }
        boolean first = false;
        for (i = bytes - 1; i >= 0; --i) {
            if (str[i] != 0) {
                first = true;
            }
            if (!first) continue;
            result = str[i] < 10 ? result + (char)(str[i] + 48) : result + (char)(str[i] + 65 - 10);
        }
        if (!first) {
            result = result + "0";
        }
        return result;
    }

    public String convertToRadix(String number, int toRadix) {
        for (NumberPattern pattern : this.patterns) {
            if (!pattern.matches(number)) continue;
            if (pattern.getRadix() == toRadix) {
                return pattern.prepareNumber(number);
            }
            return RadixUtils.convertToRadix(RadixUtils.convertToNumber(pattern.prepareNumber(number), pattern.getRadix()), toRadix, true);
        }
        throw new NumberFormatException("Number not recognized");
    }

    public static String convertToRadix(String number, int fromRadix, int toRadix) {
        if (fromRadix == toRadix) {
            return number;
        }
        byte[] xnumber = RadixUtils.convertToNumber(number, fromRadix);
        return RadixUtils.convertToRadix(xnumber, toRadix, true);
    }

    public static byte[] convertToNumber(String number, int fromRadix) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        long parsed = Long.parseLong(number, fromRadix);
        if (parsed < 0L) {
            throw new NumberFormatException("Too big number to parse");
        }
        while (parsed != 0L) {
            bytes.add((byte)(parsed & 0xFFL));
            parsed >>>= 8;
        }
        byte[] result = new byte[bytes.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Byte)bytes.get(i);
        }
        if (result.length == 0) {
            result = new byte[]{0};
        }
        return result;
    }

    public static byte[] convertToNumber(String number, int fromRadix, int bytesCount) {
        byte[] result = RadixUtils.convertToNumber(number, fromRadix);
        if (result.length != bytesCount) {
            byte[] newResult = new byte[bytesCount];
            System.arraycopy(result, 0, newResult, 0, Math.min(result.length, bytesCount));
            return newResult;
        }
        return result;
    }

    public int parseRadix(String number) throws NumberFormatException {
        for (NumberPattern pattern : this.patterns) {
            if (!pattern.matches(number)) continue;
            return Integer.parseInt(pattern.prepareNumber(number), pattern.getRadix());
        }
        throw new NumberFormatException("Number not recognized");
    }

    public int parseRadix(String number, int radix) throws NumberFormatException {
        for (NumberPattern pattern : this.patterns) {
            if (pattern.getRadix() != radix || !pattern.matches(number)) continue;
            return Integer.parseInt(pattern.prepareNumber(number), radix);
        }
        throw new NumberFormatException("Number not recognized");
    }

    public static String formatByteHexString(int byteNumber) {
        return String.format("%02X", byteNumber);
    }

    public static String formatWordHexString(int wordNumber) {
        return String.format("%04X", wordNumber);
    }

    public static String formatWordHexString(short upper, short lower) {
        return String.format("%04X", (upper << 8 | lower) & 0xFFFF);
    }

    public static String formatDwordHexString(int number) {
        return String.format("%08X", number);
    }

    public static String formatBinaryString(int number, int length, int spacePerBits, boolean spacesFromLeft) {
        String binNumber = Integer.toBinaryString(number);
        binNumber = String.format("%" + length + "s", binNumber).replace(" ", "0");
        char[] resultBits = binNumber.toCharArray();
        StringBuilder builder = new StringBuilder();
        int bitsCounter = spacePerBits - 1;
        for (int k = 0; k < resultBits.length; ++k) {
            char c = spacesFromLeft ? resultBits[k] : resultBits[resultBits.length - k - 1];
            builder.append(c);
            if (spacePerBits <= 0) continue;
            if (bitsCounter == 0) {
                builder.append(' ');
                bitsCounter = spacePerBits - 1;
                continue;
            }
            --bitsCounter;
        }
        return (spacesFromLeft ? builder.toString() : builder.reverse().toString()).trim();
    }

    public static String formatBinaryString(int number, int length) {
        return RadixUtils.formatBinaryString(number, length, 0, false);
    }

    public static class NumberPattern {
        private final Pattern pattern;
        private final int radix;
        private final int start;
        private final int end;

        public NumberPattern(String regex, int radix, int cutFromStart, int cutFromEnd) {
            this.pattern = Pattern.compile(regex, 2);
            this.radix = radix;
            this.start = cutFromStart;
            this.end = cutFromEnd;
        }

        public boolean matches(String number) {
            return this.pattern.matcher(number).matches();
        }

        public int getRadix() {
            return this.radix;
        }

        public String prepareNumber(String number) {
            return number.substring(this.start, number.length() - this.end);
        }
    }
}

