/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.classmock;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.esfinge.classmock.Annotation;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AbstractMethod {
    protected String name;
    protected Class returnType;
    protected Class[] parameters;
    protected Map<Class, Annotation> annotations = new HashMap<Class, Annotation>();
    protected Map<Integer, Map<Class, Annotation>> paramAnnotations = new HashMap<Integer, Map<Class, Annotation>>();

    public AbstractMethod(String name, Class returnType, Class[] parameters) {
        this.name = name;
        this.returnType = returnType;
        this.parameters = parameters;
    }

    public AbstractMethod() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class returnType) {
        this.returnType = returnType;
    }

    public Class[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Class[] parameters) {
        this.parameters = parameters;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.put(annotation.getAnnotation(), annotation);
    }

    public void addAnnotationProperty(Class annotation, String name, Object value) {
        this.annotations.get(annotation).addProperty(name, value);
    }

    public void addParamAnnotation(Integer i, Annotation annotation) {
        if (!this.paramAnnotations.containsKey(i)) {
            this.paramAnnotations.put(i, new HashMap());
        }
        this.paramAnnotations.get(i).put(annotation.getAnnotation(), annotation);
    }

    public void addParamAnnotationProperty(Integer i, Annotation annotation, String name, Object value) {
        this.paramAnnotations.get(i).get(annotation.getAnnotation()).addProperty(name, value);
    }

    public void createMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1025, this.name, this.getMethodSignature(), null, null);
        for (Annotation an : this.annotations.values()) {
            an.createAnnotation(mv);
        }
        for (Integer i : this.paramAnnotations.keySet()) {
            for (Annotation an : this.paramAnnotations.get(i).values()) {
                an.createParameterAnnotation(mv, i);
            }
        }
        mv.visitEnd();
    }

    public String getMethodSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (Class paramType : this.parameters) {
            sb.append(Type.getType((Class)paramType).getDescriptor());
        }
        sb.append(")");
        sb.append(Type.getType((Class)this.returnType).getDescriptor());
        return sb.toString();
    }

    public Annotation getAnnotation(Class annotationClass) {
        return this.annotations.get(annotationClass);
    }

    public Annotation getParamAnnotation(int param, Class annotationClass) {
        return this.paramAnnotations.get(param).get(annotationClass);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMethod other = (AbstractMethod)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Arrays.equals(this.parameters, other.parameters);
    }

    public boolean isAbstract() {
        return true;
    }
}

