/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.classmock;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import net.sf.esfinge.classmock.Location;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Annotation {
    private Class annotation;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Location location;

    public Annotation(Class annotation, Location location) {
        this.annotation = annotation;
        this.location = location;
    }

    public Annotation(Class annotation) {
        this.annotation = annotation;
    }

    public Annotation(Class annotation, Object value) {
        this.annotation = annotation;
        this.addProperty(value);
    }

    public Annotation(Class annotation, String property, Object value) {
        this.annotation = annotation;
        this.addProperty(property, value);
    }

    public Class getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Class annotation) {
        this.annotation = annotation;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void addProperty(Object value) {
        this.properties.put("value", value);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void createAnnotation(ClassVisitor cv) {
        AnnotationVisitor av = cv.visitAnnotation(this.getAnnotationType(), true);
        this.createAnnotation(av);
    }

    public void createAnnotation(MethodVisitor mv) {
        AnnotationVisitor av = mv.visitAnnotation(this.getAnnotationType(), true);
        this.createAnnotation(av);
    }

    public void createParameterAnnotation(MethodVisitor mv, int paramIndex) {
        AnnotationVisitor av = mv.visitParameterAnnotation(paramIndex, this.getAnnotationType(), true);
        this.createAnnotation(av);
    }

    public void createAnnotation(FieldVisitor fv) {
        AnnotationVisitor av = fv.visitAnnotation(this.getAnnotationType(), true);
        this.createAnnotation(av);
    }

    public void createAnnotation(AnnotationVisitor av) {
        Map<String, Object> prop = this.getProperties();
        for (String propName : prop.keySet()) {
            Object value = prop.get(propName);
            if (value instanceof Class) {
                av.visit(propName, (Object)Type.getType((Class)((Class)value)));
                continue;
            }
            if (value.getClass().isArray()) {
                boolean isAnnotationArray = false;
                if (value.getClass().getComponentType() == Annotation.class) {
                    isAnnotationArray = true;
                }
                AnnotationVisitor avArray = av.visitArray(propName);
                for (int i = 0; i < Array.getLength(value); ++i) {
                    if (isAnnotationArray) {
                        Annotation arrayAnnotation = (Annotation)Array.get(value, i);
                        AnnotationVisitor avArrayMember = avArray.visitAnnotation(null, arrayAnnotation.getAnnotationType());
                        arrayAnnotation.createAnnotation(avArrayMember);
                        continue;
                    }
                    avArray.visit(null, Array.get(value, i));
                }
                avArray.visitEnd();
                continue;
            }
            if (value.getClass().isEnum()) {
                av.visitEnum(propName, Type.getType(value.getClass()).getDescriptor(), value.toString());
                continue;
            }
            if (value.getClass() == Annotation.class) {
                Annotation annotation = (Annotation)value;
                AnnotationVisitor aiv = av.visitAnnotation(propName, annotation.getAnnotationType());
                annotation.createAnnotation(aiv);
                continue;
            }
            av.visit(propName, value);
        }
        av.visitEnd();
    }

    public String getAnnotationType() {
        return Type.getType((Class)this.getAnnotation()).getDescriptor();
    }
}

