/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.classmock;

import java.util.HashMap;
import java.util.Map;
import net.sf.esfinge.classmock.Annotation;
import net.sf.esfinge.classmock.Location;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Property {
    private Class type;
    private String name;
    private boolean hasSetter;
    private boolean hasGetter;
    private Map<Class, Annotation> annotations = new HashMap<Class, Annotation>();

    public Property(Class type, String name, boolean hasSetter, boolean hasGetter) {
        this.type = type;
        this.name = name;
        this.hasSetter = hasSetter;
        this.hasGetter = hasGetter;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isHasSetter() {
        return this.hasSetter;
    }

    public void setHasSetter(boolean hasSetter) {
        this.hasSetter = hasSetter;
    }

    public boolean isHasGetter() {
        return this.hasGetter;
    }

    public void setHasGetter(boolean hasGetter) {
        this.hasGetter = hasGetter;
    }

    public String getGetterName() {
        return "get" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    public String getSetterName() {
        return "set" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.put(annotation.getAnnotation(), annotation);
    }

    public void addAnnotationProperty(Class annotation, String name, Object value) {
        this.annotations.get(annotation).addProperty(name, value);
    }

    void createProperty(ClassWriter cw, String className) {
        this.createField(cw);
        if (this.isHasGetter()) {
            this.createGetter(cw, className);
        }
        if (this.isHasSetter()) {
            this.createSetter(cw, className);
        }
    }

    private void createSetter(ClassWriter cw, String className) {
        MethodVisitor mv = cw.visitMethod(1, this.getSetterName(), "(" + this.getPropertyType() + ")V", null, null);
        for (Annotation an : this.annotations.values()) {
            if (an.getLocation() != Location.SETTER) continue;
            an.createAnnotation(mv);
        }
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        if (this.getPropertyType().equals("I") || this.getPropertyType().equals("B") || this.getPropertyType().equals("Z") || this.getPropertyType().equals("C") || this.getPropertyType().equals("S")) {
            mv.visitVarInsn(21, 1);
        } else if (this.getPropertyType().equals("J")) {
            mv.visitVarInsn(22, 1);
        } else if (this.getPropertyType().equals("F")) {
            mv.visitVarInsn(23, 1);
        } else if (this.getPropertyType().equals("D")) {
            mv.visitVarInsn(24, 1);
        } else {
            mv.visitVarInsn(25, 1);
        }
        mv.visitFieldInsn(181, className, this.getName(), this.getPropertyType());
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void createGetter(ClassWriter cw, String className) {
        MethodVisitor mv = cw.visitMethod(1, this.getGetterName(), "()" + this.getPropertyType(), null, null);
        for (Annotation an : this.annotations.values()) {
            if (an.getLocation() != Location.GETTER) continue;
            an.createAnnotation(mv);
        }
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, this.getName(), this.getPropertyType());
        if (this.getPropertyType().equals("I") || this.getPropertyType().equals("B") || this.getPropertyType().equals("Z") || this.getPropertyType().equals("C") || this.getPropertyType().equals("S")) {
            mv.visitInsn(172);
        } else if (this.getPropertyType().equals("J")) {
            mv.visitInsn(173);
        } else if (this.getPropertyType().equals("F")) {
            mv.visitInsn(174);
        } else if (this.getPropertyType().equals("D")) {
            mv.visitInsn(175);
        } else {
            mv.visitInsn(176);
        }
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void createField(ClassWriter cw) {
        FieldVisitor fv = cw.visitField(2, this.getName(), this.getPropertyType(), null, null);
        for (Annotation an : this.annotations.values()) {
            if (an.getLocation() != null && an.getLocation() != Location.FIELD) continue;
            an.createAnnotation(fv);
        }
        fv.visitEnd();
    }

    private String getPropertyType() {
        String propType = Type.getType((Class)this.getType()).getDescriptor();
        return propType;
    }
}

