/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.esfinge.metadata.annotation.finder.Locator;
import net.sf.esfinge.metadata.locate.MetadataLocator;
import net.sf.esfinge.metadata.locate.RegularLocator;

public class AnnotationFinder {
    public static List<Annotation> findAllAnnotations(AnnotatedElement element) throws NoSuchMethodException, SecurityException {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        list.addAll(AnnotationFinder.findAll(element, element));
        return list;
    }

    private static List<Annotation> findAll(AnnotatedElement element, AnnotatedElement originalElement) throws NoSuchMethodException, SecurityException {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        if (!element.equals(Object.class)) {
            Class clazz;
            Class superclassWithMetadata;
            for (Annotation annotations : element.getDeclaredAnnotations()) {
                list.add(annotations);
            }
            if (element instanceof Method) {
                Method method = (Method)element;
                Class<?> clazz2 = method.getDeclaringClass();
                list.addAll(AnnotationFinder.findAll(clazz2, originalElement));
            } else if (element instanceof Field) {
                Field fieldWithElement = (Field)element;
                Class<?> clazz3 = fieldWithElement.getDeclaringClass();
                list.addAll(AnnotationFinder.findAll(clazz3, originalElement));
            } else if (element instanceof Class && (superclassWithMetadata = (clazz = (Class)element).getSuperclass()) != null) {
                for (Class<?> interfacesWithAnnotation : clazz.getInterfaces()) {
                    if (originalElement instanceof Method) {
                        Method original = (Method)originalElement;
                        list.addAll(AnnotationFinder.findAll(interfacesWithAnnotation.getDeclaredMethod(original.getName(), new Class[0]), originalElement));
                        continue;
                    }
                    list.addAll(AnnotationFinder.findAll(interfacesWithAnnotation, originalElement));
                }
                if (!superclassWithMetadata.equals(Object.class)) {
                    list.addAll(AnnotationFinder.findAll(superclassWithMetadata, originalElement));
                }
            }
        }
        return list;
    }

    public static List<Annotation> findAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        Map<Integer, MetadataLocator> locators = AnnotationFinder.getAplicableLocatorChain(annotationClass);
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Map.Entry<Integer, MetadataLocator> entry : locators.entrySet()) {
            Annotation an = entry.getValue().findMetadata(element, annotationClass);
            if (an == null) continue;
            annotations.add(an);
        }
        return annotations;
    }

    public static boolean existAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        return !AnnotationFinder.findAnnotation(element, annotationClass).isEmpty();
    }

    private static Map<Integer, MetadataLocator> getAplicableLocatorChain(Class<? extends Annotation> annotationClass) {
        LinkedHashMap<Integer, MetadataLocator> locators = new LinkedHashMap<Integer, MetadataLocator>();
        for (Annotation annotation : annotationClass.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Locator.class)) continue;
            Locator chain = annotation.annotationType().getAnnotation(Locator.class);
            try {
                locators.put(chain.chainPriority(), chain.value().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        locators.put(0, new RegularLocator());
        return locators;
    }
}

