/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.esfinge.metadata.AnnotationFinder;
import net.sf.esfinge.metadata.AnnotationReader;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.annotation.container.AnnotationReadingConfig;
import net.sf.esfinge.metadata.annotation.container.ContainerFor;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.FieldMetadataContainer;
import net.sf.esfinge.metadata.container.MetadataContainer;
import net.sf.esfinge.metadata.validate.MetadataValidator;

public class MetadataExecute {
    AnnotationReadingConfig arc;
    AnnotationReadingProcessor processor;
    Class<?> containerClass;
    ContainerFor containerFor;
    private Map<AnnotatedElement, Annotation> repositorio;

    public MetadataExecute(Class<?> containerClass) throws AnnotationValidationException {
        this.containerClass = containerClass;
        this.findMetadata(containerClass);
        this.containerFor = this.containerClass.getDeclaredAnnotation(ContainerFor.class);
        if (this.containerFor == null) {
            throw new AnnotationValidationException("The annotation ContainerFor is null in the container ");
        }
        MetadataValidator.validateMetadataOn(this.containerClass);
    }

    public Object execMetadata(AnnotatedElement elementWithMetadata) throws Exception {
        Object container = this.containerClass.newInstance();
        if (container instanceof MetadataContainer || container instanceof FieldMetadataContainer) {
            Set<AnnotatedElement> reg = this.repositorio.keySet();
            for (AnnotatedElement element : reg) {
                Annotation chave = this.repositorio.get(element);
                Annotation an = chave;
                Class<? extends Annotation> annotationClass = an.annotationType();
                if (!AnnotationFinder.existAnnotation(annotationClass, AnnotationReadingConfig.class)) continue;
                this.arc = annotationClass.getAnnotation(AnnotationReadingConfig.class);
                this.processor = this.arc.value().newInstance();
                this.processor.initAnnotation(an, (Field)element);
                this.processor.read(elementWithMetadata, container, this.containerFor.value());
            }
        } else {
            AnnotationReader ar = new AnnotationReader();
            MetadataContainer containerMetadata = (MetadataContainer)ar.readingAnnotationsTo(this.containerClass, MetadataContainer.class);
            for (AnnotationReadingProcessor processAnnotation : containerMetadata.getProcessorClass()) {
                processAnnotation.read(elementWithMetadata, container, this.containerFor.value());
            }
            for (FieldMetadataContainer fieldsContainer : containerMetadata.getFields()) {
                Map<Field, AnnotationReadingProcessor> processFields = fieldsContainer.getProcessors();
                for (AnnotationReadingProcessor reading : processFields.values()) {
                    reading.read(elementWithMetadata, container, this.containerFor.value());
                }
            }
        }
        return container;
    }

    private void findMetadata(Class<?> containerClass) {
        this.repositorio = new HashMap<AnnotatedElement, Annotation>();
        for (Field field : containerClass.getDeclaredFields()) {
            Annotation[] annotationsField;
            for (Annotation annot : annotationsField = field.getDeclaredAnnotations()) {
                this.repositorio.put(field, annot);
            }
        }
    }

    public void setRepositorio(Map<AnnotatedElement, Annotation> repositorio) {
        this.repositorio = repositorio;
    }
}

