/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container;

import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.container.MetadataExecute;

public class MetadataRepository {
    private static MetadataRepository instance;
    private Map<Class<?>, Map<AnnotatedElement, Object>> repository = new HashMap();

    public static void destroyRepository() {
        instance = null;
    }

    public static MetadataRepository initializeRepository() {
        if (instance == null) {
            instance = new MetadataRepository();
        }
        return instance;
    }

    private void addContainer(Class<?> containerClass, AnnotatedElement targetElement, Object container) throws AnnotationReadingException {
        if (!containerClass.isInstance(container)) {
            throw new AnnotationReadingException("The container is not from the container class");
        }
        if (!this.repository.containsKey(containerClass)) {
            this.repository.put(containerClass, new HashMap());
        }
        this.repository.get(containerClass).put(targetElement, container);
    }

    public <E> E getContainer(Class<E> containerClass, AnnotatedElement targetElement) throws Exception {
        if (this.repository.containsKey(containerClass) && this.repository.get(containerClass).containsKey(targetElement)) {
            return (E)this.repository.get(containerClass).get(targetElement);
        }
        MetadataExecute execute = new MetadataExecute(containerClass);
        Object newContainer = null;
        newContainer = execute.execMetadata(targetElement);
        this.addContainer(containerClass, targetElement, newContainer);
        return (E)newContainer;
    }

    public String toString() {
        return "MetadataRepository [repository=" + this.repository.toString() + "]";
    }
}

