/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.esfinge.metadata.AnnotationFinder;
import net.sf.esfinge.metadata.AnnotationReader;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.annotation.container.AllFieldsWith;
import net.sf.esfinge.metadata.annotation.container.ContainerFor;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class AllFieldsWithReadingProcessor
implements AnnotationReadingProcessor {
    private Field fieldAnnoted;
    List<Object> lista;
    Set<Object> set;
    Map<Object, Object> map;
    ParameterizedType fieldGenericType;
    AllFieldsWith annotation;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement elementWithMetadata) {
        this.fieldAnnoted = (Field)elementWithMetadata;
        this.lista = new ArrayList<Object>();
        this.set = new HashSet<Object>();
        this.fieldGenericType = (ParameterizedType)this.fieldAnnoted.getGenericType();
        this.annotation = this.fieldAnnoted.getDeclaredAnnotation(AllFieldsWith.class);
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget target) throws AnnotationReadingException {
        try {
            if (target == ContainerTarget.TYPE) {
                Class clazz = (Class)elementWithMetadata;
                for (Type t1 : this.fieldGenericType.getActualTypeArguments()) {
                    List<Annotation> containerList;
                    ContainerFor containerFor;
                    Class outputClass = (Class)t1;
                    if (!AnnotationFinder.existAnnotation(outputClass, ContainerFor.class) || (containerFor = (ContainerFor)(containerList = AnnotationFinder.findAnnotation(outputClass, ContainerFor.class)).get(0)) == null) continue;
                    if (!containerFor.value().equals((Object)ContainerTarget.FIELDS)) {
                        throw new Exception("ContainerFor: " + (Object)((Object)containerFor.value()) + " no same of METHODS");
                    }
                    for (Field fields : clazz.getDeclaredFields()) {
                        if (!AnnotationFinder.existAnnotation(fields, this.annotation.value())) continue;
                        AnnotationReader metadataReader = new AnnotationReader();
                        Object containerField = outputClass.newInstance();
                        containerField = metadataReader.readingAnnotationsTo(fields, outputClass);
                        this.lista.add(containerField);
                        this.set.add(containerField);
                    }
                    if (this.fieldAnnoted.getType().equals(List.class)) {
                        PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.lista);
                        continue;
                    }
                    if (this.fieldAnnoted.getType().equals(Set.class)) {
                        PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.set);
                        continue;
                    }
                    if (!this.fieldAnnoted.getType().equals(Map.class)) continue;
                    PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.map);
                }
            }
        }
        catch (Exception e) {
            throw new AnnotationReadingException("Cannot read and record the allFieldsWithMetadata in the " + this.fieldAnnoted.getName(), e);
        }
    }
}

