/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.esfinge.metadata.AnnotationFinder;
import net.sf.esfinge.metadata.AnnotationReader;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.annotation.container.AllMethodsWith;
import net.sf.esfinge.metadata.annotation.container.ContainerFor;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class AllMethodsWithReadingProcessor
implements AnnotationReadingProcessor {
    private Field fieldAnnoted;
    List<Object> lista;
    Set<Object> set;
    Map<Object, Object> map;
    ParameterizedType fieldGenericType;
    AllMethodsWith annotation;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement elementWithMetadata) {
        this.fieldAnnoted = (Field)elementWithMetadata;
        this.lista = new ArrayList<Object>();
        this.set = new HashSet<Object>();
        this.map = new HashMap<Object, Object>();
        this.fieldGenericType = (ParameterizedType)this.fieldAnnoted.getGenericType();
        this.annotation = this.fieldAnnoted.getDeclaredAnnotation(AllMethodsWith.class);
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget target) throws AnnotationReadingException {
        try {
            if (target == ContainerTarget.TYPE) {
                Class clazz = (Class)elementWithMetadata;
                for (Type t1 : this.fieldGenericType.getActualTypeArguments()) {
                    Class outputClass = (Class)t1;
                    if (outputClass.equals(Method.class) || !AnnotationFinder.existAnnotation(outputClass, ContainerFor.class)) continue;
                    List<Annotation> containerList = AnnotationFinder.findAnnotation(outputClass, ContainerFor.class);
                    ContainerFor containerFor = (ContainerFor)containerList.get(0);
                    if (!containerFor.value().equals((Object)ContainerTarget.METHODS)) {
                        throw new Exception("ContainerFor: " + (Object)((Object)containerFor.value()) + " no same of METHODS");
                    }
                    for (Method m1 : clazz.getDeclaredMethods()) {
                        if (!AnnotationFinder.existAnnotation(m1, this.annotation.value())) continue;
                        AnnotationReader metadataReader = new AnnotationReader();
                        Object containerField = outputClass.newInstance();
                        containerField = metadataReader.readingAnnotationsTo(m1, outputClass);
                        this.lista.add(containerField);
                        this.set.add(containerField);
                        this.map.put(m1, containerField);
                    }
                    if (this.fieldAnnoted.getType().equals(List.class)) {
                        PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.lista);
                        continue;
                    }
                    if (this.fieldAnnoted.getType().equals(Set.class)) {
                        PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.set);
                        continue;
                    }
                    if (!this.fieldAnnoted.getType().equals(Map.class)) continue;
                    PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.map);
                }
            }
        }
        catch (Exception e) {
            throw new AnnotationReadingException("Cannot read and record the allMethodsWithMetadata in the: " + this.fieldAnnoted.getName(), e);
        }
    }
}

