/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.sf.esfinge.metadata.AnnotationFinder;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.annotation.container.AnnotationProperty;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class AnnotationPropertyReadingProcessor
implements AnnotationReadingProcessor {
    private Field fieldAnnoted;
    private Class<? extends Annotation> annotationThatNeedToContains;
    private AnnotationProperty annot;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement elementWithMetadata) {
        this.fieldAnnoted = (Field)elementWithMetadata;
        this.annot = (AnnotationProperty)an;
        this.annot.property();
        this.annotationThatNeedToContains = this.annot.annotation();
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget enumStr) throws AnnotationReadingException {
        try {
            if (AnnotationFinder.existAnnotation(elementWithMetadata, this.annotationThatNeedToContains)) {
                for (Annotation annotation : AnnotationFinder.findAnnotation(elementWithMetadata, this.annotationThatNeedToContains)) {
                    for (Method methodAnotation : annotation.annotationType().getDeclaredMethods()) {
                        if (!methodAnotation.getName().equals(this.annot.property())) continue;
                        if (methodAnotation.getReturnType().equals(this.fieldAnnoted.getType())) {
                            PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), (Object)methodAnotation.invoke((Object)annotation, new Object[0]));
                            continue;
                        }
                        throw new AnnotationValidationException("The field " + this.fieldAnnoted.getName() + " expected to return " + this.fieldAnnoted.getType() + " instead is receiving " + methodAnotation.getReturnType());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AnnotationReadingException("Cannot read and record the AnnotationProperty: /n As field" + this.fieldAnnoted + "annotation " + this.annotationThatNeedToContains.getName(), e);
        }
    }
}

