/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class ElementNameReadingProcessor
implements AnnotationReadingProcessor {
    private String containerAnnotatedField;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement elementWithMetadata) {
        this.containerAnnotatedField = ((Field)elementWithMetadata).getName();
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget target) throws AnnotationReadingException {
        try {
            this.findFields(elementWithMetadata, container, target);
        }
        catch (Exception e) {
            throw new AnnotationReadingException("Cannot read and record the element name:", e);
        }
    }

    private void findFields(AnnotatedElement elementWithMetadata, Object container, ContainerTarget target) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method;
        Field field;
        Class class1;
        if (target == ContainerTarget.TYPE) {
            class1 = (Class)elementWithMetadata;
            PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)class1.getName());
        } else if (target == ContainerTarget.FIELDS) {
            field = (Field)elementWithMetadata;
            PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)field.getName());
        } else if (target == ContainerTarget.METHODS) {
            method = (Method)elementWithMetadata;
            PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)method.getName());
        } else if (target == ContainerTarget.PROPERTY) {
            if (elementWithMetadata.getClass().equals(Method.class)) {
                method = (Method)elementWithMetadata;
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)method.getName());
            } else if (elementWithMetadata.getClass().equals(Field.class)) {
                field = (Field)elementWithMetadata;
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)field.getName());
            }
        }
        if (target == ContainerTarget.PARAMETER) {
            Parameter parameter = (Parameter)elementWithMetadata;
            PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)parameter.getName());
        } else if (target == ContainerTarget.ALL) {
            if (elementWithMetadata.getClass().equals(Method.class)) {
                method = (Method)elementWithMetadata;
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)method.getName());
            } else if (elementWithMetadata.getClass().equals(Field.class)) {
                field = (Field)elementWithMetadata;
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)field.getName());
            } else {
                class1 = (Class)elementWithMetadata;
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)class1.getName());
            }
        }
    }
}

