/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.esfinge.metadata.AnnotationFinder;
import net.sf.esfinge.metadata.AnnotationReader;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.annotation.container.ContainerFor;
import net.sf.esfinge.metadata.annotation.container.ElementProperty;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class ElementPropertyReadingProcessor
implements AnnotationReadingProcessor {
    private Field fieldAnnoted;
    private List<Object> lista;
    private Set<Object> set;
    private Map<Object, Object> map;
    private ParameterizedType fieldGenericType;
    private ElementProperty elementProperty;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement elementWithMetadata) throws AnnotationValidationException {
        this.fieldAnnoted = (Field)elementWithMetadata;
        this.lista = new ArrayList<Object>();
        this.set = new HashSet<Object>();
        this.map = new HashMap<Object, Object>();
        this.fieldGenericType = (ParameterizedType)this.fieldAnnoted.getGenericType();
        this.elementProperty = (ElementProperty)an;
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget target) throws AnnotationReadingException {
        try {
            if (target == ContainerTarget.TYPE) {
                Class clazz = (Class)elementWithMetadata;
                for (Type t1 : this.fieldGenericType.getActualTypeArguments()) {
                    Class outputClass = (Class)t1;
                    if (outputClass.equals(String.class)) continue;
                    for (Annotation ann : AnnotationFinder.findAnnotation(outputClass, ContainerFor.class)) {
                        ContainerFor containerFor = (ContainerFor)ann;
                        if (!containerFor.value().equals((Object)ContainerTarget.ALL)) {
                            throw new Exception("ContainerFor: " + (Object)((Object)containerFor.value()) + " no same of ALL");
                        }
                        for (Field field : clazz.getDeclaredFields()) {
                            AnnotationReader metadataReader = new AnnotationReader();
                            Object containerField = outputClass.newInstance();
                            containerField = metadataReader.readingAnnotationsTo(field, outputClass);
                            this.lista.add(containerField);
                            this.set.add(containerField);
                            this.map.put(field.getName(), containerField);
                        }
                        if (this.fieldAnnoted.getType().equals(List.class)) {
                            PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.lista);
                            continue;
                        }
                        if (this.fieldAnnoted.getType().equals(Set.class)) {
                            PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.set);
                            continue;
                        }
                        if (!this.fieldAnnoted.getType().equals(Map.class)) continue;
                        PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.map);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AnnotationReadingException("Cannot read and record the ElementPropertyReadingProcessor in the field " + this.fieldAnnoted.getName(), e);
        }
    }
}

