/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.esfinge.metadata.AnnotationReader;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.annotation.container.AnnotationPropertyLocation;
import net.sf.esfinge.metadata.annotation.container.ElementProperty;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class ElementPropertyReadingProcessorNew
implements AnnotationReadingProcessor {
    private Field fieldAnnoted;
    private List<Object> listOfProperty;
    private Set setObject;
    private Map<Object, Object> map;
    private ParameterizedType fieldGenericType;
    private ElementProperty annotation;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement fieldWithMetadata) throws AnnotationValidationException {
        this.fieldAnnoted = (Field)fieldWithMetadata;
        this.listOfProperty = new ArrayList<Object>();
        this.setObject = new HashSet();
        this.map = new HashMap<Object, Object>();
        this.fieldGenericType = (ParameterizedType)this.fieldAnnoted.getGenericType();
        this.annotation = (ElementProperty)an;
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget target) throws AnnotationReadingException {
        try {
            AnnotationReader ar = new AnnotationReader();
            Class annotedClass = null;
            Class genericType = null;
            Object containerElement = null;
            if (elementWithMetadata instanceof Class) {
                annotedClass = (Class)elementWithMetadata;
                if (this.fieldGenericType.getRawType().equals(List.class)) {
                    genericType = (Class)this.fieldGenericType.getActualTypeArguments()[0];
                    containerElement = genericType.newInstance();
                } else if (this.fieldGenericType.getRawType().equals(Set.class)) {
                    genericType = (Class)this.fieldGenericType.getActualTypeArguments()[0];
                    containerElement = genericType.newInstance();
                } else if (this.fieldGenericType.getRawType().equals(Map.class)) {
                    genericType = (Class)this.fieldGenericType.getActualTypeArguments()[1];
                    containerElement = genericType.newInstance();
                }
            }
            if (target == ContainerTarget.TYPE) {
                AnnotationPropertyLocation property = this.annotation.property();
                if (property.isSearchField()) {
                    for (AccessibleObject accessibleObject : annotedClass.getDeclaredFields()) {
                        containerElement = ar.readingAnnotationsTo(accessibleObject, genericType);
                        this.listOfProperty.add(containerElement);
                        this.setObject.add(containerElement);
                        this.map.put(((Field)accessibleObject).getName(), containerElement);
                    }
                }
                if (property.isSearchGetter()) {
                    for (AccessibleObject accessibleObject : annotedClass.getDeclaredMethods()) {
                        if (!((Method)accessibleObject).getName().contains("get") && !((Method)accessibleObject).getName().contains("is")) continue;
                        containerElement = ar.readingAnnotationsTo(accessibleObject, genericType);
                        this.listOfProperty.add(containerElement);
                        this.setObject.add(containerElement);
                        this.map.put(((Method)accessibleObject).getName(), containerElement);
                    }
                }
                if (property.isSearchSetter()) {
                    for (AccessibleObject accessibleObject : annotedClass.getDeclaredMethods()) {
                        if (!((Method)accessibleObject).getName().contains("set")) continue;
                        containerElement = ar.readingAnnotationsTo(accessibleObject, genericType);
                        this.listOfProperty.add(containerElement);
                        this.setObject.add(containerElement);
                        this.map.put(((Method)accessibleObject).getName(), containerElement);
                    }
                }
                this.addToContainer(container);
            }
        }
        catch (Exception e) {
            throw new AnnotationReadingException("Cannot read and record the ElementPropertyReadingProcessor in the field " + this.fieldAnnoted.getName(), e);
        }
    }

    private void addToContainer(Object container) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.fieldAnnoted.getType().equals(List.class)) {
            PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.listOfProperty);
        } else if (this.fieldAnnoted.getType().equals(Set.class)) {
            PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), (Object)this.setObject);
        } else if (this.fieldAnnoted.getType().equals(Map.class)) {
            PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.map);
        }
    }
}

