/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.esfinge.metadata.AnnotationFinder;
import net.sf.esfinge.metadata.AnnotationReader;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.annotation.container.ContainerFor;
import net.sf.esfinge.metadata.annotation.container.ElementPropertyWithoutAnnotation;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class ElementPropertyWithoutAnnotationReadingProcessor
implements AnnotationReadingProcessor {
    private Field fieldAnnoted;
    private List<Object> lista;
    private Set<Object> set;
    private Map<Object, Object> map;
    private ParameterizedType fieldGenericType;
    private ElementPropertyWithoutAnnotation prop;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement elementWithMetadata) throws AnnotationValidationException {
        this.fieldAnnoted = (Field)elementWithMetadata;
        this.lista = new ArrayList<Object>();
        this.set = new HashSet<Object>();
        this.map = new HashMap<Object, Object>();
        this.fieldGenericType = (ParameterizedType)this.fieldAnnoted.getGenericType();
        this.prop = (ElementPropertyWithoutAnnotation)an;
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget target) throws AnnotationReadingException {
        try {
            if (target == ContainerTarget.TYPE) {
                Class clazz = (Class)elementWithMetadata;
                for (Type t1 : this.fieldGenericType.getActualTypeArguments()) {
                    Class outputClass = (Class)t1;
                    if (outputClass.equals(String.class)) continue;
                    for (Annotation ann : AnnotationFinder.findAnnotation(outputClass, ContainerFor.class)) {
                        ContainerFor containerFor = (ContainerFor)ann;
                        if (!containerFor.value().equals((Object)ContainerTarget.ALL)) {
                            throw new Exception("ContainerFor: " + (Object)((Object)containerFor.value()) + " no same of ALL");
                        }
                        for (Field field : clazz.getDeclaredFields()) {
                            boolean methodValid = false;
                            String methodName = ElementPropertyWithoutAnnotationReadingProcessor.propertyToGetter(field.getName());
                            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
                            methodValid = AnnotationFinder.existAnnotation(method, this.prop.value());
                            boolean fieldValid = AnnotationFinder.existAnnotation(field, this.prop.value());
                            if (methodValid && !fieldValid) continue;
                            AnnotationReader metadataReader = new AnnotationReader();
                            Object containerField = outputClass.newInstance();
                            containerField = metadataReader.readingAnnotationsTo(field, outputClass);
                            this.lista.add(containerField);
                            this.set.add(containerField);
                            this.map.put(field.getName(), containerField);
                        }
                        if (this.fieldAnnoted.getType().equals(List.class)) {
                            PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.lista);
                            continue;
                        }
                        if (this.fieldAnnoted.getType().equals(Set.class)) {
                            PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.set);
                            continue;
                        }
                        if (!this.fieldAnnoted.getType().equals(Map.class)) continue;
                        PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.map);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AnnotationReadingException("Cannot read and record the Element " + elementWithMetadata + " in ElementPropertyWithoutAnnotationReadingProcessor in the field " + this.fieldAnnoted.getName(), e);
        }
    }

    public static String propertyToGetter(String propertieName) {
        return ElementPropertyWithoutAnnotationReadingProcessor.propertyToGetter(propertieName, false);
    }

    public static String propertyToGetter(String propertieName, boolean isBoolean) {
        if (isBoolean) {
            return "is" + propertieName.substring(0, 1).toUpperCase() + propertieName.substring(1);
        }
        return "get" + propertieName.substring(0, 1).toUpperCase() + propertieName.substring(1);
    }
}

