/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.sf.esfinge.metadata.AnnotationFinder;
import net.sf.esfinge.metadata.AnnotationReader;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.annotation.container.ContainerFor;
import net.sf.esfinge.metadata.annotation.container.CustomReader;
import net.sf.esfinge.metadata.annotation.container.ExecuteProcessor;
import net.sf.esfinge.metadata.annotation.container.ProcessorType;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class ProcessorsReadingProcessor
implements AnnotationReadingProcessor {
    private AnnotatedElement elementAnnoted;
    private Field fieldAnnoted;
    private List<Object> list;
    private CustomReader processors;
    private Class<? extends Annotation> processorsAnnotationClass;
    Type fieldGenericType;
    private Object returnInvoke;
    private ContainerTarget target;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement elementWithMetadata) throws AnnotationValidationException {
        this.elementAnnoted = elementWithMetadata;
        this.processors = (CustomReader)an;
        this.processorsAnnotationClass = this.processors.configAnnotation();
        if (this.elementAnnoted instanceof Field) {
            this.fieldAnnoted = (Field)this.elementAnnoted;
            this.fieldGenericType = this.fieldAnnoted.getGenericType();
        }
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget target) throws AnnotationReadingException {
        try {
            this.list = new ArrayList<Object>();
            this.target = target;
            this.annotationSearch(elementWithMetadata, container);
            if (this.processors.type() != ProcessorType.READER_ADDS_METADATA) {
                PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.list);
            }
        }
        catch (Exception e) {
            throw new AnnotationReadingException(e);
        }
    }

    private void annotationSearch(AnnotatedElement elementWithMetadata, Object container) throws Exception {
        for (Annotation annotation : elementWithMetadata.getAnnotations()) {
            if (!AnnotationFinder.existAnnotation(annotation.annotationType(), this.processorsAnnotationClass)) continue;
            Annotation processorAnnotation = annotation.annotationType().getAnnotation(this.processorsAnnotationClass);
            Class valueClass = (Class)processorAnnotation.getClass().getDeclaredMethod(this.processors.readerConfig(), new Class[0]).invoke((Object)processorAnnotation, new Object[0]);
            boolean valid = false;
            if (AnnotationFinder.existAnnotation(valueClass, ContainerFor.class)) {
                valid = true;
            }
            for (Method annotedMethod : valueClass.getDeclaredMethods()) {
                if (!AnnotationFinder.existAnnotation(annotedMethod, ExecuteProcessor.class)) continue;
                valid = true;
            }
            if (!valid) {
                throw new AnnotationReadingException("Can not @ContainterFor in the Class or @ExecuteProcessor on a Method in" + valueClass);
            }
            Object objectToInvoke = valueClass.newInstance();
            if (AnnotationFinder.existAnnotation(objectToInvoke.getClass(), ContainerFor.class)) {
                AnnotationReader ar = new AnnotationReader();
                objectToInvoke = ar.readingAnnotationsTo(elementWithMetadata, objectToInvoke.getClass());
            }
            this.findDeclaredAnnotationOnInterface(elementWithMetadata, container, annotation, valueClass, objectToInvoke);
            if (this.processors.type() == ProcessorType.READER_IS_PROCESSOR) {
                this.list.add(objectToInvoke);
                continue;
            }
            if (this.processors.type() != ProcessorType.READER_RETURNS_PROCESSOR) continue;
            this.list.add(this.returnInvoke);
        }
    }

    private void findDeclaredAnnotationOnInterface(AnnotatedElement elementWithMetadata, Object container, Annotation annotation, Class<?> valueClass, Object objectToInvoke) throws Exception {
        for (Class<?> interfaces : valueClass.getInterfaces()) {
            if (interfaces.getDeclaredMethods().length == 0) {
                this.returnInvoke = objectToInvoke;
            }
            for (Method methodToInvoke : interfaces.getDeclaredMethods()) {
                if (!AnnotationFinder.existAnnotation(methodToInvoke, ExecuteProcessor.class)) continue;
                this.executeParameters(elementWithMetadata, container, annotation, objectToInvoke, methodToInvoke);
            }
        }
    }

    private void executeParameters(AnnotatedElement elementWithMetadata, Object container, Annotation annotation, Object objectToInvoke, Method methodToInvoke) throws IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[methodToInvoke.getParameters().length];
        int cont = 0;
        for (Parameter parameterMethod : methodToInvoke.getParameters()) {
            if (parameterMethod.getType().equals(Annotation.class)) {
                args[cont] = annotation;
            } else if (parameterMethod.getType().equals(AnnotatedElement.class)) {
                args[cont] = elementWithMetadata;
            } else if (parameterMethod.getType().equals(Object.class)) {
                args[cont] = container;
            } else if (parameterMethod.getType().equals(ContainerTarget.class)) {
                args[cont] = this.target;
            }
            ++cont;
        }
        if (methodToInvoke.invoke(objectToInvoke, args) != null) {
            this.returnInvoke = methodToInvoke.invoke(objectToInvoke, args);
        }
    }
}

