/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.sf.esfinge.metadata.AnnotationFinder;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.annotation.container.PropertyContainsAnnotation;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class PropertyContainsAnnotationProcessor
implements AnnotationReadingProcessor {
    PropertyContainsAnnotation annot;
    private String containerAnnotatedField;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement elementWithMetadata) {
        this.containerAnnotatedField = ((Field)elementWithMetadata).getName();
        this.annot = (PropertyContainsAnnotation)an;
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget enumStr) throws AnnotationReadingException {
        try {
            Class<? extends Annotation> annotationThatNeedToContains = this.annot.value();
            if (AnnotationFinder.existAnnotation(elementWithMetadata, annotationThatNeedToContains)) {
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)AnnotationFinder.existAnnotation(elementWithMetadata, annotationThatNeedToContains));
            } else if (elementWithMetadata.getClass().equals(Field.class)) {
                Class<?> clazz = ((Field)elementWithMetadata).getDeclaringClass();
                Method method = clazz.getMethod(PropertyContainsAnnotationProcessor.propertyToGetter(((Field)elementWithMetadata).getName()), new Class[0]);
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)AnnotationFinder.existAnnotation(method, annotationThatNeedToContains));
            }
        }
        catch (Exception e) {
            throw new AnnotationReadingException("Cannot read and record the container = " + this.containerAnnotatedField + "annotation = " + this.annot.value(), e);
        }
    }

    public static String propertyToGetter(String propertieName) {
        return PropertyContainsAnnotationProcessor.propertyToGetter(propertieName, false);
    }

    public static String propertyToGetter(String propertieName, boolean isBoolean) {
        if (isBoolean) {
            return "is" + propertieName.substring(0, 1).toUpperCase() + propertieName.substring(1);
        }
        return "get" + propertieName.substring(0, 1).toUpperCase() + propertieName.substring(1);
    }
}

