/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.sf.esfinge.metadata.AnnotationFinder;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.annotation.container.ExecuteProcessor;
import net.sf.esfinge.metadata.annotation.container.ProcessorType;
import net.sf.esfinge.metadata.annotation.container.PropertyProcessors;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class PropertyProcessorsReadingProcessor
implements AnnotationReadingProcessor {
    private Field fieldAnnoted;
    private List<Object> list;
    private PropertyProcessors processors;
    private Class<? extends Annotation> processorsAnnotationClass;
    Type fieldGenericType;
    private Object returnInvoke;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement elementWithMetadata) throws AnnotationValidationException {
        this.fieldAnnoted = (Field)elementWithMetadata;
        this.processors = (PropertyProcessors)an;
        this.processorsAnnotationClass = this.processors.value();
        this.fieldGenericType = this.fieldAnnoted.getGenericType();
        this.list = new ArrayList<Object>();
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget target) throws AnnotationReadingException {
        try {
            this.annotationSearch(elementWithMetadata, container);
            PropertyUtils.setProperty((Object)container, (String)this.fieldAnnoted.getName(), this.list);
        }
        catch (Exception e) {
            throw new AnnotationReadingException(e);
        }
    }

    private void annotationSearch(AnnotatedElement elementWithMetadata, Object container) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        if (elementWithMetadata.getClass().equals(Field.class) && elementWithMetadata.getAnnotations().length > 0) {
            this.addObject(elementWithMetadata, container);
        } else {
            Field field = (Field)elementWithMetadata;
            Class<?> clazz = field.getDeclaringClass();
            Method method = field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class) ? clazz.getMethod(PropertyProcessorsReadingProcessor.propertyToGetter(field.getName(), true), new Class[0]) : clazz.getMethod(PropertyProcessorsReadingProcessor.propertyToGetter(field.getName(), false), new Class[0]);
            this.addObject(method, container);
        }
    }

    private void addObject(AnnotatedElement elementWithMetadata, Object container) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        for (Annotation annotation : elementWithMetadata.getAnnotations()) {
            if (!AnnotationFinder.existAnnotation(annotation.annotationType(), this.processorsAnnotationClass)) continue;
            Annotation processorAnnotation = annotation.annotationType().getAnnotation(this.processorsAnnotationClass);
            Class valueClass = (Class)processorAnnotation.getClass().getDeclaredMethod("value", new Class[0]).invoke((Object)processorAnnotation, new Object[0]);
            Object objectToInvoke = valueClass.newInstance();
            this.findDeclaredAnnotationOnInterface(elementWithMetadata, container, annotation, valueClass, objectToInvoke);
            if (this.processors.type() == ProcessorType.READER_IS_PROCESSOR) {
                this.list.add(objectToInvoke);
                continue;
            }
            if (this.processors.type() != ProcessorType.READER_RETURNS_PROCESSOR) continue;
            this.list.add(this.returnInvoke);
        }
    }

    private void findDeclaredAnnotationOnInterface(AnnotatedElement elementWithMetadata, Object container, Annotation annotation, Class<?> valueClass, Object objectToInvoke) throws IllegalAccessException, InvocationTargetException {
        for (Class<?> interfaces : valueClass.getInterfaces()) {
            for (Method methodToInvoke : interfaces.getDeclaredMethods()) {
                if (!AnnotationFinder.existAnnotation(methodToInvoke, ExecuteProcessor.class)) continue;
                this.executeParameters(elementWithMetadata, container, annotation, objectToInvoke, methodToInvoke);
            }
        }
    }

    private void executeParameters(AnnotatedElement elementWithMetadata, Object container, Annotation annotation, Object objectToInvoke, Method methodToInvoke) throws IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[methodToInvoke.getParameters().length];
        int cont = 0;
        for (Parameter parameterMethod : methodToInvoke.getParameters()) {
            if (parameterMethod.getType().equals(Annotation.class)) {
                args[cont] = annotation;
            } else if (parameterMethod.getType().equals(AnnotatedElement.class)) {
                args[cont] = elementWithMetadata;
            } else if (parameterMethod.getType().equals(container.getClass())) {
                args[cont] = container;
            }
            ++cont;
        }
        if (methodToInvoke.invoke(objectToInvoke, args) != null) {
            this.returnInvoke = methodToInvoke.invoke(objectToInvoke, args);
        }
    }

    public static String propertyToGetter(String propertieName) {
        return PropertyProcessorsReadingProcessor.propertyToGetter(propertieName, false);
    }

    public static String propertyToGetter(String propertieName, boolean isBoolean) {
        if (isBoolean) {
            return "is" + propertieName.substring(0, 1).toUpperCase() + propertieName.substring(1);
        }
        return "get" + propertieName.substring(0, 1).toUpperCase() + propertieName.substring(1);
    }
}

