/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.container.reading;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import net.sf.esfinge.metadata.AnnotationReadingException;
import net.sf.esfinge.metadata.container.AnnotationReadingProcessor;
import net.sf.esfinge.metadata.container.ContainerTarget;
import org.apache.commons.beanutils.PropertyUtils;

public class ReflectionReferenceReadingProcessor
implements AnnotationReadingProcessor {
    private String containerAnnotatedField;
    private Field fieldAnn;

    @Override
    public void initAnnotation(Annotation an, AnnotatedElement elementWithMetadata) {
        this.fieldAnn = (Field)elementWithMetadata;
        this.containerAnnotatedField = this.fieldAnn.getName();
    }

    @Override
    public void read(AnnotatedElement elementWithMetadata, Object container, ContainerTarget target) throws AnnotationReadingException {
        try {
            if (target == ContainerTarget.FIELDS) {
                Field field = (Field)elementWithMetadata;
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)field);
            } else if (target == ContainerTarget.PARAMETER) {
                Parameter parameter = (Parameter)elementWithMetadata;
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)parameter);
            } else if (target == ContainerTarget.TYPE) {
                Class clazz = (Class)elementWithMetadata;
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)clazz);
            } else {
                PropertyUtils.setProperty((Object)container, (String)this.containerAnnotatedField, (Object)elementWithMetadata);
            }
        }
        catch (Exception e) {
            throw new AnnotationReadingException("Cannot read and record the file " + elementWithMetadata + "in " + this.containerAnnotatedField, e);
        }
    }
}

