/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.locate;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import net.sf.esfinge.metadata.locate.MetadataLocationException;
import net.sf.esfinge.metadata.locate.MetadataLocator;

public class InheritanceLocator
extends MetadataLocator {
    private AnnotatedElement originalElement;

    @Override
    public Annotation findMetadata(AnnotatedElement element, Class<? extends Annotation> annotationClass) throws MetadataLocationException {
        this.originalElement = element;
        if (this.originalElement instanceof Class) {
            return this.forClassAnnotation(annotationClass);
        }
        if (this.originalElement instanceof Method) {
            Method methodElement = (Method)this.originalElement;
            Class<?> classWithElement = methodElement.getDeclaringClass();
            for (Class<?> interfaceWithMethods : classWithElement.getInterfaces()) {
                try {
                    for (Method m1 : interfaceWithMethods.getDeclaredMethods()) {
                        if (m1.getName() != methodElement.getName() || !m1.isAnnotationPresent(annotationClass)) continue;
                        return m1.getAnnotation(annotationClass);
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            if (!classWithElement.isInterface()) {
                while (!classWithElement.getSuperclass().equals(Object.class)) {
                    classWithElement = classWithElement.getSuperclass();
                    try {
                        Method superClassMethod = classWithElement.getMethod(methodElement.getName(), new Class[0]);
                        if (!superClassMethod.isAnnotationPresent(annotationClass)) continue;
                        return superClassMethod.getAnnotation(annotationClass);
                    }
                    catch (NoSuchMethodException | SecurityException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private Annotation forClassAnnotation(Class<? extends Annotation> annotationClass) {
        Class classWithMetadata = (Class)this.originalElement;
        for (Class<?> x : classWithMetadata.getInterfaces()) {
            if (!x.isAnnotationPresent(annotationClass)) continue;
            return x.getAnnotation(annotationClass);
        }
        if (!classWithMetadata.isInterface()) {
            while (!classWithMetadata.getSuperclass().equals(Object.class)) {
                if (!(classWithMetadata = classWithMetadata.getSuperclass()).isAnnotationPresent(annotationClass)) continue;
                return classWithMetadata.getAnnotation(annotationClass);
            }
        }
        return null;
    }

    @Override
    public boolean hasMetadata(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        return false;
    }
}

