/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.locate;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import net.sf.esfinge.metadata.AnnotationFinder;
import net.sf.esfinge.metadata.annotation.finder.SearchInsideAnnotations;
import net.sf.esfinge.metadata.locate.MetadataLocator;

public class InsideAnnotationLocator
extends MetadataLocator {
    private int contador = 0;
    private AnnotatedElement OriginalElement;

    @Override
    public Annotation findMetadata(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        Annotation[] ans;
        if (this.contador == 0) {
            this.OriginalElement = element;
        }
        ++this.contador;
        Annotation an = null;
        for (Annotation a : ans = element.getAnnotations()) {
            Class<? extends Annotation> c = a.annotationType();
            if (this.isJavaAnnotation(c) || this.isEsfingeMetadataAnnotation(c)) continue;
            if (c.equals(annotationClass)) {
                an = a;
                return an;
            }
            boolean exist = AnnotationFinder.existAnnotation(c, annotationClass);
            List<Annotation> value = AnnotationFinder.findAnnotation(c, annotationClass);
            if (!exist) continue;
            an = value.get(0);
        }
        return an;
    }

    private boolean isEsfingeMetadataAnnotation(Class<?> c) {
        return c.getPackage().getName().equals("net.sf.esfinge.metadata.annotation.validator");
    }

    private boolean isJavaAnnotation(Class<?> c) {
        return c.getPackage().getName().equals("java.lang.annotation");
    }

    private boolean searchInsideAnnotation(Class<?> c) {
        return AnnotationFinder.existAnnotation(c, SearchInsideAnnotations.class);
    }

    @Override
    public boolean hasMetadata(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        return false;
    }
}

