/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.esfinge.metadata.AnnotationPropertyValidator;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.AnnotationValidator;
import net.sf.esfinge.metadata.annotation.validator.ToValidate;
import net.sf.esfinge.metadata.annotation.validator.ToValidateProperty;

public class MetadataValidator {
    public static void validateMetadataOn(Class<?> clazz) throws AnnotationValidationException {
        for (Annotation an : clazz.getAnnotations()) {
            MetadataValidator.validateAnnotation(an, clazz);
        }
        for (Class<?> currentClazz = clazz; currentClazz != Object.class && currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            for (Method method : currentClazz.getDeclaredMethods()) {
                for (Annotation an : method.getAnnotations()) {
                    MetadataValidator.validateAnnotation(an, method);
                }
            }
            for (AccessibleObject accessibleObject : currentClazz.getDeclaredFields()) {
                for (Annotation an : accessibleObject.getAnnotations()) {
                    MetadataValidator.validateAnnotation(an, accessibleObject);
                }
            }
            for (AccessibleObject accessibleObject : currentClazz.getConstructors()) {
                for (Annotation an : accessibleObject.getAnnotations()) {
                    MetadataValidator.validateAnnotation(an, accessibleObject);
                }
            }
        }
    }

    private static void validateAnnotation(Annotation target, AnnotatedElement ae) throws AnnotationValidationException {
        for (Annotation an : target.annotationType().getAnnotations()) {
            if (an.annotationType().isAnnotationPresent(ToValidate.class)) {
                MetadataValidator.executeValidation(target, ae, an);
                continue;
            }
            if (MetadataValidator.isJavaAnnotation(an) || MetadataValidator.isEsfingeMetadataAnnotation(an)) continue;
            MetadataValidator.validateAnnotation(an, ae);
        }
        for (Method m : target.annotationType().getMethods()) {
            for (Annotation an : m.getAnnotations()) {
                if (!an.annotationType().isAnnotationPresent(ToValidateProperty.class)) continue;
                MetadataValidator.executePropertyValidation(target, ae, an, m);
            }
        }
    }

    private static AnnotationPropertyValidator executePropertyValidation(Annotation target, AnnotatedElement ae, Annotation an, Method m) throws AnnotationValidationException {
        AnnotationPropertyValidator apv;
        ToValidateProperty tovalidate = an.annotationType().getAnnotation(ToValidateProperty.class);
        Class<? extends AnnotationPropertyValidator> validClazz = tovalidate.value();
        Object o = null;
        try {
            o = m.invoke((Object)target, new Object[0]);
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        Object oo = null;
        try {
            Class<? extends Annotation> c = an.annotationType();
            for (Method mm : c.getDeclaredMethods()) {
                oo = mm.invoke((Object)an, new Object[0]);
            }
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            // empty catch block
        }
        try {
            apv = validClazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("The AnnotationPropertyValidator needs to have an non-args public constructor", e);
        }
        apv.initialize(an);
        apv.validate(target, ae, m, o);
        return apv;
    }

    private static AnnotationValidator executeValidation(Annotation target, AnnotatedElement ae, Annotation an) throws AnnotationValidationException {
        AnnotationValidator av;
        ToValidate tovalidate = an.annotationType().getAnnotation(ToValidate.class);
        Class<? extends AnnotationValidator> validClazz = tovalidate.value();
        try {
            av = validClazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("The AnnotationValidator needs to have an non-args public constructor", e);
        }
        av.initialize(an);
        av.validate(target, ae);
        return av;
    }

    private static boolean isJavaAnnotation(Annotation an) {
        return an.annotationType().getPackage().getName().equals("java.lang.annotation");
    }

    private static boolean isEsfingeMetadataAnnotation(Annotation an) {
        return an.annotationType().getPackage().getName().equals("net.sf.esfinge.metadata.annotation.validator");
    }
}

