/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.validate.field;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.AnnotationValidator;
import net.sf.esfinge.metadata.annotation.validator.field.FieldVisibilityForbidden;

public class ValidatorFieldVisibilityForbidden
implements AnnotationValidator {
    private String visibility = "";

    @Override
    public void initialize(Annotation self) {
        FieldVisibilityForbidden fvf = (FieldVisibilityForbidden)self;
        this.visibility = fvf.itCannotHaveThisVisibility();
    }

    @Override
    public void validate(Annotation toValidate, AnnotatedElement annotated) throws AnnotationValidationException {
        if (annotated instanceof Field) {
            Field field = (Field)annotated;
            Class<?> classConcrete = field.getDeclaringClass();
            String modifiers = Modifier.toString(field.getModifiers());
            if (this.visibility.equals("default") || this.visibility.equals("")) {
                if (!(modifiers.contains("public") || modifiers.contains("private") || modifiers.contains("protected"))) {
                    String error = this.getErrorMessage(classConcrete, field, toValidate.annotationType(), modifiers + " default", "default");
                    throw new AnnotationValidationException(error);
                }
            } else if (modifiers.contains(this.visibility)) {
                String error = this.getErrorMessage(classConcrete, field, toValidate.annotationType(), modifiers, this.visibility);
                throw new AnnotationValidationException(error);
            }
        }
    }

    private String getErrorMessage(Class<?> classConcrete, Field field, Class<? extends Annotation> classOfAnnotationInField, String modifiers, String visibility) {
        return "The field " + field.getName() + " in the " + classConcrete.getSimpleName() + " is using the @" + classOfAnnotationInField.getSimpleName() + " annotation, with this(these) modifier(s): " + modifiers + ", however it is forbidden to use this: " + visibility + ".\n";
    }
}

