/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.validate.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.esfinge.metadata.AnnotationValidationException;

public class UtilValidatorModifierMethodOnly {
    private String modifiersNameObliged = "";

    public void setModifiersNameObliged(String modifiersNameObliged) {
        this.modifiersNameObliged = modifiersNameObliged;
    }

    public void validate(Annotation toValidate, AnnotatedElement annotated) throws AnnotationValidationException {
        if (annotated instanceof Method) {
            Method method = (Method)annotated;
            Class<?> classConcrete = method.getDeclaringClass();
            String modifiers = Modifier.toString(method.getModifiers());
            if (!modifiers.contains(this.modifiersNameObliged)) {
                if (modifiers.equals("")) {
                    modifiers = "default";
                }
                String error = this.getErrorMessage(classConcrete, method, toValidate.annotationType(), this.modifiersNameObliged, modifiers);
                throw new AnnotationValidationException(error);
            }
        }
    }

    private String getErrorMessage(Class<?> classConcrete, Method method, Class<? extends Annotation> classOfAnnotationInField, String modifiersNameObliged, String modifiers) {
        return "The method " + method.getName() + " in the " + classConcrete.getSimpleName() + " is using the @" + classOfAnnotationInField.getSimpleName() + " annotation, however it has no " + modifiersNameObliged + " modifier.\n(it has this(these) modifier(s): " + modifiers + " )";
    }
}

