/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.validate.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.AnnotationValidator;
import net.sf.esfinge.metadata.annotation.validator.method.ValidMethodReturn;

public class ValidatorValidMethodReturn
implements AnnotationValidator {
    private Class<?>[] validTypesToReturn = null;

    @Override
    public void initialize(Annotation self) {
        ValidMethodReturn vmr = (ValidMethodReturn)self;
        this.validTypesToReturn = vmr.validTypesToReturn();
    }

    @Override
    public void validate(Annotation toValidate, AnnotatedElement annotated) throws AnnotationValidationException {
        if (annotated instanceof Method) {
            Method method = (Method)annotated;
            Class<?> classConcrete = method.getDeclaringClass();
            Class<?> type = method.getReturnType();
            boolean found = false;
            for (Class<?> oneValidType : this.validTypesToReturn) {
                if (!oneValidType.isAssignableFrom(type)) continue;
                found = true;
            }
            if (!found) {
                String error = this.getErrorMessage(classConcrete, method, toValidate.annotationType(), type, this.validTypesToReturn);
                throw new AnnotationValidationException(error);
            }
        }
    }

    public String getErrorMessage(Class<?> clazz, Method method, Class<? extends Annotation> classOfAnnotationInField, Class<?> type, Class<?>[] listInvalidTypes) {
        StringBuilder concatedListTypes = new StringBuilder();
        concatedListTypes.append("[");
        for (Class<?> oneType : listInvalidTypes) {
            concatedListTypes.append(oneType.getSimpleName());
            concatedListTypes.append(", ");
        }
        concatedListTypes.append("]");
        return "The method " + method.getName() + " in the " + clazz.getSimpleName() + " is using the @" + classOfAnnotationInField.getSimpleName() + " annotation, its return type is " + type.getSimpleName() + ", however it is not in the list of valid types (list: " + concatedListTypes.toString() + ") .";
    }
}

