/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.metadata.validate.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.AnnotationValidator;
import net.sf.esfinge.metadata.annotation.validator.method.ValidNumberOfParameters;

public class ValidatorValidNumberOfParameters
implements AnnotationValidator {
    private int numberOfParameters = 0;

    @Override
    public void initialize(Annotation self) {
        ValidNumberOfParameters vnp = (ValidNumberOfParameters)self;
        this.numberOfParameters = vnp.numberOfParameters();
    }

    @Override
    public void validate(Annotation toValidate, AnnotatedElement annotated) throws AnnotationValidationException {
        if (annotated instanceof Method) {
            Method method = (Method)annotated;
            Class<?> classConcrete = method.getDeclaringClass();
            int countParameters = method.getParameterCount();
            if (countParameters != this.numberOfParameters) {
                String error = this.getErrorMessage(classConcrete, method, toValidate.annotationType(), countParameters);
                throw new AnnotationValidationException(error);
            }
        }
    }

    private String getErrorMessage(Class<?> classConcrete, Method method, Class<? extends Annotation> classOfAnnotationInField, int countParameters) {
        return "The method " + method.getName() + " in the " + classConcrete.getSimpleName() + " is using the @" + classOfAnnotationInField.getSimpleName() + " annotation, its parameters count are: " + countParameters + ", however it needs to have " + this.numberOfParameters + " parameters.";
    }
}

