/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.BackupDescriptor;
import org.exist.backup.FileSystemBackupDescriptor;
import org.exist.backup.ZipArchiveBackupDescriptor;

public class BackupDirectory {
    public static final Logger LOG = Logger.getLogger((Class)BackupDirectory.class);
    public static final String FILE_REGEX = "(full|inc)(\\d{8}-\\d{4}).*";
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmm");
    private File dir;
    private Matcher matcher;

    public BackupDirectory(String dirPath) {
        this(new File(dirPath));
    }

    public BackupDirectory(File directory) {
        this.dir = directory;
        Pattern pattern = Pattern.compile(FILE_REGEX);
        this.matcher = pattern.matcher("");
    }

    public File createBackup(boolean incremental, boolean zip) {
        StringBuffer buf;
        File file;
        int counter = 0;
        do {
            buf = new StringBuffer();
            buf.append(incremental ? "inc" : "full");
            buf.append(DATE_FORMAT.format(new Date()));
            if (counter++ > 0) {
                buf.append('_').append(counter);
            }
            if (!zip) continue;
            buf.append(".zip");
        } while ((file = new File(this.dir, buf.toString())).exists());
        return file;
    }

    public BackupDescriptor lastBackupFile() {
        File[] files = this.dir.listFiles(new FileFilter(){

            public boolean accept(File path) {
                return path.isFile();
            }
        });
        File newest = null;
        Date newestDate = null;
        for (int i = 0; i < files.length; ++i) {
            this.matcher.reset(files[i].getName());
            if (!this.matcher.matches()) continue;
            String dateTime = this.matcher.group(2);
            try {
                Date date = DATE_FORMAT.parse(dateTime);
                if (newestDate != null && !date.after(newestDate)) continue;
                newestDate = date;
                newest = files[i];
                continue;
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        AbstractBackupDescriptor descriptor = null;
        if (newest != null) {
            try {
                descriptor = newest.getName().endsWith(".zip") || newest.getName().endsWith(".ZIP") ? new ZipArchiveBackupDescriptor(newest) : new FileSystemBackupDescriptor(new File(newest + "/db", "__contents__.xml"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return descriptor;
    }
}

