/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.exist.EXistException;
import org.exist.backup.ConsistencyCheck;
import org.exist.backup.ErrorReport;
import org.exist.backup.SystemExport;
import org.exist.security.SecurityManager;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;

public class ExportMain {
    private static final int HELP_OPT = 104;
    private static final int EXPORT_OPT = 120;
    private static final int OUTPUT_DIR_OPT = 100;
    private static final int CONFIG_OPT = 99;
    private static final int INCREMENTAL_OPT = 105;
    private static final int DIRECT_ACCESS_OPT = 68;
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print help on command line options and exit."), new CLOptionDescriptor("dir", 2, 100, "the directory to which all output will be written."), new CLOptionDescriptor("config", 2, 99, "the database configuration (conf.xml) file to use for launching the db."), new CLOptionDescriptor("direct", 8, 68, "use an (even more) direct access to the db, bypassing some index structures"), new CLOptionDescriptor("export", 8, 120, "export database contents while preserving as much data as possible"), new CLOptionDescriptor("incremental", 8, 105, "create incremental backup (use with --export|-x)")};
    static /* synthetic */ Class class$org$exist$backup$ExportMain;

    protected static BrokerPool startDB(String configFile) {
        try {
            Configuration config = configFile == null ? new Configuration() : new Configuration(configFile, null);
            BrokerPool.configure(1, 5, config);
            return BrokerPool.getInstance();
        }
        catch (DatabaseConfigurationException e) {
            System.err.println("ERROR: Failed to open database: " + e.getMessage());
        }
        catch (EXistException e) {
            System.err.println("ERROR: Failed to open database: " + e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CLArgsParser optParser = new CLArgsParser(args, OPTIONS);
        if (optParser.getErrorString() != null) {
            System.err.println("ERROR: " + optParser.getErrorString());
            return;
        }
        boolean export = false;
        boolean incremental = false;
        boolean direct = false;
        String exportTarget = "export/";
        String dbConfig = null;
        Vector opt = optParser.getArguments();
        int size = opt.size();
        block13: for (int i = 0; i < size; ++i) {
            CLOption option = (CLOption)opt.get(i);
            switch (option.getId()) {
                case 104: {
                    System.out.println("Usage: java " + (class$org$exist$backup$ExportMain == null ? ExportMain.class$("org.exist.backup.ExportMain") : class$org$exist$backup$ExportMain).getName() + " [options]");
                    System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString());
                    System.exit(0);
                    continue block13;
                }
                case 100: {
                    exportTarget = option.getArgument();
                    continue block13;
                }
                case 68: {
                    direct = true;
                    continue block13;
                }
                case 99: {
                    dbConfig = option.getArgument();
                    continue block13;
                }
                case 120: {
                    export = true;
                    continue block13;
                }
                case 105: {
                    incremental = true;
                }
            }
        }
        BrokerPool pool = ExportMain.startDB(dbConfig);
        if (pool == null) {
            System.exit(1);
        }
        int retval = 0;
        DBBroker broker = null;
        try {
            broker = pool.get(SecurityManager.SYSTEM_USER);
            ConsistencyCheck checker = new ConsistencyCheck(broker, direct);
            List errors = checker.checkAll(new CheckCallback());
            if (errors.size() > 0) {
                System.err.println("ERRORS FOUND.");
                retval = 1;
            } else {
                System.out.println("No errors.");
            }
            if (export) {
                File dir = new File(exportTarget);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                SystemExport sysexport = new SystemExport(broker, new Callback(), direct);
                sysexport.export(exportTarget, incremental, true, errors);
            }
        }
        catch (EXistException e) {
            System.err.println("ERROR: Failed to retrieve database broker: " + e.getMessage());
            retval = 2;
        }
        finally {
            pool.release(broker);
            BrokerPool.stopAll(false);
        }
        System.exit(retval);
    }

    private static class CheckCallback
    implements ConsistencyCheck.ProgressCallback {
        private CheckCallback() {
        }

        public void startDocument(String path) {
        }

        public void startCollection(String path) {
        }

        public void error(ErrorReport error) {
            System.out.println(error.toString());
        }
    }

    private static class Callback
    implements SystemExport.StatusCallback {
        private Callback() {
        }

        public void startCollection(String path) {
            System.out.println("Entering collection " + path + " ...");
        }

        public void startDocument(String name, int count, int docsCount) {
            System.out.println("Writing document " + name + " [" + count + " of " + docsCount + ']');
        }

        public void error(String message, Throwable exception) {
            System.err.println(message);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }
}

