/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.exist.storage.ElementIndex;
import org.exist.storage.TextSearchEngine;
import org.exist.util.ProgressIndicator;

public class RestoreDialog
extends JDialog {
    JTextField currentCollection;
    JTextField currentBackup;
    JTextField resource;
    JTextArea messages;
    JProgressBar progress;
    Observer progressObserver = new UploadProgressObserver();

    public RestoreDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.setupComponents();
        this.setSize(new Dimension(350, 200));
        this.pack();
    }

    private void setupComponents() {
        GridBagLayout grid = new GridBagLayout();
        this.getContentPane().setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        JLabel label = new JLabel("Backup:");
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.currentBackup = new JTextField(50);
        this.currentBackup.setEditable(false);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.currentBackup, c);
        this.getContentPane().add(this.currentBackup);
        label = new JLabel("Collection:");
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.currentCollection = new JTextField(50);
        this.currentCollection.setEditable(false);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.currentCollection, c);
        this.getContentPane().add(this.currentCollection);
        label = new JLabel("Restoring:");
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.resource = new JTextField(40);
        this.resource.setEditable(false);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.resource, c);
        this.getContentPane().add(this.resource);
        label = new JLabel("Progress:");
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        this.progress.setString("");
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.progress, c);
        this.getContentPane().add(this.progress);
        this.messages = new JTextArea(5, 50);
        this.messages.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.messages, 22, 31);
        scroll.setBorder(BorderFactory.createTitledBorder("Messages"));
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(scroll, c);
        this.getContentPane().add(scroll);
    }

    public void setBackup(String backup) {
        this.currentBackup.setText(backup);
    }

    public void setCollection(String collection) {
        this.currentCollection.setText(collection);
    }

    public void setResource(String current) {
        this.resource.setText(current);
    }

    public void displayMessage(String message) {
        this.messages.append(message + '\n');
        this.messages.setCaretPosition(this.messages.getDocument().getLength());
    }

    public Observer getObserver() {
        return this.progressObserver;
    }

    class UploadProgressObserver
    implements Observer {
        int mode = 0;

        UploadProgressObserver() {
        }

        public void update(Observable o, Object arg) {
            RestoreDialog.this.progress.setIndeterminate(false);
            ProgressIndicator ind = (ProgressIndicator)arg;
            RestoreDialog.this.progress.setValue(ind.getPercentage());
            if (o instanceof TextSearchEngine) {
                RestoreDialog.this.progress.setString("Storing words");
            } else if (o instanceof ElementIndex) {
                RestoreDialog.this.progress.setString("Storing elements");
            } else {
                RestoreDialog.this.progress.setString("Storing nodes");
            }
        }
    }
}

