/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Random;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import jline.Terminal;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.apache.log4j.Logger;
import org.exist.client.ClientFrame;
import org.exist.client.CommandlineOptions;
import org.exist.client.DocumentView;
import org.exist.client.QueryDialog;
import org.exist.client.ResourceDescriptor;
import org.exist.client.UploadDialog;
import org.exist.dom.XMLUtil;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.storage.ElementIndex;
import org.exist.storage.TextSearchEngine;
import org.exist.util.CollectionScanner;
import org.exist.util.ConfigurationHelper;
import org.exist.util.DirectoryScanner;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.Occurrences;
import org.exist.util.ProgressBar;
import org.exist.util.ProgressIndicator;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.validation.service.ValidationService;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XPathQueryServiceImpl;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.util.URIUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.XPathQueryService;
import org.xmldb.api.modules.XUpdateQueryService;

public class InteractiveClient {
    private static final String ANSI_CYAN = "\u001b[0;36m";
    private static final String ANSI_WHITE = "\u001b[0;37m";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String URI = "uri";
    public static final String CONFIGURATION = "configuration";
    public static final String DRIVER = "driver";
    protected static String EDIT_CMD = "xemacs $file";
    protected static String ENCODING = "ISO-8859-1";
    protected static String PASS = null;
    protected static String URI_DEFAULT = "xmldb:exist://localhost:8080/exist/xmlrpc";
    protected static String USER_DEFAULT = "admin";
    protected static int PARALLEL_THREADS = 5;
    protected static Properties defaultProps = new Properties();
    protected static final int[] colSizes = new int[]{10, 10, 10, -1};
    protected static String driver = "org.exist.xmldb.DatabaseImpl";
    protected static String configuration = null;
    protected TreeSet completitions;
    protected LinkedList queryHistory;
    protected File queryHistoryFile;
    protected File historyFile;
    protected ConsoleReader console;
    protected Collection current;
    protected int nextInSet;
    protected int maxResults;
    protected XmldbURI path;
    protected Properties properties;
    protected String[] resources;
    protected ResourceSet result;
    protected HashMap namespaceMappings;
    protected int filesCount;
    protected long totalLength;
    protected boolean quiet;
    protected boolean verbose;
    protected boolean recurseDirs;
    protected boolean startGUI;
    protected Writer traceWriter;
    protected ClientFrame frame;
    private static Logger LOG = Logger.getLogger((String)InteractiveClient.class.getName());

    public InteractiveClient() {
        defaultProps.setProperty(DRIVER, driver);
        defaultProps.setProperty(URI, URI_DEFAULT);
        defaultProps.setProperty(USER, USER_DEFAULT);
        defaultProps.setProperty("editor", EDIT_CMD);
        defaultProps.setProperty("indent", "true");
        defaultProps.setProperty("encoding", ENCODING);
        defaultProps.setProperty("colors", "false");
        defaultProps.setProperty("permissions", "false");
        defaultProps.setProperty("expand-xincludes", "true");
        this.completitions = new TreeSet();
        this.queryHistory = new LinkedList();
        this.console = null;
        this.current = null;
        this.nextInSet = 1;
        this.maxResults = 10;
        this.path = XmldbURI.ROOT_COLLECTION_URI;
        this.resources = null;
        this.result = null;
        this.namespaceMappings = new HashMap();
        this.filesCount = 0;
        this.totalLength = 0L;
        this.quiet = false;
        this.verbose = false;
        this.recurseDirs = true;
        this.startGUI = true;
        this.traceWriter = null;
    }

    protected void displayHelp() {
        this.messageln("--- general commands ---");
        this.messageln("ls                   list collection contents");
        this.messageln("cd [collection|..]   change current collection");
        this.messageln("put [file pattern] upload file or directory to the database");
        this.messageln("edit [resource] open the resource for editing");
        this.messageln("mkcol collection     create new sub-collection in current collection");
        this.messageln("rm document          remove document from current collection");
        this.messageln("rmcol collection     remove collection");
        this.messageln("set [key=value]      set property. Calling set without ");
        this.messageln("                     argument shows current settings.");
        this.messageln("validate [document]  validate xml document with system xml catalog.");
        this.messageln("validate [document] [grammar]  validate xml document with ");
        this.messageln("                     specified grammar document.");
        this.messageln("\n--- search commands ---");
        this.messageln("find xpath-expr      execute the given XPath expression.");
        this.messageln("show [position]      display query result value at position.");
        this.messageln("\n--- user management (may require dba rights) ---");
        this.messageln("users                list existing users.");
        this.messageln("adduser username     create a new user.");
        this.messageln("passwd username      change password for user. ");
        this.messageln("chown user group [resource]");
        this.messageln("                     change resource ownership. chown without");
        this.messageln("                     resource changes ownership of the current");
        this.messageln("                     collection.");
        this.messageln("chmod [resource] permissions");
        this.messageln("                     change resource permissions. Format:");
        this.messageln("                     [user|group|other]=[+|-][read|write|update].");
        this.messageln("                     chmod without resource changes permissions for");
        this.messageln("                     the current collection.");
        this.messageln("lock resource        put a write lock on the specified resource.");
        this.messageln("unlock resource      remove a write lock from the specified resource.");
        this.messageln("quit                 quit the program");
    }

    public static void main(String[] args) {
        try {
            InteractiveClient client = new InteractiveClient();
            client.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void connect() throws Exception {
        if (this.startGUI && this.frame != null) {
            this.frame.setStatus("connecting to " + this.properties.getProperty(URI));
        }
        Class<?> cl = Class.forName(this.properties.getProperty(DRIVER));
        Database database = (Database)cl.newInstance();
        database.setProperty("create-database", "true");
        String configuration = this.properties.getProperty(CONFIGURATION);
        if (configuration != null && !"".equals(configuration)) {
            database.setProperty(CONFIGURATION, configuration);
        }
        DatabaseManager.registerDatabase((Database)database);
        this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
        if (this.startGUI && this.frame != null) {
            this.frame.setStatus("connected to " + this.properties.getProperty(URI) + " as user " + this.properties.getProperty(USER));
        }
    }

    protected Collection getCollection() {
        return this.current;
    }

    protected void reloadCollection() throws XMLDBException {
        this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
        this.getResources();
    }

    protected void setProperties() throws XMLDBException {
        Iterator<Object> i = this.properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.current.setProperty(key, this.properties.getProperty(key));
        }
    }

    protected void getResources() throws XMLDBException {
        Permission perm;
        int i;
        if (this.current == null) {
            return;
        }
        this.setProperties();
        UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
        String[] childCollections = this.current.listChildCollections();
        String[] childResources = this.current.listResources();
        this.resources = new String[childCollections.length + childResources.length];
        ArrayList<ResourceDescriptor> tableData = new ArrayList<ResourceDescriptor>(this.resources.length);
        String[] cols = new String[4];
        for (i = 0; i < childCollections.length; ++i) {
            Collection child = this.current.getChildCollection(childCollections[i]);
            perm = mgtService.getPermissions(child);
            if (this.properties.getProperty("permissions").equals("true")) {
                cols[0] = ((Object)perm).toString();
                cols[1] = perm.getOwner();
                cols[2] = perm.getOwnerGroup();
                cols[3] = URIUtils.urlDecodeUtf8(childCollections[i]);
                this.resources[i] = 'd' + InteractiveClient.formatString(cols, colSizes);
            } else {
                this.resources[i] = URIUtils.urlDecodeUtf8(childCollections[i]);
            }
            if (this.startGUI) {
                tableData.add(new ResourceDescriptor.Collection(XmldbURI.create(childCollections[i]), perm.getOwner(), perm.getOwnerGroup(), ((Object)perm).toString(), null));
            }
            this.completitions.add(childCollections[i]);
        }
        for (int j = 0; j < childResources.length; ++j) {
            Resource res = this.current.getResource(childResources[j]);
            perm = mgtService.getPermissions(res);
            if (perm == null) {
                System.out.println("null");
            }
            this.resources[i] = this.properties.getProperty("permissions").equals("true") ? '-' + ((Object)perm).toString() + '\t' + perm.getOwner() + '\t' + perm.getOwnerGroup() + '\t' + URIUtils.urlDecodeUtf8(childResources[j]) : URIUtils.urlDecodeUtf8(childResources[j]);
            Date lastModificationTime = ((EXistResource)res).getLastModificationTime();
            int n = i;
            this.resources[n] = this.resources[n] + "\t" + lastModificationTime;
            if (this.startGUI) {
                tableData.add(new ResourceDescriptor.Document(XmldbURI.create(childResources[j]), perm.getOwner(), perm.getOwnerGroup(), ((Object)perm).toString(), lastModificationTime));
            }
            this.completitions.add(childResources[j]);
            ++i;
        }
        if (this.startGUI) {
            this.frame.setResources(tableData);
        }
    }

    protected void more(String str) {
        LineNumberReader reader = new LineNumberReader(new StringReader(str));
        try {
            String line;
            while (System.in.available() > 0) {
                System.in.read();
            }
            while ((line = reader.readLine()) != null) {
                if (reader.getLineNumber() % 24 == 0) {
                    System.out.print("line: " + reader.getLineNumber() + "; press [return] for more or [q] for quit.");
                    int ch = System.in.read();
                    if (ch == 113 || ch == 81) {
                        return;
                    }
                }
                System.out.println(line);
            }
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe);
        }
    }

    protected boolean process(String line) {
        String[] args;
        if (this.startGUI) {
            this.frame.setPath(this.path);
        }
        if (line.startsWith("find")) {
            args = new String[]{"find", line.substring(5)};
        } else {
            StreamTokenizer tok = new StreamTokenizer(new StringReader(line));
            tok.resetSyntax();
            tok.wordChars(33, Short.MAX_VALUE);
            tok.quoteChar(34);
            tok.whitespaceChars(32, 32);
            ArrayList<String> argList = new ArrayList<String>(3);
            try {
                int token;
                while ((token = tok.nextToken()) != -1) {
                    if (token != -3 && token != 34) continue;
                    argList.add(tok.sval);
                }
            }
            catch (IOException e) {
                System.err.println("Could not parse command line.");
                return true;
            }
            args = new String[argList.size()];
            argList.toArray(args);
        }
        if (args.length == 0) {
            return true;
        }
        try {
            XmldbURI newPath = this.path;
            XmldbURI currUri = XmldbURI.xmldbUriFor(this.properties.getProperty(URI)).resolveCollectionPath(this.path);
            if (args[0].equalsIgnoreCase("ls")) {
                this.getResources();
                if (this.properties.getProperty("permissions").equals("true")) {
                    for (int i = 0; i < this.resources.length; ++i) {
                        this.messageln(this.resources[i]);
                    }
                } else {
                    for (int i = 0; i < this.resources.length; ++i) {
                        StringBuffer buf = new StringBuffer();
                        int k = 0;
                        int j = 0;
                        while (i < this.resources.length && j < 5) {
                            buf.append(this.resources[i] + '\t');
                            k = j++;
                            ++i;
                        }
                        if (k == 4 && i < this.resources.length) {
                            --i;
                        }
                        this.messageln(buf.toString());
                    }
                }
            } else if (args[0].equalsIgnoreCase("cd")) {
                Collection temp;
                this.completitions.clear();
                XmldbURI collectionPath = args.length < 2 || args[1] == null ? XmldbURI.ROOT_COLLECTION_URI : XmldbURI.xmldbUriFor(URIUtils.urlEncodeUtf8(args[1]));
                collectionPath = currUri.resolveCollectionPath(collectionPath);
                if (collectionPath.numSegments() == 0) {
                    collectionPath = currUri.resolveCollectionPath(XmldbURI.ROOT_COLLECTION_URI);
                    this.messageln("cannot go above " + XmldbURI.ROOT_COLLECTION_URI.toString());
                }
                if ((temp = DatabaseManager.getCollection((String)collectionPath.toString(), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD))) != null) {
                    this.current = temp;
                    newPath = collectionPath.toCollectionPathURI();
                    if (this.startGUI) {
                        this.frame.setPath(collectionPath.toCollectionPathURI());
                    }
                } else {
                    this.messageln("no such collection.");
                }
                this.getResources();
            } else if (args[0].equalsIgnoreCase("cp")) {
                XmldbURI dest;
                XmldbURI src;
                if (args.length != 3) {
                    this.messageln("cp requires two arguments.");
                    return true;
                }
                try {
                    src = URIUtils.encodeXmldbUriFor(args[1]);
                    dest = URIUtils.encodeXmldbUriFor(args[2]);
                }
                catch (URISyntaxException e) {
                    this.messageln("could not parse collection name into a valid URI: " + e.getMessage());
                    return false;
                }
                this.copy(src, dest);
                this.getResources();
            } else if (args[0].equalsIgnoreCase("edit")) {
                if (args.length == 2) {
                    XmldbURI resource;
                    try {
                        resource = URIUtils.encodeXmldbUriFor(args[1]);
                    }
                    catch (URISyntaxException e) {
                        this.messageln("could not parse resource name into a valid URI: " + e.getMessage());
                        return false;
                    }
                    this.editResource(resource);
                } else {
                    this.messageln("Please specify a resource.");
                }
            } else {
                if (args[0].equalsIgnoreCase("get")) {
                    XmldbURI resource;
                    if (args.length < 2) {
                        System.err.println("wrong number of arguments.");
                        return true;
                    }
                    try {
                        resource = URIUtils.encodeXmldbUriFor(args[1]);
                    }
                    catch (URISyntaxException e) {
                        this.messageln("could not parse resource name into a valid URI: " + e.getMessage());
                        return false;
                    }
                    Resource res = this.retrieve(resource);
                    if (res != null) {
                        String data = res.getResourceType().equals("XMLResource") ? (String)res.getContent() : new String((byte[])res.getContent());
                        if (this.startGUI) {
                            this.frame.setEditable(false);
                            this.frame.display(data);
                            this.frame.setEditable(true);
                        } else {
                            String content = data;
                            this.more(content);
                        }
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("find")) {
                    if (args.length < 2) {
                        this.messageln("no query argument found.");
                        return true;
                    }
                    this.messageln(args[1]);
                    long start = System.currentTimeMillis();
                    this.result = this.find(args[1]);
                    if (this.result == null) {
                        this.messageln("nothing found");
                    } else {
                        this.messageln("found " + this.result.getSize() + " hits in " + (System.currentTimeMillis() - start) + "ms.");
                    }
                    this.nextInSet = 1;
                } else if (args[0].equalsIgnoreCase("run")) {
                    if (args.length < 2) {
                        this.messageln("please specify a query file.");
                        return true;
                    }
                    try {
                        String nextLine;
                        BufferedReader reader = new BufferedReader(new FileReader(args[1]));
                        StringBuffer buf = new StringBuffer();
                        while ((nextLine = reader.readLine()) != null) {
                            buf.append(nextLine);
                            buf.append('\n');
                        }
                        args[1] = buf.toString();
                        long start = System.currentTimeMillis();
                        this.result = this.find(args[1]);
                        if (this.result == null) {
                            this.messageln("nothing found");
                        } else {
                            this.messageln("found " + this.result.getSize() + " hits in " + (System.currentTimeMillis() - start) + "ms.");
                        }
                        this.nextInSet = 1;
                    }
                    catch (Exception e) {
                        this.messageln("An error occurred: " + e.getMessage());
                    }
                } else {
                    if (args[0].equalsIgnoreCase("show")) {
                        if (this.result == null) {
                            this.messageln("no result set.");
                            return true;
                        }
                        try {
                            int start = this.nextInSet;
                            int count = 1;
                            if (args.length > 1) {
                                start = Integer.parseInt(args[1]);
                            }
                            if (args.length > 2) {
                                count = Integer.parseInt(args[2]);
                            }
                            int s = (int)this.result.getSize();
                            if (start < 1 || start > s) {
                                this.messageln("start offset out of range");
                                return true;
                            }
                            if (--start + count > s) {
                                count = s - start;
                            }
                            this.nextInSet = start + count + 1;
                            for (int i = start; i < start + count; ++i) {
                                Resource r = this.result.getResource((long)i);
                                if (this.startGUI) {
                                    this.frame.display((String)r.getContent());
                                    continue;
                                }
                                this.more((String)r.getContent());
                            }
                            this.messageln("displayed items " + (start + 1) + " to " + (start + count) + " of " + this.result.getSize());
                        }
                        catch (NumberFormatException nfe) {
                            this.messageln("wrong argument");
                            return true;
                        }
                    }
                    if (args[0].equalsIgnoreCase("mkcol")) {
                        XmldbURI collUri;
                        if (args.length < 2) {
                            this.messageln("missing argument.");
                            return true;
                        }
                        try {
                            collUri = URIUtils.encodeXmldbUriFor(args[1]);
                        }
                        catch (URISyntaxException e) {
                            this.messageln("could not parse collection name into a valid URI: " + e.getMessage());
                            return false;
                        }
                        CollectionManagementServiceImpl mgtService = (CollectionManagementServiceImpl)this.current.getService("CollectionManagementService", "1.0");
                        Collection newCollection = mgtService.createCollection(collUri);
                        if (newCollection == null) {
                            this.messageln("could not create collection.");
                        } else {
                            this.messageln("created collection.");
                        }
                        this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
                        this.getResources();
                    } else {
                        if (args[0].equalsIgnoreCase("put")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            boolean r = this.parse(args[1]);
                            this.getResources();
                            return r;
                        }
                        if (args[0].equalsIgnoreCase("blob")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            this.storeBinary(args[1]);
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("rm")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            this.remove(args[1]);
                            this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("rmcol")) {
                            XmldbURI collUri;
                            if (args.length < 2) {
                                this.messageln("wrong argument count.");
                                return true;
                            }
                            try {
                                collUri = URIUtils.encodeXmldbUriFor(args[1]);
                            }
                            catch (URISyntaxException e) {
                                this.messageln("could not parse collection name into a valid URI: " + e.getMessage());
                                return false;
                            }
                            this.rmcol(collUri);
                            this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("adduser")) {
                            if (args.length < 2) {
                                System.err.println("Usage: adduser name");
                                return true;
                            }
                            if (this.startGUI) {
                                this.messageln("command not supported in GUI mode. Please use the \"Edit users\" menu option.");
                                return true;
                            }
                            try {
                                String p2;
                                String p1;
                                UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                while (!(p1 = this.console.readLine("password: ", new Character('*'))).equals(p2 = this.console.readLine("re-enter password: ", new Character('*')))) {
                                    System.out.println("\nentered passwords differ. Try again...");
                                }
                                String home = this.console.readLine("home collection [none]: ");
                                User user = new User(args[1], p1);
                                if (home != null && home.length() > 0) {
                                    user.setHome(URIUtils.encodeXmldbUriFor(home));
                                }
                                String groups = this.console.readLine("enter groups: ");
                                StringTokenizer tok = new StringTokenizer(groups, " ,");
                                while (tok.hasMoreTokens()) {
                                    String group = tok.nextToken();
                                    if (group.length() <= 0) continue;
                                    user.addGroup(group);
                                }
                                mgtService.addUser(user);
                                System.out.println("user " + user + " created.");
                            }
                            catch (Exception e) {
                                System.out.println("ERROR: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else if (args[0].equalsIgnoreCase("users")) {
                            UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                            User[] users = mgtService.getUsers();
                            System.out.println("User\t\tGroups");
                            System.out.println("-----------------------------------------");
                            for (int i = 0; i < users.length; ++i) {
                                System.out.print(users[i].getName() + "\t\t");
                                String[] groups = users[i].getGroups();
                                for (int j = 0; j < groups.length; ++j) {
                                    System.out.print(groups[j]);
                                    if (j + 1 >= groups.length) continue;
                                    System.out.print(", ");
                                }
                                System.out.println();
                            }
                        } else if (args[0].equalsIgnoreCase("passwd")) {
                            if (this.startGUI) {
                                this.messageln("command not supported in GUI mode. Please use the \"Edit users\" menu option.");
                                return true;
                            }
                            if (args.length < 2) {
                                System.out.println("Usage: passwd username");
                                return true;
                            }
                            try {
                                String p2;
                                String p1;
                                UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                User user = mgtService.getUser(args[1]);
                                if (user == null) {
                                    System.out.println("no such user.");
                                    return true;
                                }
                                while (!(p1 = this.console.readLine("password: ", new Character('*'))).equals(p2 = this.console.readLine("re-enter password: ", new Character('*')))) {
                                    System.out.println("\nentered passwords differ. Try again...");
                                }
                                user.setPassword(p1);
                                mgtService.updateUser(user);
                                this.properties.setProperty(PASSWORD, p1);
                            }
                            catch (Exception e) {
                                System.err.println("ERROR: " + e.getMessage());
                            }
                        } else if (args[0].equalsIgnoreCase("chmod")) {
                            if (args.length < 2) {
                                System.out.println("Usage: chmod [resource] mode");
                                return true;
                            }
                            Collection temp = null;
                            if (args.length == 3) {
                                System.out.println("trying collection: " + args[1]);
                                temp = this.current.getChildCollection(args[1]);
                                if (temp == null) {
                                    System.out.println("\ntrying resource: " + args[1]);
                                    Resource r = this.current.getResource(args[1]);
                                    if (r != null) {
                                        UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                        mgtService.chmod(r, args[2]);
                                    } else {
                                        System.err.println("Resource " + args[1] + " not found.");
                                    }
                                } else {
                                    UserManagementService mgtService = (UserManagementService)temp.getService("UserManagementService", "1.0");
                                    mgtService.chmod(args[2]);
                                }
                            } else {
                                UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                mgtService.chmod(args[1]);
                            }
                            this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("chown")) {
                            if (args.length < 3) {
                                System.out.println("Usage: chown username group [resource]");
                                return true;
                            }
                            Collection temp = args.length == 4 ? this.current.getChildCollection(args[3]) : this.current;
                            if (temp != null) {
                                UserManagementService mgtService = (UserManagementService)temp.getService("UserManagementService", "1.0");
                                User u = mgtService.getUser(args[1]);
                                if (u == null) {
                                    System.out.println("unknown user");
                                    return true;
                                }
                                mgtService.chown(u, args[2]);
                                System.out.println("owner changed.");
                                this.getResources();
                                return true;
                            }
                            Resource res = this.current.getResource(args[3]);
                            if (res != null) {
                                UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                User u = mgtService.getUser(args[1]);
                                if (u == null) {
                                    System.out.println("unknown user");
                                    return true;
                                }
                                mgtService.chown(res, u, args[2]);
                                this.getResources();
                                return true;
                            }
                            System.err.println("Resource " + args[3] + " not found.");
                        } else if (args[0].equalsIgnoreCase("lock") || args[0].equalsIgnoreCase("unlock")) {
                            if (args.length < 2) {
                                this.messageln("Usage: lock resource");
                                return true;
                            }
                            Resource res = this.current.getResource(args[1]);
                            if (res != null) {
                                UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                User user = mgtService.getUser(this.properties.getProperty(USER, "guest"));
                                if (args[0].equalsIgnoreCase("lock")) {
                                    mgtService.lockResource(res, user);
                                } else {
                                    mgtService.unlockResource(res);
                                }
                            }
                        } else {
                            if (args[0].equalsIgnoreCase("elements")) {
                                System.out.println("Element occurrences in collection " + this.current.getName());
                                System.out.println("-------------------------------------------------------");
                                IndexQueryService service = (IndexQueryService)this.current.getService("IndexQueryService", "1.0");
                                Occurrences[] elements = service.getIndexedElements(true);
                                for (int i = 0; i < elements.length; ++i) {
                                    System.out.println(InteractiveClient.formatString(elements[i].getTerm().toString(), Integer.toString(elements[i].getOccurrences()), 50));
                                }
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("terms")) {
                                if (args.length < 3) {
                                    System.out.println("Usage: terms [xpath] sequence-start sequence-end");
                                    return true;
                                }
                                IndexQueryService service = (IndexQueryService)this.current.getService("IndexQueryService", "1.0");
                                Occurrences[] terms = args.length == 3 ? service.scanIndexTerms(args[1], args[2], true) : service.scanIndexTerms(args[1], args[2], args[3]);
                                System.out.println("Element occurrences in collection " + this.current.getName());
                                System.out.println("-------------------------------------------------------");
                                for (int i = 0; i < terms.length; ++i) {
                                    System.out.println(InteractiveClient.formatString(terms[i].getTerm().toString(), Integer.toString(terms[i].getOccurrences()), 50));
                                }
                            } else if (args[0].equalsIgnoreCase("xupdate")) {
                                if (this.startGUI) {
                                    this.messageln("command not supported in GUI mode.");
                                    return true;
                                }
                                String command = "";
                                try {
                                    String lastLine;
                                    while ((lastLine = this.console.readLine("| ")) != null && lastLine.length() != 0) {
                                        command = command + lastLine;
                                    }
                                }
                                catch (EOFException e) {
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                String xupdate = "<xu:modifications version=\"1.0\" xmlns:xu=\"http://www.xmldb.org/xupdate\">" + command + "</xu:modifications>";
                                XUpdateQueryService service = (XUpdateQueryService)this.current.getService("XUpdateQueryService", "1.0");
                                long mods = service.update(xupdate);
                                System.out.println(mods + " modifications processed.");
                            } else if (args[0].equalsIgnoreCase("map")) {
                                String prefix;
                                StringTokenizer tok = new StringTokenizer(args[1], "= ");
                                if (args[1].startsWith("=")) {
                                    prefix = "";
                                } else {
                                    if (tok.countTokens() < 2) {
                                        this.messageln("please specify a namespace/prefix mapping as: prefix=namespaceURI");
                                        return true;
                                    }
                                    prefix = tok.nextToken();
                                }
                                String uri = tok.nextToken();
                                this.namespaceMappings.put(prefix, uri);
                            } else if (args[0].equalsIgnoreCase("set")) {
                                if (args.length == 1) {
                                    this.properties.list(System.out);
                                } else {
                                    try {
                                        StringTokenizer tok = new StringTokenizer(args[1], "= ");
                                        if (tok.countTokens() < 2) {
                                            System.err.println("please specify a key=value pair");
                                            return true;
                                        }
                                        String key = tok.nextToken();
                                        String val = tok.nextToken();
                                        this.properties.setProperty(key, val);
                                        this.current.setProperty(key, val);
                                        this.getResources();
                                    }
                                    catch (Exception e) {
                                        System.err.println("Exception: " + e.getMessage());
                                    }
                                }
                            } else {
                                if (args[0].equalsIgnoreCase("shutdown")) {
                                    DatabaseInstanceManager mgr = (DatabaseInstanceManager)this.current.getService("DatabaseInstanceManager", "1.0");
                                    if (mgr == null) {
                                        this.messageln("Service is not available");
                                        return true;
                                    }
                                    mgr.shutdown();
                                    return true;
                                }
                                if (args[0].equalsIgnoreCase("help") || args[0].equals("?")) {
                                    this.displayHelp();
                                } else {
                                    if (args[0].equalsIgnoreCase("quit")) {
                                        return false;
                                    }
                                    if (args[0].equalsIgnoreCase("validate")) {
                                        if (args.length < 2) {
                                            this.messageln("missing document name.");
                                        } else {
                                            ValidationService validationService = (ValidationService)this.current.getService("ValidationService", "1.0");
                                            boolean valid = false;
                                            valid = args.length == 2 ? validationService.validateResource(args[1]) : validationService.validateResource(args[1], args[2]);
                                            if (valid) {
                                                this.messageln("document is valid.");
                                            } else {
                                                this.messageln("document is not valid.");
                                            }
                                        }
                                    } else {
                                        this.messageln("unknown command");
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.path = newPath;
            return true;
        }
        catch (Throwable e) {
            if (this.startGUI) {
                ClientFrame.showErrorMessage(InteractiveClient.getExceptionMessage(e), e);
            } else {
                this.messageln(InteractiveClient.getExceptionMessage(e));
                e.printStackTrace();
            }
            return true;
        }
    }

    private void editResource(XmldbURI name) {
        try {
            DocumentView view = new DocumentView(this, name, this.properties);
            view.setSize(new Dimension(640, 400));
            view.viewDocument();
        }
        catch (XMLDBException ex) {
            this.messageln("XMLDB error: " + ex.getMessage());
        }
    }

    private final ResourceSet find(String xpath) throws XMLDBException {
        if (xpath.charAt(xpath.length() - 1) == '\n') {
            xpath = xpath.substring(0, xpath.length() - 1);
        }
        if (this.traceWriter != null) {
            try {
                this.traceWriter.write("<query>");
                this.traceWriter.write(xpath);
                this.traceWriter.write("</query>\r\n");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String sortBy = null;
        int p = xpath.indexOf(" sort by ");
        if (p != -1) {
            String xp = xpath.substring(0, p);
            sortBy = xpath.substring(p + " sort by ".length());
            xpath = xp;
            System.out.println("XPath =   " + xpath);
            System.out.println("Sort-by = " + sortBy);
        }
        XPathQueryServiceImpl service = (XPathQueryServiceImpl)this.current.getService("XPathQueryService", "1.0");
        service.setProperty("indent", this.properties.getProperty("indent"));
        service.setProperty("encoding", this.properties.getProperty("encoding"));
        Iterator i = this.namespaceMappings.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry mapping = i.next();
            service.setNamespace((String)mapping.getKey(), (String)mapping.getValue());
        }
        return sortBy == null ? service.query(xpath) : service.query(xpath, sortBy);
    }

    private final void testQuery(String queryFile) {
        try {
            String line;
            File f = new File(queryFile);
            if (!f.canRead()) {
                System.err.println("can't read query file: " + queryFile);
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(f));
            ArrayList<String> queries = new ArrayList<String>(10);
            Thread thread = null;
            while ((line = reader.readLine()) != null) {
                queries.add(line);
            }
            for (int i = 0; i < PARALLEL_THREADS; ++i) {
                thread = new QueryThread(queries);
                thread.setName("QueryThread" + i);
                thread.start();
            }
            try {
                thread.join();
            }
            catch (InterruptedException e) {}
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: " + e);
        }
        catch (IOException e) {
            System.err.println("ERROR: " + e);
        }
    }

    protected final Resource retrieve(XmldbURI resource) throws XMLDBException {
        return this.retrieve(resource, this.properties.getProperty("indent"));
    }

    protected final Resource retrieve(XmldbURI resource, String indent) throws XMLDBException {
        Resource res = this.current.getResource(resource.toString());
        if (res == null) {
            this.messageln("document not found.");
            return null;
        }
        return res;
    }

    private final void remove(String pattern) throws XMLDBException {
        Collection collection = this.current;
        if (pattern.startsWith("/")) {
            System.err.println("path pattern should be relative to current collection");
            return;
        }
        Resource res = collection.getResource(pattern);
        Resource[] resources = res == null ? CollectionScanner.scan(collection, "", pattern) : new Resource[]{res};
        for (int i = 0; i < resources.length; ++i) {
            this.message("removing document " + resources[i].getId() + " ...");
            Collection parent = resources[i].getParentCollection();
            parent.removeResource(resources[i]);
            this.messageln("done.");
        }
    }

    private final void xupdate(String resource, String filename) throws XMLDBException, IOException {
        File file = new File(filename);
        if (!file.exists() || !file.canRead()) {
            this.messageln("cannot read file " + filename);
            return;
        }
        String commands = XMLUtil.readFile(file, "UTF-8");
        XUpdateQueryService service = (XUpdateQueryService)this.current.getService("XUpdateQueryService", "1.0");
        long modifications = 0L;
        modifications = resource == null ? service.update(commands) : service.updateResource(resource, commands);
        this.messageln(modifications + " modifications processed " + "successfully.");
    }

    private final void rmcol(XmldbURI collection) throws XMLDBException {
        CollectionManagementServiceImpl mgtService = (CollectionManagementServiceImpl)this.current.getService("CollectionManagementService", "1.0");
        this.message("removing collection " + collection + " ...");
        mgtService.removeCollection(collection);
        this.messageln("done.");
    }

    private final void copy(XmldbURI source, XmldbURI destination) throws XMLDBException {
        Resource srcDoc;
        CollectionManagementServiceImpl mgtService = (CollectionManagementServiceImpl)this.current.getService("CollectionManagementService", "1.0");
        XmldbURI destName = destination.lastSegment();
        Collection destCol = this.resolveCollection(destination);
        if (destCol == null) {
            destination = destination.numSegments() == 1 ? XmldbURI.create(this.current.getName()) : destination.removeLastSegment();
        }
        if ((srcDoc = this.resolveResource(source)) != null) {
            XmldbURI resourcePath = XmldbURI.create(srcDoc.getParentCollection().getName()).append(srcDoc.getId());
            this.messageln("Copying resource '" + resourcePath + "' to '" + destination + "'");
            mgtService.copyResource(resourcePath, destination, destName);
        } else {
            this.messageln("Copying collection '" + source + "' to '" + destination + "'");
            mgtService.copy(source, destination, destName);
        }
    }

    private final void reindex() throws XMLDBException {
        IndexQueryService service = (IndexQueryService)this.current.getService("IndexQueryService", "1.0");
        this.message("reindexing collection " + this.current.getName());
        service.reindexCollection();
        this.messageln("done.");
    }

    private final void storeBinary(String fileName) throws XMLDBException {
        File file = new File(fileName);
        if (file.canRead()) {
            MimeType mime = MimeTable.getInstance().getContentTypeFor(file.getName());
            BinaryResource resource = (BinaryResource)this.current.createResource(file.getName(), "BinaryResource");
            resource.setContent((Object)file);
            ((EXistResource)resource).setMimeType(mime == null ? "application/octet-stream" : mime.getName());
            this.current.storeResource((Resource)resource);
        }
    }

    private synchronized boolean findRecursive(Collection collection, File dir, XmldbURI base) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            XmldbURI next = base.append(files[i].getName());
            try {
                if (files[i].isDirectory()) {
                    this.messageln("entering directory " + files[i].getAbsolutePath());
                    Collection c = collection.getChildCollection(files[i].getName());
                    if (c == null) {
                        CollectionManagementServiceImpl mgtService = (CollectionManagementServiceImpl)collection.getService("CollectionManagementService", "1.0");
                        c = mgtService.createCollection(URIUtils.encodeXmldbUriFor(files[i].getName()));
                    }
                    if (c instanceof Observable && this.verbose) {
                        ProgressObserver observer = new ProgressObserver();
                        ((Observable)c).addObserver(observer);
                    }
                    this.findRecursive(c, files[i], next);
                    continue;
                }
                long start1 = System.currentTimeMillis();
                MimeType mimeType = MimeTable.getInstance().getContentTypeFor(files[i].getName());
                if (mimeType == null) {
                    this.messageln("File " + files[i].getName() + " has an unknown " + "suffix. Cannot determine file type.");
                    continue;
                }
                this.message("storing document " + files[i].getName() + " (" + i + " of " + files.length + ") " + "...");
                Resource document = collection.createResource(URIUtils.urlEncodeUtf8(files[i].getName()), mimeType.getXMLDBType());
                document.setContent((Object)files[i]);
                ((EXistResource)document).setMimeType(mimeType.getName());
                collection.storeResource(document);
                ++this.filesCount;
                this.messageln(" " + files[i].length() + " bytes in " + (System.currentTimeMillis() - start1) + "ms.");
                continue;
            }
            catch (URISyntaxException e) {
                this.messageln("uri syntax exception parsing " + files[i].getAbsolutePath() + ": " + e.getMessage());
                continue;
            }
            catch (XMLDBException e) {
                this.messageln("could not parse file " + files[i].getAbsolutePath() + ": " + e.getMessage());
            }
        }
        return true;
    }

    protected synchronized boolean parse(String fileName) throws XMLDBException {
        File[] files;
        fileName = fileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        File file = new File(fileName);
        if (this.current instanceof Observable && this.verbose) {
            ProgressObserver observer = new ProgressObserver();
            ((Observable)this.current).addObserver(observer);
        }
        if (file.canRead()) {
            if (file.isDirectory()) {
                if (this.recurseDirs) {
                    this.filesCount = 0;
                    long start = System.currentTimeMillis();
                    boolean result = this.findRecursive(this.current, file, this.path);
                    this.messageln("storing " + this.filesCount + " files took " + (System.currentTimeMillis() - start) / 1000L + "sec.");
                    return result;
                }
                files = file.listFiles();
            } else {
                files = new File[]{file};
            }
        } else {
            files = DirectoryScanner.scanDir(fileName);
        }
        long start0 = System.currentTimeMillis();
        long bytes = 0L;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) continue;
            long start = System.currentTimeMillis();
            MimeType mimeType = MimeTable.getInstance().getContentTypeFor(files[i].getName());
            if (mimeType == null) {
                mimeType = MimeType.BINARY_TYPE;
            }
            Resource document = this.current.createResource(files[i].getName(), mimeType.getXMLDBType());
            this.message("storing document " + files[i].getName() + " (" + (i + 1) + " of " + files.length + ") ...");
            document.setContent((Object)files[i]);
            ((EXistResource)document).setMimeType(mimeType.getName());
            this.current.storeResource(document);
            this.messageln("done.");
            this.messageln("parsing " + files[i].length() + " bytes took " + (System.currentTimeMillis() - start) + "ms.\n");
            bytes += files[i].length();
        }
        this.messageln("parsed " + bytes + " bytes in " + (System.currentTimeMillis() - start0) + "ms.");
        return true;
    }

    protected synchronized boolean parse(File[] files, UploadDialog upload) throws XMLDBException {
        if (!upload.isVisible()) {
            upload.setVisible(true);
        }
        if (this.current instanceof Observable) {
            ((Observable)this.current).addObserver(upload.getObserver());
        }
        upload.setTotalSize(this.calculateFileSizes(files));
        for (int i = 0; i < files.length && !upload.isCancelled(); ++i) {
            this.store(this.current, files[i], upload);
        }
        if (this.current instanceof Observable) {
            ((Observable)this.current).deleteObservers();
        }
        upload.uploadCompleted();
        return true;
    }

    private long calculateFileSizes(File[] files) throws XMLDBException {
        long size = 0L;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].canRead()) continue;
            if (files[i].isDirectory()) {
                size += this.calculateFileSizes(files[i].listFiles());
                continue;
            }
            size += files[i].length();
        }
        return size;
    }

    private void store(Collection collection, File file, UploadDialog upload) {
        XmldbURI filenameUri;
        if (upload.isCancelled()) {
            return;
        }
        if (!file.canRead()) {
            upload.showMessage(file.getAbsolutePath() + " impossible to read ");
            return;
        }
        try {
            filenameUri = URIUtils.encodeXmldbUriFor(file.getName());
        }
        catch (URISyntaxException e1) {
            upload.showMessage(file.getAbsolutePath() + " could not be encoded as a URI");
            return;
        }
        if (file.isDirectory()) {
            Collection c = null;
            try {
                c = collection.getChildCollection(filenameUri.toString());
                if (c == null) {
                    CollectionManagementServiceImpl mgtService = (CollectionManagementServiceImpl)collection.getService("CollectionManagementService", "1.0");
                    c = mgtService.createCollection(filenameUri);
                }
            }
            catch (XMLDBException e) {
                upload.showMessage("Impossible to create a collection " + file.getAbsolutePath() + ": " + e.getMessage());
            }
            upload.setCurrentDir(file.getAbsolutePath());
            if (c instanceof Observable) {
                ((Observable)c).addObserver(upload.getObserver());
            }
            File[] temp = file.listFiles();
            for (int i = 0; i < temp.length; ++i) {
                this.store(c, temp[i], upload);
            }
            return;
        }
        if (file.isFile()) {
            upload.reset();
            upload.setCurrent(file.getName());
            upload.setCurrentSize(file.length());
            MimeType mimeType = MimeTable.getInstance().getContentTypeFor(file.getName());
            if (mimeType == null) {
                upload.showMessage(file.getAbsolutePath() + " - unknown suffix. No matching mime-type found in : " + MimeTable.getInstance().getSrc());
                return;
            }
            try {
                Resource res = collection.createResource(filenameUri.toString(), mimeType.getXMLDBType());
                ((EXistResource)res).setMimeType(mimeType.getName());
                res.setContent((Object)file);
                collection.storeResource(res);
                ++this.filesCount;
                this.totalLength += file.length();
                upload.setStoredSize(this.totalLength);
            }
            catch (XMLDBException e) {
                upload.showMessage("Impossible to store a resource " + file.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    }

    private void mkcol(XmldbURI collPath) throws XMLDBException {
        System.out.println("creating '" + collPath + "'");
        XmldbURI[] segments = collPath.getPathSegments();
        XmldbURI p = XmldbURI.ROOT_COLLECTION_URI;
        for (int i = 1; i < segments.length; ++i) {
            p = p.append(segments[i]);
            Collection c = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + p), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
            if (c == null) {
                CollectionManagementServiceImpl mgtService = (CollectionManagementServiceImpl)this.current.getService("CollectionManagementService", "1.0");
                this.current = mgtService.createCollection(segments[i]);
                continue;
            }
            this.current = c;
        }
        this.path = p;
    }

    protected Collection getCollection(String path) throws XMLDBException {
        return DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
    }

    private char[] readPassword(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    private Properties loadClientProperties() {
        Properties clientProps = new Properties();
        File propFile = ConfigurationHelper.lookup("client.properties");
        InputStream pin = null;
        try {
            pin = new FileInputStream(propFile);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        if (pin == null) {
            pin = InteractiveClient.class.getResourceAsStream("client.properties");
        }
        if (pin != null) {
            try {
                clientProps.load(pin);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return clientProps;
    }

    protected CommandlineOptions getCommandlineOptions(String[] args, Properties props) {
        CLArgsParser optParser = new CLArgsParser(args, CommandlineOptions.OPTIONS);
        if (optParser.getErrorString() != null) {
            System.err.println("ERROR: " + optParser.getErrorString());
            return null;
        }
        Vector opt = optParser.getArguments();
        int size = opt.size();
        CommandlineOptions cOpt = new CommandlineOptions();
        block46: for (int i = 0; i < size; ++i) {
            CLOption option = (CLOption)opt.get(i);
            switch (option.getId()) {
                case 104: {
                    this.printUsage();
                    return null;
                }
                case 115: {
                    this.startGUI = false;
                    continue block46;
                }
                case 78: {
                    props.setProperty("NO_EMBED_MODE", "TRUE");
                    continue block46;
                }
                case 113: {
                    this.quiet = true;
                    continue block46;
                }
                case 118: {
                    this.verbose = true;
                    continue block46;
                }
                case 108: {
                    props.setProperty(URI, XmldbURI.EMBEDDED_SERVER_URI.toString());
                    continue block46;
                }
                case 117: {
                    props.setProperty(USER, option.getArgument());
                    if (cOpt.passwdSpecified) continue block46;
                    cOpt.needPasswd = true;
                    continue block46;
                }
                case 80: {
                    props.setProperty(PASSWORD, option.getArgument());
                    cOpt.needPasswd = false;
                    cOpt.passwdSpecified = true;
                    continue block46;
                }
                case 67: {
                    this.properties.setProperty(CONFIGURATION, option.getArgument());
                    continue block46;
                }
                case 99: {
                    try {
                        this.path = URIUtils.encodeXmldbUriFor(option.getArgument());
                        cOpt.foundCollection = true;
                        continue block46;
                    }
                    catch (URISyntaxException e) {
                        System.err.println("Invalid collection path specified: " + e.getMessage());
                        return null;
                    }
                }
                case 102: {
                    cOpt.optionResource = option.getArgument();
                    continue block46;
                }
                case 79: {
                    cOpt.optionOutputFile = option.getArgument();
                    continue block46;
                }
                case 112: {
                    cOpt.doStore = true;
                    if (option.getArgumentCount() == 1) {
                        cOpt.optionalArgs.add(option.getArgument());
                    }
                    cOpt.interactive = false;
                    continue block46;
                }
                case 100: {
                    this.recurseDirs = true;
                    continue block46;
                }
                case 114: {
                    cOpt.optionRemove = option.getArgument();
                    cOpt.interactive = false;
                    continue block46;
                }
                case 103: {
                    try {
                        cOpt.optionGet = URIUtils.encodeXmldbUriFor(option.getArgument());
                        cOpt.interactive = false;
                        continue block46;
                    }
                    catch (URISyntaxException e) {
                        System.err.println("Invalid collection path specified: " + e.getMessage());
                        return null;
                    }
                }
                case 109: {
                    try {
                        cOpt.optionMkcol = URIUtils.encodeXmldbUriFor(option.getArgument());
                        cOpt.foundCollection = true;
                        continue block46;
                    }
                    catch (URISyntaxException e) {
                        System.err.println("Invalid collection path specified: " + e.getMessage());
                        return null;
                    }
                }
                case 82: {
                    try {
                        cOpt.optionRmcol = URIUtils.encodeXmldbUriFor(option.getArgument());
                        cOpt.foundCollection = true;
                        cOpt.interactive = false;
                        continue block46;
                    }
                    catch (URISyntaxException e) {
                        System.err.println("Invalid collection path specified: " + e.getMessage());
                        return null;
                    }
                }
                case 120: {
                    cOpt.optionXpath = option.getArgumentCount() == 1 ? option.getArgument() : "stdin";
                    cOpt.interactive = false;
                    continue block46;
                }
                case 110: {
                    try {
                        this.maxResults = Integer.parseInt(option.getArgument());
                        continue block46;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("parameter -n needs a valid number");
                        return null;
                    }
                }
                case 111: {
                    this.properties.setProperty(option.getArgument(0), option.getArgument(1));
                    continue block46;
                }
                case 70: {
                    cOpt.optionQueryFile = option.getArgument();
                    cOpt.interactive = false;
                    continue block46;
                }
                case 116: {
                    try {
                        PARALLEL_THREADS = Integer.parseInt(option.getArgument());
                    }
                    catch (NumberFormatException e) {
                        System.err.println("parameter -t needs a valid number");
                    }
                    continue block46;
                }
                case 88: {
                    cOpt.optionXUpdate = option.getArgument();
                    cOpt.interactive = false;
                    continue block46;
                }
                case 84: {
                    String traceFile = option.getArgument();
                    File f = new File(traceFile);
                    try {
                        this.traceWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(f, false), "UTF-8");
                        this.traceWriter.write("<?xml version=\"1.0\"?>\r\n");
                        this.traceWriter.write("<query-log>\r\n");
                    }
                    catch (UnsupportedEncodingException e1) {
                        LOG.warn((Object)e1);
                    }
                    catch (FileNotFoundException e1) {
                        this.messageln("Cannot open file " + traceFile);
                    }
                    catch (IOException e) {}
                    continue block46;
                }
                case 105: {
                    cOpt.doReindex = true;
                    cOpt.interactive = false;
                    continue block46;
                }
                case 81: {
                    cOpt.openQueryGui = true;
                    continue block46;
                }
                case 0: {
                    cOpt.optionalArgs.add(option.getArgument());
                }
            }
        }
        return cOpt;
    }

    private boolean processCommandLineActions(CommandlineOptions cOpt) throws Exception {
        block41: {
            block45: {
                String line;
                StringBuffer buf;
                block44: {
                    block43: {
                        block42: {
                            if (cOpt.doReindex) {
                                if (!cOpt.foundCollection) {
                                    System.err.println("Please specify target collection with --collection");
                                    this.shutdown(false);
                                    return false;
                                }
                                try {
                                    this.reindex();
                                }
                                catch (XMLDBException e) {
                                    System.err.println("XMLDBException while removing collection: " + InteractiveClient.getExceptionMessage(e));
                                    e.printStackTrace();
                                }
                            }
                            if (cOpt.optionRmcol != null) {
                                if (!cOpt.foundCollection) {
                                    System.err.println("Please specify target collection with --collection");
                                    this.shutdown(false);
                                    return false;
                                }
                                try {
                                    this.rmcol(cOpt.optionRmcol);
                                }
                                catch (XMLDBException e) {
                                    System.err.println("XMLDBException while removing collection: " + InteractiveClient.getExceptionMessage(e));
                                    e.printStackTrace();
                                }
                            }
                            if (cOpt.optionMkcol != null) {
                                try {
                                    this.mkcol(cOpt.optionMkcol);
                                }
                                catch (XMLDBException e) {
                                    System.err.println("XMLDBException during mkcol: " + InteractiveClient.getExceptionMessage(e));
                                    e.printStackTrace();
                                }
                            }
                            if (cOpt.optionGet == null) break block42;
                            try {
                                Resource res = this.retrieve(cOpt.optionGet);
                                if (res == null) break block41;
                                if (res.getResourceType().equals("XMLResource")) {
                                    if (cOpt.optionOutputFile != null) {
                                        this.writeOutputFile(cOpt.optionOutputFile, res.getContent());
                                    } else {
                                        System.out.println(res.getContent().toString());
                                    }
                                    break block41;
                                }
                                if (cOpt.optionOutputFile != null) {
                                    this.writeOutputFile(cOpt.optionOutputFile, res.getContent());
                                    break block41;
                                }
                                System.out.println(new String((byte[])res.getContent()));
                            }
                            catch (XMLDBException e) {
                                System.err.println("XMLDBException while trying to retrieve document: " + InteractiveClient.getExceptionMessage(e));
                                e.printStackTrace();
                            }
                            break block41;
                        }
                        if (cOpt.optionRemove == null) break block43;
                        if (!cOpt.foundCollection) {
                            System.err.println("Please specify target collection with --collection");
                        } else {
                            try {
                                this.remove(cOpt.optionRemove);
                            }
                            catch (XMLDBException e) {
                                System.out.println("XMLDBException during parse: " + InteractiveClient.getExceptionMessage(e));
                                e.printStackTrace();
                            }
                        }
                        break block41;
                    }
                    if (!cOpt.doStore) break block44;
                    if (!cOpt.foundCollection) {
                        System.err.println("Please specify target collection with --collection");
                    } else {
                        Iterator i = cOpt.optionalArgs.iterator();
                        while (i.hasNext()) {
                            try {
                                this.parse((String)i.next());
                            }
                            catch (XMLDBException e) {
                                System.out.println("XMLDBException during parse: " + InteractiveClient.getExceptionMessage(e));
                                e.printStackTrace();
                            }
                        }
                    }
                    break block41;
                }
                if (cOpt.optionXpath == null && cOpt.optionQueryFile == null) break block45;
                if (cOpt.optionQueryFile != null) {
                    BufferedReader reader = new BufferedReader(new FileReader(cOpt.optionQueryFile));
                    buf = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        buf.append(line);
                        buf.append('\n');
                    }
                    cOpt.optionXpath = buf.toString();
                }
                if (cOpt.optionXpath.equals("stdin")) {
                    try {
                        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                        buf = new StringBuffer();
                        while ((line = stdin.readLine()) != null) {
                            buf.append(line + '\n');
                        }
                        cOpt.optionXpath = buf.toString();
                    }
                    catch (IOException e) {
                        System.err.println("failed to read query from stdin");
                        cOpt.optionXpath = null;
                    }
                }
                if (cOpt.optionXpath == null) break block41;
                try {
                    ResourceSet result = this.find(cOpt.optionXpath);
                    if (this.maxResults <= 0) {
                        this.maxResults = (int)result.getSize();
                    }
                    if (cOpt.optionOutputFile == null) {
                        for (int i = 0; i < this.maxResults && (long)i < result.getSize(); ++i) {
                            System.out.println(result.getResource((long)i).getContent());
                        }
                        break block41;
                    }
                    FileWriter writer = new FileWriter(cOpt.optionOutputFile, false);
                    for (int i = 0; i < this.maxResults && (long)i < result.getSize(); ++i) {
                        writer.write(result.getResource((long)i).getContent().toString());
                    }
                    writer.close();
                }
                catch (XMLDBException e) {
                    System.err.println("XMLDBException during query: " + InteractiveClient.getExceptionMessage(e));
                    e.printStackTrace();
                }
                break block41;
            }
            if (cOpt.optionXUpdate == null) break block41;
            try {
                this.xupdate(cOpt.optionResource, cOpt.optionXUpdate);
            }
            catch (XMLDBException e) {
                System.err.println("XMLDBException during xupdate: " + InteractiveClient.getExceptionMessage(e));
            }
            catch (IOException e) {
                System.err.println("IOException during xupdate: " + InteractiveClient.getExceptionMessage(e));
            }
        }
        return true;
    }

    private boolean getGuiLoginData(Properties props) {
        Properties loginData = ClientFrame.getLoginData(this.properties);
        if (loginData == null) {
            return false;
        }
        props.putAll((Map<?, ?>)loginData);
        return true;
    }

    private boolean connectToDatabase() {
        try {
            this.connect();
        }
        catch (Exception cnf) {
            if (this.startGUI && this.frame != null) {
                this.frame.setStatus("Connection to database failed; message: " + cnf.getMessage());
            } else {
                System.err.println("Connection to database failed; message: " + cnf.getMessage());
            }
            cnf.printStackTrace();
            System.exit(0);
        }
        return true;
    }

    public void run(String[] args) throws Exception {
        if (!this.quiet) {
            this.printNotice();
        }
        File home = ConfigurationHelper.getExistHome();
        this.properties = new Properties(defaultProps);
        Class<?> cl = Class.forName(this.properties.getProperty(DRIVER));
        Field CONF_XML = cl.getDeclaredField("CONF_XML");
        if (CONF_XML != null && home != null) {
            File configuration = ConfigurationHelper.lookup((String)CONF_XML.get(new String()));
            this.properties.setProperty(CONFIGURATION, configuration.getAbsolutePath());
        }
        this.properties.putAll((Map<?, ?>)this.loadClientProperties());
        CommandlineOptions cOpt = this.getCommandlineOptions(args, this.properties);
        if (cOpt == null) {
            return;
        }
        this.properties.setProperty(URI, URLDecoder.decode(this.properties.getProperty(URI), "UTF-8"));
        if (cOpt.interactive && this.startGUI) {
            boolean haveLoginData = this.getGuiLoginData(this.properties);
            if (!haveLoginData) {
                System.exit(0);
            }
        } else if (cOpt.needPasswd) {
            try {
                this.properties.setProperty(PASSWORD, this.console.readLine("password: ", new Character('*')));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.historyFile = new File(home, ".exist_history");
        this.queryHistoryFile = new File(home, ".exist_query_history");
        if (this.queryHistoryFile.canRead()) {
            this.readQueryHistory();
        }
        if (cOpt.interactive) {
            Terminal.setupTerminal();
            this.console = new ConsoleReader();
            this.console.addCompletor((Completor)new CollectionCompleter());
            try {
                History history = new History(this.historyFile);
                this.console.setHistory(history);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.connectToDatabase();
        if (this.current == null) {
            if (this.startGUI && this.frame != null) {
                this.frame.setStatus("Could not retrieve collection " + this.path);
            } else {
                System.err.println("Could not retrieve collection " + this.path);
            }
            this.shutdown(false);
            return;
        }
        boolean processingOK = this.processCommandLineActions(cOpt);
        if (!processingOK) {
            return;
        }
        if (cOpt.interactive) {
            if (this.startGUI) {
                this.frame = new ClientFrame(this, this.path, this.properties);
                this.frame.setLocation(100, 100);
                this.frame.setSize(500, 500);
                this.frame.setVisible(true);
            }
            if (!this.startGUI || this.frame == null) {
                try {
                    this.getResources();
                }
                catch (XMLDBException e) {
                    System.out.println("XMLDBException while retrieving collection contents: " + InteractiveClient.getExceptionMessage(e));
                    e.getCause().printStackTrace();
                }
            } else {
                boolean retry = true;
                while (retry) {
                    String errorMessage = "";
                    try {
                        this.getResources();
                    }
                    catch (XMLDBException e) {
                        errorMessage = InteractiveClient.getExceptionMessage(e);
                        ClientFrame.showErrorMessage("XMLDBException occurred while retrieving collection: " + errorMessage, e);
                    }
                    if (errorMessage.matches("^.*Invalid password for user.*$") || errorMessage.matches("^.*User .* unknown.*") || errorMessage.matches("^.*Connection refused: connect.*")) {
                        boolean haveLoginData = this.getGuiLoginData(this.properties);
                        if (!haveLoginData) {
                            System.exit(0);
                        }
                        this.shutdown(false);
                        this.connectToDatabase();
                        continue;
                    }
                    if (errorMessage != "") {
                        this.frame.dispose();
                        System.exit(1);
                        continue;
                    }
                    retry = false;
                }
            }
            this.messageln("\ntype help or ? for help.");
            if (cOpt.openQueryGui) {
                QueryDialog qd = new QueryDialog(this, this.current, this.properties);
                qd.setLocation(100, 100);
                qd.setVisible(true);
            } else if (!this.startGUI) {
                this.readlineInputLoop(home.getAbsolutePath());
            } else {
                this.frame.displayPrompt();
            }
        } else {
            this.shutdown(false);
        }
    }

    public static final String getExceptionMessage(Throwable e) {
        Throwable cause;
        while ((cause = e.getCause()) != null) {
            e = cause;
        }
        return e.getMessage();
    }

    protected void readQueryHistory() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(this.queryHistoryFile);
            NodeList nodes = doc.getElementsByTagName("query");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element query = (Element)nodes.item(i);
                StringBuffer value = new StringBuffer();
                for (Node next = query.getFirstChild(); next != null; next = next.getNextSibling()) {
                    value.append(next.getNodeValue());
                }
                this.queryHistory.addLast(value.toString());
            }
        }
        catch (Exception e) {
            if (this.startGUI) {
                ClientFrame.showErrorMessage("Error while reading query history: " + e.getMessage(), e);
            }
            this.messageln("Error while reading query history: " + e.getMessage());
        }
    }

    protected void addToHistory(String query) {
        this.queryHistory.add(query);
    }

    protected void writeQueryHistory() {
        try {
            this.console.getHistory().flushBuffer();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.queryHistoryFile));
            SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            serializer.setOutput(writer, null);
            int p = 0;
            if (this.queryHistory.size() > 20) {
                p = this.queryHistory.size() - 20;
            }
            AttributesImpl attrs = new AttributesImpl();
            serializer.startDocument();
            serializer.startElement("", "history", "history", attrs);
            ListIterator i = this.queryHistory.listIterator(p);
            while (i.hasNext()) {
                serializer.startElement("", "query", "query", attrs);
                String next = (String)i.next();
                serializer.characters(next.toCharArray(), 0, next.length());
                serializer.endElement("", "query", "query");
            }
            serializer.endElement("", "history", "history");
            serializer.endDocument();
            writer.close();
            SerializerPool.getInstance().returnObject(serializer);
        }
        catch (IOException e) {
            System.err.println("IO error while writing query history.");
        }
        catch (SAXException e) {
            System.err.println("SAX exception while writing query history.");
        }
    }

    public void readlineInputLoop(String home) {
        boolean cont = true;
        while (cont) {
            try {
                String line = this.properties.getProperty("colors").equals("true") ? this.console.readLine("\u001b[0;36mexist:" + this.path + ">" + ANSI_WHITE) : this.console.readLine("exist:" + this.path + ">");
                if (line == null) continue;
                cont = this.process(line);
            }
            catch (EOFException e) {
                break;
            }
            catch (IOException ioe) {
                System.err.println(ioe);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        try {
            this.console.getHistory().flushBuffer();
        }
        catch (Exception e) {
            System.err.println("Could not write history File to " + this.historyFile.getAbsolutePath());
        }
        this.shutdown(false);
        this.messageln("quit.");
    }

    protected final void shutdown(boolean force) {
        if (this.traceWriter != null) {
            try {
                this.traceWriter.write("</query-log>");
                this.traceWriter.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        try {
            DatabaseInstanceManager mgr = (DatabaseInstanceManager)this.current.getService("DatabaseInstanceManager", "1.0");
            if (mgr == null) {
                System.err.println("service is not available");
            } else if (mgr.isLocalInstance() || force) {
                System.out.println("shutting down database...");
                mgr.shutdown();
            }
        }
        catch (XMLDBException e) {
            System.err.println("database shutdown failed: ");
            e.printStackTrace();
        }
    }

    private final void printUsage() {
        System.out.println("Usage: java " + InteractiveClient.class.getName() + " [options]");
        System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])CommandlineOptions.OPTIONS).toString());
    }

    public void printNotice() {
        Properties sysProperties = InteractiveClient.getSystemProperties();
        this.messageln(sysProperties.getProperty("product-name") + " version " + sysProperties.getProperty("product-version") + ", Copyright (C) 2001-2009 Wolfgang Meier");
        this.messageln("eXist comes with ABSOLUTELY NO WARRANTY.");
        this.messageln("This is free software, and you are welcome to redistribute it\nunder certain conditions; for details read the license file.\n");
    }

    private final void message(String msg) {
        if (!this.quiet) {
            if (this.startGUI && this.frame != null) {
                this.frame.display(msg);
            } else {
                System.out.print(msg);
            }
        }
    }

    private final void messageln(String msg) {
        if (!this.quiet) {
            if (this.startGUI && this.frame != null) {
                this.frame.display(msg + '\n');
            } else {
                System.out.println(msg);
            }
        }
    }

    private Collection resolveCollection(XmldbURI path) throws XMLDBException {
        return DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
    }

    private Resource resolveResource(XmldbURI path) throws XMLDBException {
        XmldbURI collectionPath = path.numSegments() == 1 ? XmldbURI.create(this.current.getName()) : path.removeLastSegment();
        XmldbURI resourceName = path.lastSegment();
        Collection collection = this.resolveCollection(collectionPath);
        if (collection == null) {
            this.messageln("Collection " + collectionPath + " not found.");
            return null;
        }
        this.messageln("Locating resource " + resourceName + " in collection " + collection.getName());
        return collection.getResource(resourceName.toString());
    }

    private void writeOutputFile(String fileName, Object data) throws Exception {
        File file = new File(fileName);
        FileOutputStream os = new FileOutputStream(file);
        if (data instanceof byte[]) {
            os.write((byte[])data);
            os.close();
        } else {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, Charset.forName(this.properties.getProperty("encoding")));
            writer.write(data.toString());
            writer.close();
        }
    }

    private static String formatString(String s1, String s2, int width) {
        StringBuffer buf = new StringBuffer(width);
        if (s1.length() > width) {
            s1 = s1.substring(0, width - 1);
        }
        buf.append(s1);
        int fill = width - (s1.length() + s2.length());
        for (int i = 0; i < fill; ++i) {
            buf.append(' ');
        }
        buf.append(s2);
        return buf.toString();
    }

    private static String formatString(String[] args, int[] sizes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            int j;
            if (sizes[i] < 0) {
                buf.append(args[i]);
            } else {
                for (j = 0; j < sizes[i] && j < args[i].length(); ++j) {
                    buf.append(args[i].charAt(j));
                }
            }
            for (j = 0; j < sizes[i] - args[i].length(); ++j) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public static Properties getSystemProperties() {
        Properties sysProperties = new Properties();
        try {
            sysProperties.load(InteractiveClient.class.getClassLoader().getResourceAsStream("org/exist/system.properties"));
        }
        catch (IOException e) {
            System.err.println("Unable to load system.properties from class loader");
        }
        return sysProperties;
    }

    public static class ProgressObserver
    implements Observer {
        ProgressBar elementsProgress = new ProgressBar("storing elements");
        Observable lastObservable = null;
        ProgressBar parseProgress = new ProgressBar("storing nodes   ");
        ProgressBar wordsProgress = new ProgressBar("storing words   ");

        public void update(Observable o, Object obj) {
            ProgressIndicator ind = (ProgressIndicator)obj;
            if (this.lastObservable == null || o != this.lastObservable) {
                System.out.println();
            }
            if (o instanceof ElementIndex) {
                this.elementsProgress.set(ind.getValue(), ind.getMax());
            } else if (o instanceof TextSearchEngine) {
                this.wordsProgress.set(ind.getValue(), ind.getMax());
            } else {
                this.parseProgress.set(ind.getValue(), ind.getMax());
            }
            this.lastObservable = o;
        }
    }

    private class CollectionCompleter
    implements Completor {
        private CollectionCompleter() {
        }

        public int complete(String buffer, int cursor, List candidates) {
            String toComplete;
            int p = buffer.lastIndexOf(32);
            if (p > -1 && ++p < buffer.length()) {
                toComplete = buffer.substring(p);
            } else {
                toComplete = buffer;
                p = 0;
            }
            SortedSet<String> set = InteractiveClient.this.completitions.tailSet(toComplete);
            if (set != null && set.size() > 0) {
                Iterator i = InteractiveClient.this.completitions.tailSet(toComplete).iterator();
                while (i.hasNext()) {
                    String next = i.next().toString();
                    if (!next.startsWith(toComplete)) continue;
                    candidates.add(next);
                }
            }
            return p + 1;
        }
    }

    private class QueryThread
    extends Thread {
        ArrayList queries;

        public QueryThread(ArrayList queries) {
            this.queries = queries;
        }

        public void run() {
            try {
                DatabaseManager.getCollection((String)(InteractiveClient.this.properties.getProperty(InteractiveClient.URI) + InteractiveClient.this.path), (String)InteractiveClient.this.properties.getProperty(InteractiveClient.USER), (String)InteractiveClient.this.properties.getProperty(InteractiveClient.PASSWORD));
                XPathQueryService service = (XPathQueryService)InteractiveClient.this.current.getService("XPathQueryService", "1.0");
                service.setProperty("indent", "yes");
                service.setProperty("encoding", InteractiveClient.this.properties.getProperty("encoding"));
                Random r = new Random(System.currentTimeMillis());
                for (int i = 0; i < 10; ++i) {
                    String query = (String)this.queries.get(r.nextInt(this.queries.size()));
                    System.out.println(this.getName() + " query: " + query);
                    ResourceSet result = service.query(query);
                    System.out.println(this.getName() + " found: " + result.getSize());
                }
            }
            catch (XMLDBException e) {
                System.err.println("ERROR: " + e.getMessage());
            }
            System.out.println(this.getName() + " finished.");
        }
    }
}

