/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import org.exist.client.ClientFrame;
import org.exist.client.ClientTextArea;
import org.exist.client.InteractiveClient;
import org.exist.client.MimeTypeFileFilter;
import org.exist.xmldb.XQueryService;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.CompiledExpression;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class QueryDialog
extends JFrame {
    private InteractiveClient client;
    private Collection collection;
    private Properties properties;
    private ClientTextArea query;
    private ClientTextArea resultDisplay;
    private ClientTextArea exprDisplay;
    private JComboBox collections = null;
    private SpinnerNumberModel count;
    private DefaultComboBoxModel history = new DefaultComboBoxModel();
    private Font display = new Font("Monospaced", 1, 12);
    private JTextField statusMessage;
    private JTextField queryPositionDisplay;
    private JProgressBar progress;

    public QueryDialog(InteractiveClient client, Collection collection, Properties properties) {
        super("Query Dialog");
        this.collection = collection;
        this.properties = properties;
        this.client = client;
        this.setupComponents();
        this.pack();
    }

    private void setupComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        URL url = this.getClass().getResource("icons/Open24.gif");
        JButton button = new JButton(new ImageIcon(url));
        button.setToolTipText("Read query from file.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryDialog.this.open();
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/SaveAs24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Write query to file.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryDialog.this.save(QueryDialog.this.query.getText(), "query");
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/SaveAs24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Write result to file.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryDialog.this.save(QueryDialog.this.resultDisplay.getText(), "result");
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Copy24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Copy selection.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryDialog.this.query.copy();
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Cut24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Cut selection.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryDialog.this.query.cut();
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Paste24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Paste selection.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryDialog.this.query.paste();
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Find24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Compile only query.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryDialog.this.compileQuery();
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Find24.gif");
        button = new JButton("Submit", new ImageIcon(url));
        button.setToolTipText("Submit query.");
        toolbar.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryDialog.this.doQuery();
            }
        });
        toolbar.add(button);
        JSplitPane split = new JSplitPane(0);
        split.setResizeWeight(0.5);
        JComponent qbox = this.createQueryBox();
        split.setTopComponent(qbox);
        JPanel vbox = new JPanel();
        vbox.setLayout(new BorderLayout());
        JLabel label = new JLabel("Results:");
        vbox.add((Component)label, "North");
        JTabbedPane tabs = new JTabbedPane();
        this.resultDisplay = new ClientTextArea(false, "XML");
        this.resultDisplay.setText("");
        this.resultDisplay.setPreferredSize(new Dimension(400, 250));
        tabs.add("XML", (Component)((Object)this.resultDisplay));
        this.exprDisplay = new ClientTextArea(false, "Dump");
        this.exprDisplay.setText("");
        this.exprDisplay.setPreferredSize(new Dimension(400, 250));
        tabs.add("Trace", (Component)((Object)this.exprDisplay));
        vbox.add((Component)tabs, "Center");
        Box statusbar = Box.createHorizontalBox();
        statusbar.setBorder(BorderFactory.createBevelBorder(1));
        this.statusMessage = new JTextField(20);
        this.statusMessage.setEditable(false);
        this.statusMessage.setFocusable(true);
        statusbar.add(this.statusMessage);
        this.queryPositionDisplay = new JTextField(5);
        this.queryPositionDisplay.setEditable(false);
        this.queryPositionDisplay.setFocusable(true);
        statusbar.add(this.queryPositionDisplay);
        this.query.setPositionOutputTextArea(this.queryPositionDisplay);
        this.progress = new JProgressBar();
        this.progress.setPreferredSize(new Dimension(200, statusbar.getHeight()));
        this.progress.setVisible(false);
        statusbar.add(this.progress);
        vbox.add((Component)statusbar, "South");
        split.setBottomComponent(vbox);
        split.setDividerLocation(0.4);
        this.getContentPane().add((Component)toolbar, "North");
        this.getContentPane().add((Component)split, "Center");
    }

    private JComponent createQueryBox() {
        JTabbedPane tabs = new JTabbedPane();
        JPanel inputVBox = new JPanel();
        inputVBox.setLayout(new BorderLayout());
        tabs.add("Query Input:", inputVBox);
        Box historyBox = Box.createHorizontalBox();
        JLabel label = new JLabel("History: ");
        historyBox.add(label);
        final JComboBox historyList = new JComboBox(this.history);
        Iterator i = this.client.queryHistory.iterator();
        while (i.hasNext()) {
            this.addQuery((String)i.next());
        }
        historyList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String item = (String)((QueryDialog)QueryDialog.this).client.queryHistory.get(historyList.getSelectedIndex());
                QueryDialog.this.query.setText(item);
            }
        });
        historyBox.add(historyList);
        inputVBox.add((Component)historyBox, "North");
        this.query = new ClientTextArea(true, "XQUERY");
        this.query.setElectricScroll(1);
        this.query.setEditable(true);
        this.query.setPreferredSize(new Dimension(350, 200));
        inputVBox.add((Component)((Object)this.query), "Center");
        Box optionsPanel = Box.createHorizontalBox();
        label = new JLabel("Context:");
        optionsPanel.add(label);
        final Vector<String> data = new Vector<String>();
        try {
            Collection root = this.client.getCollection("/db");
            data.addElement(this.collection.getName());
            this.getCollections(root, this.collection, data);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage("An error occurred while retrieving collections list.", e);
        }
        this.collections = new JComboBox(data);
        this.collections.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int p = QueryDialog.this.collections.getSelectedIndex();
                String context = (String)data.elementAt(p);
                try {
                    QueryDialog.this.collection = QueryDialog.this.client.getCollection(context);
                }
                catch (XMLDBException e1) {
                    // empty catch block
                }
            }
        });
        optionsPanel.add(this.collections);
        label = new JLabel(" Display max.:");
        optionsPanel.add(label);
        this.count = new SpinnerNumberModel(100, 1, 10000, 50);
        JSpinner spinner = new JSpinner(this.count);
        spinner.setMaximumSize(new Dimension(400, 100));
        optionsPanel.add(spinner);
        inputVBox.add((Component)optionsPanel, "South");
        return tabs;
    }

    private Vector getCollections(Collection root, Collection collection, Vector collectionsList) throws XMLDBException {
        if (!collection.getName().equals(root.getName())) {
            collectionsList.add(root.getName());
        }
        String[] childCollections = root.listChildCollections();
        for (int i = 0; i < childCollections.length; ++i) {
            Collection child = root.getChildCollection(childCollections[i]);
            this.getCollections(child, collection, collectionsList);
        }
        return collectionsList;
    }

    private void open() {
        String workDir = this.properties.getProperty("working-dir", System.getProperty("user.dir"));
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(workDir));
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(new MimeTypeFileFilter("application/xquery"));
        if (chooser.showDialog(this, "Select query file") == 0) {
            File selectedDir = chooser.getCurrentDirectory();
            this.properties.setProperty("working-dir", selectedDir.getAbsolutePath());
            File file = chooser.getSelectedFile();
            if (!file.canRead()) {
                JOptionPane.showInternalMessageDialog(this, "Cannot read query from file " + file.getAbsolutePath(), "Error", 0);
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                StringBuffer buf = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    buf.append(line);
                    buf.append('\n');
                }
                this.query.setText(buf.toString());
            }
            catch (FileNotFoundException e) {
                ClientFrame.showErrorMessage(e.getMessage(), e);
            }
            catch (IOException e) {
                ClientFrame.showErrorMessage(e.getMessage(), e);
            }
        }
    }

    private void save(String stringToSave, String fileCategory) {
        if (stringToSave == null || "".equals(stringToSave)) {
            return;
        }
        String workDir = this.properties.getProperty("working-dir", System.getProperty("user.dir"));
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(new File(workDir));
        chooser.setFileSelectionMode(0);
        if (fileCategory.equals("result")) {
            chooser.addChoosableFileFilter(new MimeTypeFileFilter("application/xhtml+xml"));
            chooser.addChoosableFileFilter(new MimeTypeFileFilter("application/xml"));
        } else {
            chooser.addChoosableFileFilter(new MimeTypeFileFilter("application/xquery"));
        }
        if (chooser.showDialog(this, "Select file for " + fileCategory + " export") == 0) {
            File selectedDir = chooser.getCurrentDirectory();
            this.properties.setProperty("working-dir", selectedDir.getAbsolutePath());
            File file = chooser.getSelectedFile();
            if (file.exists() && !file.canWrite()) {
                JOptionPane.showMessageDialog(this, "Can not write " + fileCategory + " to file " + file.getAbsolutePath(), "Error", 0);
            }
            if (file.exists() && JOptionPane.showConfirmDialog(this, "File exists. Overwrite?", "Overwrite?", 0) == 1) {
                return;
            }
            try {
                FileWriter writer = new FileWriter(file);
                writer.write(stringToSave);
                writer.close();
            }
            catch (FileNotFoundException e) {
                ClientFrame.showErrorMessage(e.getMessage(), e);
            }
            catch (IOException e) {
                ClientFrame.showErrorMessage(e.getMessage(), e);
            }
        }
    }

    private void doQuery() {
        String xpath = this.query.getText();
        if (xpath.length() == 0) {
            return;
        }
        this.resultDisplay.setText("");
        new QueryThread(xpath).start();
    }

    private void compileQuery() {
        String xpath = this.query.getText();
        if (xpath.length() == 0) {
            return;
        }
        this.resultDisplay.setText("");
        this.statusMessage.setText("Compiling query ...");
        this.setCursor(Cursor.getPredefinedCursor(3));
        long tResult = 0L;
        long tCompiled = 0L;
        try {
            XQueryService service = (XQueryService)this.collection.getService("XQueryService", "1.0");
            service.setProperty("indent", this.properties.getProperty("indent", "yes"));
            long t0 = System.currentTimeMillis();
            CompiledExpression compiled = service.compile(xpath);
            long t1 = System.currentTimeMillis();
            tCompiled = t1 - t0;
            this.statusMessage.setText("Compilation: " + tCompiled + "ms");
        }
        catch (Throwable e) {
            this.statusMessage.setText("Error: " + InteractiveClient.getExceptionMessage(e) + ". Compilation: " + tCompiled + "ms, Execution: " + tResult + "ms");
            ClientFrame.showErrorMessageQuery("An exception occurred during query compilation: " + InteractiveClient.getExceptionMessage(e), e);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void addQuery(String query) {
        if (query.length() > 40) {
            query = query.substring(0, 40);
        }
        this.history.addElement(Integer.toString(this.history.getSize() + 1) + ". " + query);
    }

    class QueryThread
    extends Thread {
        private String xpath;

        public QueryThread(String query) {
            this.xpath = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            QueryDialog.this.statusMessage.setText("Processing query ...");
            QueryDialog.this.progress.setVisible(true);
            QueryDialog.this.progress.setIndeterminate(true);
            QueryDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            long tResult = 0L;
            long tCompiled = 0L;
            ResourceSet result = null;
            try {
                XQueryService service = (XQueryService)QueryDialog.this.collection.getService("XQueryService", "1.0");
                service.setProperty("indent", QueryDialog.this.properties.getProperty("indent", "yes"));
                long t0 = System.currentTimeMillis();
                CompiledExpression compiled = service.compile(this.xpath);
                long t1 = System.currentTimeMillis();
                tCompiled = t1 - t0;
                result = service.execute(compiled);
                tResult = System.currentTimeMillis() - t1;
                StringWriter writer = new StringWriter();
                service.dump(compiled, writer);
                QueryDialog.this.exprDisplay.setText(writer.toString());
                QueryDialog.this.statusMessage.setText("Retrieving results ...");
                int howmany = QueryDialog.this.count.getNumber().intValue();
                QueryDialog.this.progress.setIndeterminate(false);
                QueryDialog.this.progress.setMinimum(1);
                QueryDialog.this.progress.setMaximum(howmany);
                int select = -1;
                StringBuffer contents = new StringBuffer();
                ResourceIterator i = result.getIterator();
                for (int j = 0; i.hasMoreResources() && j < howmany; ++j) {
                    XMLResource resource = (XMLResource)i.nextResource();
                    QueryDialog.this.progress.setValue(j);
                    try {
                        contents.append((String)resource.getContent());
                        contents.append("\n");
                        continue;
                    }
                    catch (XMLDBException e) {
                        select = ClientFrame.showErrorMessageQuery("An error occurred while retrieving results: " + InteractiveClient.getExceptionMessage(e), e);
                        if (select == 2) break;
                    }
                }
                QueryDialog.this.resultDisplay.setText(contents.toString());
                QueryDialog.this.resultDisplay.setCaretPosition(0);
                QueryDialog.this.resultDisplay.scrollToCaret();
                QueryDialog.this.statusMessage.setText("Found " + result.getSize() + " items." + " Compilation: " + tCompiled + "ms, Execution: " + tResult + "ms");
            }
            catch (Throwable e) {
                QueryDialog.this.statusMessage.setText("Error: " + InteractiveClient.getExceptionMessage(e) + ". Compilation: " + tCompiled + "ms, Execution: " + tResult + "ms");
                QueryDialog.this.progress.setVisible(false);
                ClientFrame.showErrorMessageQuery("An exception occurred during query execution: " + InteractiveClient.getExceptionMessage(e), e);
            }
            finally {
                if (result != null) {
                    try {
                        result.clear();
                    }
                    catch (XMLDBException e) {}
                }
            }
            if (((QueryDialog)QueryDialog.this).client.queryHistory.isEmpty() || !((String)((QueryDialog)QueryDialog.this).client.queryHistory.getLast()).equals(this.xpath)) {
                QueryDialog.this.client.addToHistory(this.xpath);
                QueryDialog.this.client.writeQueryHistory();
                QueryDialog.this.addQuery(this.xpath);
            }
            QueryDialog.this.setCursor(Cursor.getDefaultCursor());
            QueryDialog.this.progress.setVisible(false);
        }
    }
}

