/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.combine.CombiningAlgorithm;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.combine.RuleCombiningAlgorithm;
import com.sun.xacml.combine.StandardCombiningAlgFactory;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.exist.client.xacml.AbstractPolicyNode;
import org.exist.client.xacml.PolicyElementEditor;
import org.exist.client.xacml.PolicyNode;
import org.exist.client.xacml.PolicySetNode;
import org.exist.client.xacml.XACMLTreeNode;

public class AbstractPolicyEditor
extends PolicyElementEditor {
    protected String getComboLabel() {
        return (this.node instanceof PolicySetNode ? "Policy" : "Rule") + " Combining Algorithm:";
    }

    protected ComboBoxModel getComboModel() {
        boolean isPolicy = this.node instanceof PolicyNode;
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        Set algorithms = StandardCombiningAlgFactory.getFactory().getStandardAlgorithms();
        Iterator it = algorithms.iterator();
        while (it.hasNext()) {
            String abbreviatedID;
            CombiningAlgorithm algorithm = (CombiningAlgorithm)it.next();
            if (isPolicy) {
                if (!(algorithm instanceof RuleCombiningAlgorithm)) continue;
                abbreviatedID = this.abbrev.getAbbreviatedCombiningID(algorithm.getIdentifier());
                model.addElement(abbreviatedID);
                continue;
            }
            if (!(algorithm instanceof PolicyCombiningAlgorithm)) continue;
            abbreviatedID = this.abbrev.getAbbreviatedCombiningID(algorithm.getIdentifier());
            model.addElement(abbreviatedID);
        }
        return model;
    }

    protected Object getComboPrototype() {
        String prototype = "";
        int maxLength = -1;
        Set algorithms = StandardCombiningAlgFactory.getFactory().getStandardAlgorithms();
        Iterator it = algorithms.iterator();
        while (it.hasNext()) {
            CombiningAlgorithm algorithm = (CombiningAlgorithm)it.next();
            URI ID = algorithm.getIdentifier();
            String abbreviatedID = this.abbrev.getAbbreviatedCombiningID(ID);
            int length = abbreviatedID.length();
            if (length <= maxLength) continue;
            maxLength = length;
            prototype = abbreviatedID;
        }
        return prototype;
    }

    public void setNode(XACMLTreeNode treeNode) {
        if (!(treeNode instanceof AbstractPolicyNode)) {
            throw new IllegalArgumentException("AbstractPolicy Editor can only edit AbstractPolicyNodes");
        }
        AbstractPolicyNode node = (AbstractPolicyNode)treeNode;
        super.setNode(node);
        CombiningAlgorithm algorithm = node.getCombiningAlgorithm();
        String abbreviatedID = this.abbrev.getAbbreviatedCombiningID(algorithm.getIdentifier());
        this.setSelectedItem(abbreviatedID);
    }

    public void pushChanges() {
        super.pushChanges();
        CombiningAlgorithm algorithm = this.getAlgorithm();
        if (algorithm != null) {
            ((AbstractPolicyNode)this.node).setCombiningAlgorithm(algorithm);
        }
    }
}

