/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.combine.CombiningAlgorithm;
import com.sun.xacml.combine.StandardCombiningAlgFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.exist.client.ClientFrame;
import org.exist.client.xacml.Abbreviator;
import org.exist.client.xacml.AbstractNodeEditor;
import org.exist.client.xacml.PolicyElementNode;
import org.exist.client.xacml.PolicyNode;
import org.exist.client.xacml.XACMLTreeNode;

public abstract class PolicyElementEditor
extends AbstractNodeEditor
implements ActionListener,
DocumentListener {
    protected Abbreviator abbrev = new Abbreviator();
    protected PolicyElementNode node;
    private JTextField idText;
    private JLabel invalidLabel;
    private JTextArea descriptionArea;
    private JLabel comboLabel;
    private JComboBox comboBox;
    private JPanel comp;

    public PolicyElementEditor() {
        this.setup();
    }

    public JComponent getComponent() {
        return this.comp;
    }

    private void setup() {
        SpringLayout layout = new SpringLayout();
        this.comp = new JPanel(layout);
        this.comp.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.comp.setOpaque(true);
        Spring constant6 = Spring.constant(6);
        Spring constant0 = Spring.constant(0);
        Spring glue12 = Spring.constant(12, 12, Short.MAX_VALUE);
        JLabel label = new JLabel("ID: ");
        this.invalidLabel = new JLabel("Invalid URI");
        this.invalidLabel.setForeground(new Color(225, 25, 25));
        this.idText = new JTextField(19);
        this.idText.getDocument().addDocumentListener(this);
        this.idText.setMaximumSize(new Dimension(Short.MAX_VALUE, this.idText.getPreferredSize().height));
        this.comp.add(label);
        this.comp.add(this.idText);
        this.comp.add(this.invalidLabel);
        layout.putConstraint("West", (Component)this.idText, constant6, "East", (Component)label);
        layout.putConstraint("West", (Component)this.invalidLabel, constant6, "East", (Component)this.idText);
        Spring nextY = Spring.max(layout.getConstraint("South", this.idText), layout.getConstraint("South", label));
        nextY = Spring.sum(nextY, constant6);
        this.comboLabel = new JLabel();
        this.comboBox = new JComboBox();
        this.comboBox.addActionListener(this);
        this.comboBox.setEditable(false);
        this.comp.add(this.comboLabel);
        this.comp.add(this.comboBox);
        SpringLayout.Constraints constraints = layout.getConstraints(this.comboLabel);
        constraints.setHeight(Spring.max(constraints.getHeight(), layout.getConstraints(this.comboBox).getHeight()));
        layout.putConstraint("North", (Component)this.comboBox, constant0, "North", (Component)this.comboLabel);
        layout.putConstraint("North", (Component)this.comboLabel, nextY, "North", (Component)this.comp);
        layout.putConstraint("West", (Component)this.comboBox, constant6, "East", (Component)this.comboLabel);
        nextY = layout.getConstraint("South", this.comboBox);
        nextY = Spring.max(nextY, layout.getConstraint("South", this.comboLabel));
        nextY = Spring.sum(nextY, constant6);
        Spring right = layout.getConstraint("East", this.comboBox);
        JLabel descriptionLabel = new JLabel("Description");
        this.descriptionArea = new JTextArea(4, 35);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.getDocument().addDocumentListener(this);
        JScrollPane scroll = new JScrollPane(this.descriptionArea);
        this.comp.add(descriptionLabel);
        this.comp.add(scroll);
        layout.putConstraint("North", (Component)descriptionLabel, nextY, "North", (Component)this.comp);
        layout.putConstraint("West", (Component)scroll, constant0, "West", (Component)this.idText);
        Spring idTextWidth = layout.getConstraints(this.idText).getWidth();
        layout.getConstraints(scroll).setWidth(Spring.sum(idTextWidth, idTextWidth));
        layout.putConstraint("North", (Component)scroll, constant6, "South", (Component)descriptionLabel);
        right = Spring.max(right, layout.getConstraint("East", scroll));
        nextY = Spring.sum(layout.getConstraint("South", scroll), glue12);
        right = Spring.sum(constant6, right);
        layout.putConstraint("South", (Component)this.comp, nextY, "North", (Component)this.comp);
        layout.putConstraint("East", (Component)this.comp, right, "West", (Component)this.comp);
    }

    protected abstract String getComboLabel();

    protected abstract ComboBoxModel getComboModel();

    protected abstract Object getComboPrototype();

    protected void setSelectedItem(Object value) {
        this.comboBox.setSelectedItem(value);
    }

    protected Object getSelectedItem() {
        return this.comboBox.getSelectedItem();
    }

    public String getDescription() {
        return this.descriptionArea.getText();
    }

    public String getIDString() {
        return this.idText.getText();
    }

    public URI getID() {
        String IDStr = this.getIDString();
        if (IDStr == null) {
            return null;
        }
        try {
            return new URI(IDStr);
        }
        catch (URISyntaxException e) {
            ClientFrame.showErrorMessage("Invalid policy ID '" + IDStr + "'", e);
            return null;
        }
    }

    public CombiningAlgorithm getAlgorithm() {
        URI algURI = this.abbrev.getFullCombiningURI((String)this.comboBox.getSelectedItem(), this.node instanceof PolicyNode);
        try {
            return StandardCombiningAlgFactory.getInstance().createAlgorithm(algURI);
        }
        catch (UnknownIdentifierException e) {
            ClientFrame.showErrorMessage("Invalid rule combining algorithm '" + algURI + "'", e);
            return null;
        }
    }

    public void setNode(XACMLTreeNode treeNode) {
        if (!(treeNode instanceof PolicyElementNode)) {
            throw new IllegalArgumentException("PolicyElementEditor can only edit PolicyElementNodes");
        }
        this.node = (PolicyElementNode)treeNode;
        if (this.node == null) {
            this.setValues(null, null);
        } else {
            this.setValues(this.node.getId(), this.node.getDescription());
        }
        this.setupCombo();
    }

    protected void setupCombo() {
        this.comboLabel.setText(this.getComboLabel());
        this.comboBox.setModel(this.getComboModel());
        this.comboBox.setPrototypeDisplayValue(this.getComboPrototype());
        this.comboBox.setMaximumSize(this.comboBox.getPreferredSize());
    }

    protected void setValues(URI id, String description) {
        this.idText.setText(id == null ? "" : id.toString());
        this.descriptionArea.setText(description == null ? "" : description);
    }

    public void pushChanges() {
        String description = this.descriptionArea.getText();
        this.node.setDescription(description.length() == 0 ? null : description);
        URI id = this.getId();
        if (id != null) {
            this.node.setId(id);
        }
    }

    public URI getId() {
        try {
            return new URI(this.idText.getText());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void changedUpdate(DocumentEvent event) {
        this.documentUpdated(event);
    }

    public void insertUpdate(DocumentEvent event) {
        this.documentUpdated(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.documentUpdated(event);
    }

    protected void documentUpdated(DocumentEvent event) {
        URI id = this.getId();
        if (id == null) {
            this.idText.setForeground(Color.red);
            this.invalidLabel.setVisible(true);
        } else {
            this.idText.setForeground(null);
            this.invalidLabel.setVisible(false);
            this.node.setId(id);
        }
        this.fireChanged();
    }

    public void actionPerformed(ActionEvent event) {
        this.fireChanged();
    }
}

