/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import com.sun.xacml.PolicyTreeElement;
import com.sun.xacml.Rule;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.exist.client.xacml.AbstractPolicyNode;
import org.exist.client.xacml.AutoScroller;
import org.exist.client.xacml.ConditionNode;
import org.exist.client.xacml.NodeContainer;
import org.exist.client.xacml.NodeCopyAction;
import org.exist.client.xacml.NodeExpander;
import org.exist.client.xacml.NodeTransferable;
import org.exist.client.xacml.PolicyElementContainer;
import org.exist.client.xacml.PolicyElementNode;
import org.exist.client.xacml.PolicyNode;
import org.exist.client.xacml.PolicySetNode;
import org.exist.client.xacml.RootNode;
import org.exist.client.xacml.RuleNode;
import org.exist.client.xacml.TargetNode;
import org.exist.client.xacml.XACMLEditor;
import org.exist.client.xacml.XACMLTreeModel;
import org.exist.client.xacml.XACMLTreeNode;

public class TreeMutator
implements ActionListener,
DragGestureListener,
DragSourceListener,
DropTargetListener,
KeyListener,
MouseListener,
PopupMenuListener {
    private static final String NEW_RULE = "New Rule";
    private static final String NEW_POLICY = "New Policy";
    private static final String NEW_POLICY_SET = "New Policy Set";
    private static final String REMOVE = "Remove";
    public static final int BIAS_BEFORE = -1;
    public static final int BIAS_CURRENT = 0;
    public static final int BIAS_AFTER = 1;
    public static final int BIAS_NO_DESTINATION = -2;
    private static final int BIAS_DELTA_Y = 4;
    private XACMLTreeNode currentDestinationNode = null;
    private int destinationBias = 0;
    private NodeCopyAction copyAction;
    private NodeExpander expander;
    private AutoScroller scroller;
    private JTree tree;
    private JPopupMenu popup;
    private XACMLTreeNode contextNode;

    private TreeMutator() {
    }

    public TreeMutator(JTree tree) {
        if (tree == null) {
            throw new NullPointerException("Tree cannot be null");
        }
        this.popup = new JPopupMenu();
        this.tree = tree;
        this.scroller = new AutoScroller();
        this.expander = new NodeExpander(tree);
        this.copyAction = new NodeCopyAction(tree);
        tree.getInputMap().put(this.copyAction.getTrigger(), this.copyAction.getName());
        tree.getActionMap().put(this.copyAction.getName(), this.copyAction);
        tree.setDragEnabled(false);
        tree.setTransferHandler(null);
        tree.addMouseListener(this);
        tree.addKeyListener(this);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(tree, 3, this);
        new DropTarget(tree, this);
        this.reset();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void reset() {
        this.contextNode = null;
        this.copyAction.setContextNode(null);
        this.popup.removeAll();
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        }
    }

    public void mouseClicked(MouseEvent event) {
        this.showPopup(event);
    }

    public void mouseEntered(MouseEvent event) {
        this.showPopup(event);
    }

    public void mouseExited(MouseEvent event) {
        this.showPopup(event);
    }

    public void mousePressed(MouseEvent event) {
        this.showPopup(event);
    }

    public void mouseReleased(MouseEvent event) {
        this.showPopup(event);
    }

    private void showPopup(MouseEvent event) {
        if (!this.popup.isPopupTrigger(event)) {
            return;
        }
        this.reset();
        Object source = event.getSource();
        if (source != this.tree) {
            return;
        }
        Point p = event.getPoint();
        int row = this.tree.getClosestRowForLocation(p.x, p.y);
        if (row == -1) {
            this.showRootPopup(p);
            return;
        }
        Rectangle bounds = this.tree.getRowBounds(row);
        if (bounds.y > p.y || bounds.y + bounds.height <= p.y) {
            this.showRootPopup(p);
            return;
        }
        TreePath path = this.tree.getPathForRow(row);
        if (path == null) {
            this.showRootPopup(p);
            return;
        }
        Object last = path.getLastPathComponent();
        XACMLTreeNode node = (XACMLTreeNode)last;
        this.copyAction.setContextNode(node);
        if (!(last instanceof PolicyElementNode)) {
            this.popup.add(this.copyAction);
            this.popup.show(this.tree, p.x, p.y);
            return;
        }
        this.contextNode = (XACMLTreeNode)last;
        this.handleTreeElementNode();
        this.popup.addSeparator();
        this.popup.add(this.copyAction);
        this.popup.show(this.tree, p.x, p.y);
    }

    private void handleTreeElementNode() {
        if (this.contextNode instanceof PolicySetNode) {
            this.addPolicySetItem();
            this.addPolicyItem();
        } else if (this.contextNode instanceof PolicyNode) {
            this.addRuleItem();
        }
        this.addRemoveItem();
    }

    private void addRemoveItem() {
        JMenuItem remove = new JMenuItem(REMOVE, 82);
        remove.addActionListener(this);
        this.popup.add(remove);
    }

    private void addRuleItem() {
        JMenuItem newRule = new JMenuItem(NEW_RULE, 82);
        newRule.addActionListener(this);
        this.popup.add(newRule);
    }

    private void addPolicyItem() {
        JMenuItem newPolicy = new JMenuItem(NEW_POLICY, 80);
        newPolicy.addActionListener(this);
        this.popup.add(newPolicy);
    }

    private void addPolicySetItem() {
        JMenuItem newPolicySet = new JMenuItem(NEW_POLICY_SET, 83);
        newPolicySet.addActionListener(this);
        this.popup.add(newPolicySet);
    }

    private void showRootPopup(Point p) {
        this.contextNode = this.getRootNode();
        this.addPolicySetItem();
        this.addPolicyItem();
        this.popup.show(this.tree, p.x, p.y);
    }

    private RootNode getRootNode() {
        TreeModel model = this.tree.getModel();
        if (!(model instanceof XACMLTreeModel)) {
            return null;
        }
        XACMLTreeModel xmodel = (XACMLTreeModel)model;
        return (RootNode)xmodel.getRoot();
    }

    private void newRule() {
        if (this.contextNode instanceof PolicyNode) {
            PolicyNode node = (PolicyNode)this.contextNode;
            Rule rule = XACMLEditor.createDefaultRule(node);
            node.add((PolicyTreeElement)rule);
        }
    }

    private void newPolicySet() {
        if (this.contextNode instanceof PolicySetNode || this.contextNode instanceof RootNode) {
            PolicyElementContainer node = (PolicyElementContainer)this.contextNode;
            PolicySet ps = XACMLEditor.createDefaultPolicySet(node);
            node.add((PolicyTreeElement)ps);
        }
    }

    private void newPolicy() {
        if (this.contextNode instanceof PolicySetNode || this.contextNode instanceof RootNode) {
            PolicyElementContainer node = (PolicyElementContainer)this.contextNode;
            Policy p = XACMLEditor.createDefaultPolicy(node);
            node.add((PolicyTreeElement)p);
        }
    }

    private void remove() {
        if (this.contextNode == null) {
            return;
        }
        NodeContainer parent = this.contextNode.getParent();
        if (parent instanceof PolicyElementContainer && this.contextNode instanceof PolicyElementNode) {
            ((PolicyElementContainer)parent).remove((PolicyElementNode)this.contextNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        if (actionCommand == null) {
            return;
        }
        if (actionCommand.equals(NEW_RULE)) {
            this.newRule();
        } else if (actionCommand.equals(NEW_POLICY)) {
            this.newPolicy();
        } else if (actionCommand.equals(NEW_POLICY_SET)) {
            this.newPolicySet();
        } else if (actionCommand.equals(REMOVE)) {
            this.remove();
        }
        this.tree.revalidate();
        this.tree.repaint();
    }

    public void keyPressed(KeyEvent event) {
        int delta;
        if (event.isShiftDown() || event.isControlDown() || !event.isAltDown()) {
            return;
        }
        int keyCode = event.getKeyCode();
        if (keyCode == 38) {
            delta = -1;
        } else if (keyCode == 40) {
            delta = 1;
        } else {
            return;
        }
        TreePath selected = this.tree.getSelectionPath();
        if (selected == null) {
            return;
        }
        XACMLTreeNode treeNode = (XACMLTreeNode)selected.getLastPathComponent();
        if (!(treeNode instanceof PolicyElementNode)) {
            return;
        }
        PolicyElementNode node = (PolicyElementNode)treeNode;
        PolicyElementContainer parent = (PolicyElementContainer)node.getParent();
        int currentIndex = parent.indexOfChild(node);
        if (currentIndex < 0) {
            return;
        }
        if ((currentIndex += delta) < 0 || currentIndex >= parent.getChildCount()) {
            return;
        }
        if (currentIndex == 0 && !(parent instanceof RootNode)) {
            return;
        }
        this.tree.clearSelection();
        parent.remove(node);
        parent.add(currentIndex, node);
        this.tree.setSelectionPath(XACMLTreeModel.getPathToNode(node));
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void popupMenuCanceled(PopupMenuEvent arg0) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
        this.reset();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        Point location = event.getDragOrigin();
        TreePath path = this.tree.getPathForLocation(location.x, location.y);
        if (path == null) {
            return;
        }
        int action = event.getDragAction();
        XACMLTreeNode transferNode = (XACMLTreeNode)path.getLastPathComponent();
        Cursor cursor = action == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop;
        event.startDrag(cursor, new NodeTransferable(transferNode), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent event) {
        event.acceptDrop(event.getDropAction());
        boolean success = false;
        try {
            success = this.handleDrop(event);
        }
        catch (IOException ioe) {
            success = false;
        }
        catch (UnsupportedFlavorException ufe) {
            success = false;
        }
        finally {
            this.haltTimers();
            this.clearDestination();
            event.dropComplete(success);
        }
    }

    public void dragOver(DropTargetDragEvent event) {
        this.checkDrag(event);
    }

    public void dragEnter(DropTargetDragEvent event) {
        this.checkDrag(event);
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        this.checkDrag(event);
    }

    public void dragExit(DropTargetEvent event) {
        this.haltTimers();
        this.clearDestination();
    }

    private void haltTimers() {
        this.scroller.stop();
        this.expander.stop();
    }

    private void checkDrag(DropTargetDragEvent event) {
        XACMLTreeNode oldNode = this.currentDestinationNode;
        int oldBias = this.destinationBias;
        Point location = event.getLocation();
        this.updateCurrentDestination(location, event.getDropAction());
        if (this.currentDestinationNode == null) {
            this.expander.stop();
            this.clearDestination();
            event.rejectDrag();
            return;
        }
        this.scroller.autoscroll(this.tree, location);
        if (this.destinationBias != 0) {
            this.expander.stop();
        } else if (oldNode != this.currentDestinationNode || this.destinationBias != oldBias) {
            this.expander.hover(this.currentDestinationNode);
        }
        if (this.supportsDrop(event)) {
            this.repaintDestination(oldNode, oldBias);
        } else {
            this.clearDestination();
        }
    }

    private boolean supportsDrop(DropTargetDragEvent event) {
        boolean supported;
        int action = event.getDropAction();
        this.updateCurrentDestination(event.getLocation(), action);
        if (this.currentDestinationNode == null) {
            supported = false;
        } else if (event.isDataFlavorSupported(NodeTransferable.TARGET_FLAVOR)) {
            if (action == 3 || action == 2) {
                action = 1;
            }
            supported = this.isTargetDropValid(action);
        } else if (event.isDataFlavorSupported(NodeTransferable.CONDITION_FLAVOR)) {
            if (action == 3 || action == 2) {
                action = 1;
            }
            supported = this.isConditionDropValid(action);
        } else {
            supported = event.isDataFlavorSupported(NodeTransferable.RULE_FLAVOR) ? this.isRuleDropValid(action) : (event.isDataFlavorSupported(NodeTransferable.ABSTRACT_POLICY_FLAVOR) ? this.isAbstractPolicyDropValid(action) : false);
        }
        if (supported) {
            event.acceptDrag(action);
        } else {
            event.rejectDrag();
        }
        return supported;
    }

    private boolean isTargetDropValid(int action) {
        if (action == 2) {
            return false;
        }
        if (this.currentDestinationNode instanceof PolicyElementNode || this.currentDestinationNode instanceof TargetNode) {
            return this.destinationBias == 0;
        }
        return false;
    }

    private boolean isConditionDropValid(int action) {
        if (action == 2) {
            return false;
        }
        if (this.currentDestinationNode instanceof ConditionNode) {
            return this.destinationBias == 0;
        }
        if (this.currentDestinationNode instanceof RuleNode || this.currentDestinationNode instanceof ConditionNode) {
            return this.destinationBias == 0;
        }
        return false;
    }

    private boolean isRuleDropValid(int action) {
        if (this.currentDestinationNode instanceof PolicyNode) {
            return this.destinationBias == 0;
        }
        if (this.currentDestinationNode instanceof RuleNode) {
            return this.destinationBias == 1 || this.destinationBias == -1;
        }
        if (this.currentDestinationNode instanceof TargetNode && this.currentDestinationNode.getParent() instanceof PolicyNode) {
            return this.destinationBias == 1;
        }
        return false;
    }

    private boolean isAbstractPolicyDropValid(int action) {
        if (this.currentDestinationNode instanceof PolicySetNode || this.currentDestinationNode instanceof RootNode) {
            return true;
        }
        if (this.currentDestinationNode instanceof PolicyNode) {
            return this.destinationBias == 1 || this.destinationBias == -1;
        }
        if (this.currentDestinationNode instanceof TargetNode && this.currentDestinationNode.getParent() instanceof PolicySetNode) {
            return this.destinationBias == 1;
        }
        return false;
    }

    private boolean isPolicyElementDropValid(int action, PolicyElementNode srcNode) {
        if (srcNode instanceof RuleNode) {
            return this.isRuleDropValid(action);
        }
        if (srcNode instanceof AbstractPolicyNode) {
            return this.isAbstractPolicyDropValid(action);
        }
        return false;
    }

    private boolean handleDrop(DropTargetDropEvent event) throws IOException, UnsupportedFlavorException {
        Transferable data = event.getTransferable();
        int action = event.getDropAction();
        this.updateCurrentDestination(event.getLocation(), event.getDropAction());
        if (this.currentDestinationNode == null) {
            return false;
        }
        if (data.isDataFlavorSupported(NodeTransferable.TARGET_FLAVOR)) {
            TargetNode destTarget;
            if (!this.isTargetDropValid(action)) {
                return false;
            }
            if (this.currentDestinationNode instanceof PolicyElementNode) {
                destTarget = ((PolicyElementNode)this.currentDestinationNode).getTarget();
            } else if (this.currentDestinationNode instanceof TargetNode) {
                destTarget = (TargetNode)this.currentDestinationNode;
            } else {
                return false;
            }
            TargetNode source = (TargetNode)data.getTransferData(NodeTransferable.TARGET_FLAVOR);
            destTarget.setTarget(source.getTarget());
            return true;
        }
        if (data.isDataFlavorSupported(NodeTransferable.CONDITION_FLAVOR)) {
            ConditionNode destCondition;
            if (!this.isConditionDropValid(action)) {
                return false;
            }
            if (this.currentDestinationNode instanceof RuleNode) {
                destCondition = ((RuleNode)this.currentDestinationNode).getCondition();
            } else if (this.currentDestinationNode instanceof ConditionNode) {
                destCondition = (ConditionNode)this.currentDestinationNode;
            } else {
                return false;
            }
            ConditionNode source = (ConditionNode)data.getTransferData(NodeTransferable.CONDITION_FLAVOR);
            destCondition.setCondition(source.getCondition());
            return true;
        }
        if (data.isDataFlavorSupported(NodeTransferable.POLICY_ELEMENT_FLAVOR)) {
            int insertionIndex;
            PolicyElementNode srcNode = (PolicyElementNode)data.getTransferData(NodeTransferable.POLICY_ELEMENT_FLAVOR);
            PolicyElementContainer oldParent = (PolicyElementContainer)srcNode.getParent();
            if (!this.isPolicyElementDropValid(action, srcNode)) {
                return false;
            }
            PolicyElementContainer newParent = this.destinationBias == 0 ? (PolicyElementContainer)this.currentDestinationNode : (PolicyElementContainer)this.currentDestinationNode.getParent();
            if (this.isDescendantOrSelf(srcNode, newParent)) {
                return false;
            }
            if (action == 2 && oldParent != null) {
                oldParent.remove(srcNode);
            }
            if ((insertionIndex = newParent.indexOfChild(this.currentDestinationNode)) < 0) {
                insertionIndex = newParent.getChildCount();
            } else if (this.destinationBias == 1) {
                ++insertionIndex;
            }
            if (action == 2 && oldParent == newParent) {
                newParent.add(insertionIndex, srcNode);
            } else {
                String currentId = srcNode.getId().toString();
                PolicyTreeElement copy = newParent.containsId(currentId) ? srcNode.create(URI.create(XACMLEditor.createUniqueId(newParent, currentId))) : srcNode.create();
                newParent.add(insertionIndex, copy);
            }
            return true;
        }
        return false;
    }

    private boolean isDescendantOrSelf(PolicyElementNode srcNode, PolicyElementContainer newParent) {
        TreePath srcPath = XACMLTreeModel.getPathToNode(srcNode);
        TreePath newParentPath = XACMLTreeModel.getPathToNode(newParent);
        if (srcPath == null || newParentPath == null) {
            return false;
        }
        return srcNode == newParent || srcPath.isDescendant(newParentPath);
    }

    private void updateCurrentDestination(Point location, int dropAction) {
        TreePath currentPath = this.tree.getClosestPathForLocation(location.x, location.y);
        if (currentPath == null) {
            this.currentDestinationNode = null;
            this.destinationBias = -2;
            return;
        }
        this.currentDestinationNode = (XACMLTreeNode)currentPath.getLastPathComponent();
        int row = this.tree.getRowForPath(currentPath);
        Rectangle bounds = this.tree.getRowBounds(row);
        this.destinationBias = bounds.y > location.y || location.y < 4 ? -1 : (bounds.y + bounds.height <= location.y ? 1 : (this.isDestinationDifferent(this.tree.getClosestPathForLocation(location.x, location.y - 4)) ? -1 : (this.isDestinationDifferent(this.tree.getClosestPathForLocation(location.x, location.y + 4)) ? 1 : 0)));
    }

    private boolean isDestinationDifferent(TreePath path) {
        return path == null ? this.currentDestinationNode != null : this.currentDestinationNode != path.getLastPathComponent();
    }

    public int getDestinationBias(XACMLTreeNode testNode) {
        return this.currentDestinationNode == null || this.destinationBias == -2 || this.currentDestinationNode != testNode ? -2 : this.destinationBias;
    }

    private void clearDestination() {
        XACMLTreeNode oldNode = this.currentDestinationNode;
        int oldBias = this.destinationBias;
        this.currentDestinationNode = null;
        this.destinationBias = -2;
        this.repaintDestination(oldNode, oldBias);
    }

    private void repaintDestination(XACMLTreeNode oldNode, int oldBias) {
        if (oldNode != null && oldBias != -2) {
            this.handleRepaintDestination(oldNode, oldBias);
        }
        if (this.currentDestinationNode != null && this.destinationBias != -2) {
            this.handleRepaintDestination(this.currentDestinationNode, this.destinationBias);
        }
    }

    private void handleRepaintDestination(XACMLTreeNode node, int bias) {
        if (node == null || bias == -2) {
            return;
        }
        int row = this.tree.getRowForPath(XACMLTreeModel.getPathToNode(node));
        this.repaintRow(row);
        if (bias == 1) {
            if (row + 1 < this.tree.getRowCount()) {
                this.repaintRow(row + 1);
            }
        } else if (bias == -1 && row > 0) {
            this.repaintRow(row - 1);
        }
    }

    private void repaintRow(int row) {
        Rectangle rect = this.tree.getRowBounds(row);
        if (rect != null) {
            this.tree.repaint(rect);
        }
    }

    public void dropActionChanged(DragSourceDragEvent event) {
    }

    public void dragEnter(DragSourceDragEvent event) {
    }

    public void dragOver(DragSourceDragEvent event) {
    }

    public void dragDropEnd(DragSourceDropEvent event) {
    }

    public void dragExit(DragSourceEvent event) {
    }
}

