/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.CollectionURI;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.memtree.SAXAdapter;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.sanity.SanityCheck;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CollectionConfigurationManager {
    private static final Logger LOG = Logger.getLogger((Class)CollectionConfigurationManager.class);
    public static final String CONFIG_COLLECTION = "/db/system/config";
    public static final String COLLECTION_CONFIG_FILENAME = "collection.xconf";
    public static final CollectionURI COLLECTION_CONFIG_PATH = new CollectionURI(XmldbURI.CONFIG_COLLECTION_URI.getRawCollectionPath());
    private Map configurations = new HashMap();
    private Object latch;
    private CollectionConfiguration defaultConfig;
    private BrokerPool pool;

    public CollectionConfigurationManager(DBBroker broker) throws EXistException, CollectionConfigurationException {
        this.pool = broker.getBrokerPool();
        this.latch = this.pool.getCollectionsCache();
        this.checkConfigCollection(broker);
        this.loadAllConfigurations(broker);
        this.defaultConfig = new CollectionConfiguration(broker.getBrokerPool());
        this.defaultConfig.setIndexConfiguration(broker.getIndexConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguration(Txn transaction, DBBroker broker, Collection collection, String config) throws CollectionConfigurationException {
        try {
            XmldbURI path = XmldbURI.CONFIG_COLLECTION_URI.append(collection.getURI());
            Collection confCol = broker.getOrCreateCollection(transaction, path);
            if (confCol == null) {
                throw new CollectionConfigurationException("Failed to create config collection: " + path);
            }
            XmldbURI configurationDocumentName = null;
            CollectionConfiguration conf = this.getConfiguration(broker, collection);
            if (conf != null && (configurationDocumentName = conf.getDocName()) != null) {
                LOG.warn((Object)("Replacing current configuration file '" + configurationDocumentName + "'"));
            }
            if (configurationDocumentName == null) {
                configurationDocumentName = CollectionConfiguration.DEFAULT_COLLECTION_CONFIG_FILE_URI;
            }
            broker.saveCollection(transaction, confCol);
            IndexInfo info = confCol.validateXMLResource(transaction, broker, configurationDocumentName, config);
            confCol.store(transaction, broker, info, config, false);
            Object object = this.latch;
            synchronized (object) {
                this.configurations.remove(new CollectionURI(path.getRawCollectionPath()));
                this.loadConfiguration(broker, confCol);
            }
        }
        catch (IOException e) {
            throw new CollectionConfigurationException("Failed to store collection configuration: " + e.getMessage(), e);
        }
        catch (PermissionDeniedException e) {
            throw new CollectionConfigurationException("Failed to store collection configuration: " + e.getMessage(), e);
        }
        catch (EXistException e) {
            throw new CollectionConfigurationException("Failed to store collection configuration: " + e.getMessage(), e);
        }
        catch (TriggerException e) {
            throw new CollectionConfigurationException("Failed to store collection configuration: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new CollectionConfigurationException("Failed to store collection configuration: " + e.getMessage(), e);
        }
        catch (LockException e) {
            throw new CollectionConfigurationException("Failed to store collection configuration: " + e.getMessage(), e);
        }
    }

    public void testConfiguration(DBBroker broker, String config) throws CollectionConfigurationException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(new StringReader(config));
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            SAXAdapter adapter = new SAXAdapter();
            reader.setContentHandler(adapter);
            reader.parse(src);
            Document doc = adapter.getDocument();
            CollectionConfiguration conf = new CollectionConfiguration(broker.getBrokerPool());
            conf.read(broker, doc, true, null, null);
        }
        catch (ParserConfigurationException e) {
            throw new CollectionConfigurationException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new CollectionConfigurationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CollectionConfigurationException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CollectionConfiguration getConfiguration(DBBroker broker, Collection collection) throws CollectionConfigurationException {
        CollectionURI path = new CollectionURI(COLLECTION_CONFIG_PATH);
        path.append(collection.getURI().getRawCollectionPath());
        Object object = this.latch;
        synchronized (object) {
            while (!path.equals(COLLECTION_CONFIG_PATH)) {
                CollectionConfiguration conf = (CollectionConfiguration)this.configurations.get(path);
                if (conf != null) {
                    return conf;
                }
                path.removeLastSegment();
            }
        }
        return this.defaultConfig;
    }

    protected void loadAllConfigurations(DBBroker broker) throws CollectionConfigurationException {
        Collection root = broker.getCollection(XmldbURI.CONFIG_COLLECTION_URI);
        this.loadAllConfigurations(broker, root);
    }

    protected void loadAllConfigurations(DBBroker broker, Collection configCollection) throws CollectionConfigurationException {
        if (configCollection == null) {
            return;
        }
        this.loadConfiguration(broker, configCollection);
        XmldbURI path = configCollection.getURI();
        Iterator i = configCollection.collectionIterator();
        while (i.hasNext()) {
            XmldbURI childName = (XmldbURI)i.next();
            Collection child = broker.getCollection(path.appendInternal(childName));
            if (child == null) {
                LOG.error((Object)("Collection is registered but could not be loaded: " + childName));
            }
            this.loadAllConfigurations(broker, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfiguration(DBBroker broker, Collection configCollection) throws CollectionConfigurationException {
        if (configCollection != null && configCollection.getDocumentCount() > 0) {
            Iterator i = configCollection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl confDoc = (DocumentImpl)i.next();
                if (!confDoc.getFileURI().endsWith(CollectionConfiguration.COLLECTION_CONFIG_SUFFIX_URI)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Reading collection configuration from '" + confDoc.getURI() + "'"));
                }
                CollectionConfiguration conf = new CollectionConfiguration(broker.getBrokerPool());
                try {
                    conf.read(broker, confDoc, false, configCollection.getURI(), confDoc.getFileURI());
                }
                catch (CollectionConfigurationException e) {
                    String message = "Failed to read configuration document " + confDoc.getFileURI() + " in " + configCollection.getURI() + ". " + e.getMessage();
                    LOG.error((Object)message);
                    System.out.println(message);
                }
                Object object = this.latch;
                synchronized (object) {
                    this.configurations.put(new CollectionURI(configCollection.getURI().getRawCollectionPath()), conf);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll(XmldbURI collectionPath) {
        if (!collectionPath.startsWith(XmldbURI.CONFIG_COLLECTION_URI)) {
            return;
        }
        Object object = this.latch;
        synchronized (object) {
            LOG.debug((Object)("Invalidating collection " + collectionPath));
            this.configurations.remove(new CollectionURI(collectionPath.getRawCollectionPath()));
        }
    }

    protected void invalidate(XmldbURI collectionPath) {
    }

    private void checkConfigCollection(DBBroker broker) throws EXistException {
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = null;
        try {
            Collection root = broker.getCollection(XmldbURI.CONFIG_COLLECTION_URI);
            if (root == null) {
                txn = transact.beginTransaction();
                root = broker.getOrCreateCollection(txn, XmldbURI.CONFIG_COLLECTION_URI);
                SanityCheck.THROW_ASSERT(root != null);
                broker.saveCollection(txn, root);
                transact.commit(txn);
            }
        }
        catch (IOException e) {
            transact.abort(txn);
            throw new EXistException("Failed to initialize '/db/system/config' : " + e.getMessage());
        }
        catch (PermissionDeniedException e) {
            transact.abort(txn);
            throw new EXistException("Failed to initialize '/db/system/config' : " + e.getMessage());
        }
    }

    public void checkRootCollectionConfigCollection(DBBroker broker) throws EXistException {
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = null;
        try {
            Collection rootCollectionConfiguration = broker.getCollection(XmldbURI.ROOT_COLLECTION_CONFIG_URI);
            if (rootCollectionConfiguration == null) {
                txn = transact.beginTransaction();
                rootCollectionConfiguration = broker.getOrCreateCollection(txn, XmldbURI.ROOT_COLLECTION_CONFIG_URI);
                SanityCheck.THROW_ASSERT(rootCollectionConfiguration != null);
                broker.saveCollection(txn, rootCollectionConfiguration);
                transact.commit(txn);
            }
        }
        catch (IOException e) {
            transact.abort(txn);
            throw new EXistException("Failed to initialize '/db/system/config' : " + e.getMessage());
        }
        catch (PermissionDeniedException e) {
            transact.abort(txn);
            throw new EXistException("Failed to initialize '/db/system/config' : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRootCollectionConfig(DBBroker broker) throws EXistException {
        String configuration = "<collection xmlns=\"http://exist-db.org/collection-config/1.0\">    <index>        <fulltext attributes=\"true\" default=\"all\">            <exclude path=\"/auth\" />        </fulltext>    </index></collection>";
        TransactionManager transact = this.pool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            Collection collection = null;
            try {
                collection = broker.openCollection(XmldbURI.ROOT_COLLECTION_URI, 0);
                if (collection == null) {
                    transact.abort(transaction);
                    throw new EXistException("collection " + XmldbURI.ROOT_COLLECTION_URI + " not found!");
                }
                CollectionConfiguration conf = this.getConfiguration(broker, collection);
                if (conf != null && conf.getDocName() != null) {
                    transact.abort(transaction);
                    return;
                }
            }
            finally {
                if (collection != null) {
                    collection.release(0);
                }
            }
            this.addConfiguration(transaction, broker, collection, configuration);
            transact.commit(transaction);
            LOG.info((Object)("Configured '" + collection.getURI() + "'"));
        }
        catch (CollectionConfigurationException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
    }

    private void debugCache() {
        StringBuffer buf = new StringBuffer();
        Iterator i = this.configurations.keySet().iterator();
        while (i.hasNext()) {
            buf.append(i.next()).append(' ');
        }
        LOG.debug((Object)buf.toString());
    }
}

