/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.exist.EXistException;
import org.exist.Namespaces;
import org.exist.dom.AttrImpl;
import org.exist.dom.CDATASectionImpl;
import org.exist.dom.CommentImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NamedNode;
import org.exist.dom.NamedNodeMapImpl;
import org.exist.dom.NodeImplRef;
import org.exist.dom.NodeListImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeVisitor;
import org.exist.dom.ProcessingInstructionImpl;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.dom.SymbolTable;
import org.exist.dom.TextImpl;
import org.exist.indexing.StreamListener;
import org.exist.numbering.NodeId;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.Signatures;
import org.exist.storage.btree.Value;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.exist.util.pool.NodePool;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class ElementImpl
extends NamedNode
implements Element {
    public static final int LENGTH_ELEMENT_CHILD_COUNT = 4;
    public static final int LENGTH_ATTRIBUTES_COUNT = 2;
    public static final int LENGTH_NS_ID = 2;
    public static final int LENGTH_PREFIX_LENGTH = 2;
    private short attributes = 0;
    private int children = 0;
    private int position = 0;
    private Map namespaceMappings = null;
    private int indexType = 0;
    private boolean preserveWS = false;
    private boolean isDirty = false;

    public ElementImpl() {
        super((short)1);
    }

    public ElementImpl(QName nodeName) {
        super((short)1, nodeName);
        this.nodeName = nodeName;
    }

    public ElementImpl(ElementImpl other) {
        super(other);
        this.children = other.children;
        this.attributes = other.attributes;
        this.namespaceMappings = other.namespaceMappings;
        this.indexType = other.indexType;
        this.position = other.position;
    }

    public void clear() {
        super.clear();
        this.attributes = 0;
        this.children = 0;
        this.position = 0;
        this.namespaceMappings = null;
    }

    public void setIndexType(int idxType) {
        this.indexType = idxType;
    }

    public int getIndexType() {
        return this.indexType;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean declaresNamespacePrefixes() {
        if (this.namespaceMappings == null) {
            return false;
        }
        return this.namespaceMappings.size() > 0;
    }

    public byte[] serialize() {
        if (this.nodeId == null) {
            throw new RuntimeException("nodeId = null for element: " + this.getQName().getStringValue());
        }
        try {
            SymbolTable symbols = this.ownerDocument.getBrokerPool().getSymbols();
            byte[] prefixData = null;
            if (this.declaresNamespacePrefixes()) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bout);
                out.writeShort(this.namespaceMappings.size());
                Iterator i = this.namespaceMappings.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    out.writeUTF((String)entry.getKey());
                    short nsId = symbols.getNSSymbol((String)entry.getValue());
                    out.writeShort(nsId);
                }
                prefixData = bout.toByteArray();
            }
            short id = symbols.getSymbol(this);
            boolean hasNamespace = this.nodeName.needsNamespaceDecl();
            short nsId = 0;
            if (hasNamespace) {
                nsId = symbols.getNSSymbol(this.nodeName.getNamespaceURI());
            }
            byte idSizeType = Signatures.getSizeType(id);
            byte signature = (byte)(0x20 | idSizeType);
            int prefixLen = 0;
            if (hasNamespace) {
                if (this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0) {
                    prefixLen = UTF8.encoded(this.nodeName.getPrefix());
                }
                signature = (byte)(signature | 0x10);
            }
            if (this.isDirty) {
                signature = (byte)(signature | 8);
            }
            int nodeIdLen = this.nodeId.size();
            byte[] data = ByteArrayPool.getByteArray(7 + nodeIdLen + 2 + Signatures.getLength(idSizeType) + (hasNamespace ? prefixLen + 4 : 0) + (prefixData != null ? prefixData.length : 0));
            int next = 0;
            data[next] = signature;
            ByteConversion.intToByte(this.children, data, ++next);
            ByteConversion.shortToByte((short)this.nodeId.units(), data, next += 4);
            this.nodeId.serialize(data, next += 2);
            ByteConversion.shortToByte(this.attributes, data, next += nodeIdLen);
            Signatures.write(idSizeType, id, data, next += 2);
            next += Signatures.getLength(idSizeType);
            if (hasNamespace) {
                ByteConversion.shortToByte(nsId, data, next);
                ByteConversion.shortToByte((short)prefixLen, data, next += 2);
                next += 2;
                if (this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0) {
                    UTF8.encode(this.nodeName.getPrefix(), data, next);
                }
                next += prefixLen;
            }
            if (prefixData != null) {
                System.arraycopy(prefixData, 0, data, next, prefixData.length);
            }
            return data;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        int end = start + len;
        int pos = start;
        byte idSizeType = (byte)(data[pos] & 3);
        boolean isDirty = (data[pos] & 8) == 8;
        boolean hasNamespace = (data[pos] & 0x10) == 16;
        int children = ByteConversion.byteToInt(data, ++pos);
        short dlnLen = ByteConversion.byteToShort(data, pos += 4);
        NodeId dln = doc.getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        short attributes = ByteConversion.byteToShort(data, pos += dln.size());
        short id = (short)Signatures.read(idSizeType, data, pos += 2);
        pos += Signatures.getLength(idSizeType);
        short nsId = 0;
        String prefix = null;
        if (hasNamespace) {
            nsId = ByteConversion.byteToShort(data, pos);
            short prefixLen = ByteConversion.byteToShort(data, pos += 2);
            pos += 2;
            if (prefixLen > 0) {
                prefix = UTF8.decode(data, pos, prefixLen).toString();
            }
            pos += prefixLen;
        }
        String name = doc.getBrokerPool().getSymbols().getName(id);
        String namespace = "";
        if (nsId != 0) {
            namespace = doc.getBrokerPool().getSymbols().getNamespace(nsId);
        }
        ElementImpl node = pooled ? (ElementImpl)NodePool.getInstance().borrowNode((short)1) : new ElementImpl();
        node.setNodeId(dln);
        node.nodeName = doc.getBrokerPool().getSymbols().getQName((short)1, namespace, name, prefix);
        node.children = children;
        node.attributes = attributes;
        node.isDirty = isDirty;
        node.setOwnerDocument(doc);
        if (end > pos) {
            byte[] pfxData = new byte[end - pos];
            System.arraycopy(data, pos, pfxData, 0, end - pos);
            ByteArrayInputStream bin = new ByteArrayInputStream(pfxData);
            DataInputStream in = new DataInputStream(bin);
            try {
                int prefixCount = in.readShort();
                for (int i = 0; i < prefixCount; ++i) {
                    prefix = in.readUTF();
                    nsId = in.readShort();
                    node.addNamespaceMapping(prefix, doc.getBrokerPool().getSymbols().getNamespace(nsId));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return node;
    }

    public static QName readQName(Value value, DocumentImpl document, NodeId nodeId) {
        byte[] data = value.data();
        int offset = value.start();
        byte idSizeType = (byte)(data[offset] & 3);
        boolean hasNamespace = (data[offset] & 0x10) == 16;
        ++offset;
        offset += 4;
        offset += 2;
        offset += nodeId.size();
        short id = (short)Signatures.read(idSizeType, data, offset += 2);
        offset += Signatures.getLength(idSizeType);
        short nsId = 0;
        String prefix = null;
        if (hasNamespace) {
            nsId = ByteConversion.byteToShort(data, offset);
            short prefixLen = ByteConversion.byteToShort(data, offset += 2);
            offset += 2;
            if (prefixLen > 0) {
                prefix = UTF8.decode(data, offset, prefixLen).toString();
            }
            offset += prefixLen;
        }
        String name = document.getBrokerPool().getSymbols().getName(id);
        String namespace = "";
        if (nsId != 0) {
            namespace = document.getBrokerPool().getSymbols().getNamespace(nsId);
        }
        return new QName(name, namespace, prefix == null ? "" : prefix);
    }

    public static void readNamespaceDecls(List namespaces, Value value, DocumentImpl document, NodeId nodeId) {
        byte[] data = value.data();
        int offset = value.start();
        int end = offset + value.getLength();
        byte idSizeType = (byte)(data[offset] & 3);
        boolean hasNamespace = (data[offset] & 0x10) == 16;
        ++offset;
        offset += 4;
        offset += 2;
        offset += nodeId.size();
        offset += 2;
        offset += Signatures.getLength(idSizeType);
        if (hasNamespace) {
            short prefixLen = ByteConversion.byteToShort(data, offset += 2);
            offset += 2;
            offset += prefixLen;
        }
        if (end > offset) {
            byte[] pfxData = new byte[end - offset];
            System.arraycopy(data, offset, pfxData, 0, end - offset);
            ByteArrayInputStream bin = new ByteArrayInputStream(pfxData);
            DataInputStream in = new DataInputStream(bin);
            try {
                int prefixCount = in.readShort();
                for (int i = 0; i < prefixCount; ++i) {
                    String prefix = in.readUTF();
                    short nsId = in.readShort();
                    namespaces.add(new String[]{prefix, document.getBrokerPool().getSymbols().getNamespace(nsId)});
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addNamespaceMapping(String prefix, String ns) {
        if (prefix == null) {
            return;
        }
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new HashMap(1);
        } else if (this.namespaceMappings.containsKey(prefix)) {
            return;
        }
        this.namespaceMappings.put(prefix, ns);
    }

    public void appendChildInternal(StoredNode prevNode, StoredNode child) throws DOMException {
        NodeId childId;
        if (prevNode == null) {
            childId = this.getNodeId().newChild();
        } else {
            if (prevNode.getNodeId() == null) {
                LOG.warn((Object)(this.getQName() + " : " + prevNode.getNodeName()));
            }
            childId = prevNode.getNodeId().nextSibling();
        }
        child.setNodeId(childId);
        ++this.children;
    }

    public Node appendChild(Node child) throws DOMException {
        TransactionManager transact = this.ownerDocument.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        NodeListImpl nl = new NodeListImpl();
        nl.add(child);
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            this.appendChildren(transaction, nl, 0);
            broker.storeXMLResource(transaction, (DocumentImpl)this.getOwnerDocument());
            Node node = this.getLastChild();
            return node;
        }
        catch (Exception e) {
            transact.abort(transaction);
            throw new DOMException(11, e.getMessage());
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
    }

    public void appendAttributes(Txn transaction, NodeList attribs) throws DOMException {
        NodeList duplicateAttrs = this.findDupAttributes(attribs);
        this.removeAppendAttributes(transaction, duplicateAttrs, attribs);
    }

    private NodeList checkForAttributes(Txn transaction, NodeList nodes) throws DOMException {
        NodeListImpl attribs = null;
        NodeListImpl rest = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node next = nodes.item(i);
            if (next.getNodeType() == 2) {
                if (next.getNodeName().startsWith("xmlns")) continue;
                if (attribs == null) {
                    attribs = new NodeListImpl();
                }
                attribs.add(next);
                continue;
            }
            if (attribs == null) continue;
            if (rest == null) {
                rest = new NodeListImpl();
            }
            rest.add(next);
        }
        if (attribs == null) {
            return nodes;
        }
        this.appendAttributes(transaction, attribs);
        return rest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendChildren(Txn transaction, NodeList nodes, int child) throws DOMException {
        if ((nodes = this.checkForAttributes(transaction, nodes)) == null || nodes.getLength() == 0) {
            return;
        }
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            NodePath path = this.getPath();
            StreamListener listener = null;
            broker.getIndexController().setDocument(this.ownerDocument);
            StoredNode reindexRoot = broker.getIndexController().getReindexRoot(this, path);
            broker.getIndexController().setMode(0);
            if (reindexRoot == null) {
                listener = broker.getIndexController().getStreamListener();
            } else {
                broker.getIndexController().reindex(transaction, reindexRoot, 0);
            }
            if (this.children == 0) {
                this.appendChildren(transaction, this.nodeId.newChild(), null, new NodeImplRef(this), path, nodes, listener);
            } else if (child == 1) {
                Node firstChild = this.getFirstChild();
                this.insertBefore(transaction, nodes, firstChild);
            } else if (child > 1 && child <= this.children) {
                NodeList cl = this.getChildNodes();
                StoredNode last = (StoredNode)cl.item(child - 2);
                this.insertAfter(transaction, nodes, last);
            } else {
                StoredNode last = (StoredNode)this.getLastChild();
                this.appendChildren(transaction, last.getNodeId().nextSibling(), null, new NodeImplRef(this.getLastNode(last)), path, nodes, listener);
            }
            broker.updateNode(transaction, this, false);
            broker.getIndexController().reindex(transaction, reindexRoot, 0);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while appending child node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
    }

    protected void appendChildren(Txn transaction, NodeId newNodeId, NodeId followingId, NodeImplRef last, NodePath lastPath, NodeList nodes, StreamListener listener) throws DOMException {
        if (last == null || last.getNode() == null || last.getNode().getOwnerDocument() == null) {
            throw new DOMException(13, "invalid node");
        }
        this.children += nodes.getLength();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            this.appendChild(transaction, newNodeId, last, lastPath, child, listener);
            NodeId next = newNodeId.nextSibling();
            if (followingId != null && next.equals(followingId)) {
                next = newNodeId.insertNode(followingId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Node ID collision on " + followingId + ". Using " + next + " instead."));
                }
            }
            newNodeId = next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node appendChild(Txn transaction, NodeId newNodeId, NodeImplRef last, NodePath lastPath, Node child, StreamListener listener) throws DOMException {
        if (last == null || last.getNode() == null) {
            throw new DOMException(13, "invalid node");
        }
        DocumentImpl owner = (DocumentImpl)this.getOwnerDocument();
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            switch (child.getNodeType()) {
                case 11: {
                    this.appendChildren(transaction, newNodeId, null, last, lastPath, child.getChildNodes(), listener);
                    Node node = null;
                    return node;
                }
                case 1: {
                    ElementImpl elem = new ElementImpl(new QName(child.getLocalName() == null ? child.getNodeName() : child.getLocalName(), child.getNamespaceURI(), child.getPrefix()));
                    elem.setNodeId(newNodeId);
                    elem.setOwnerDocument(owner);
                    NodeListImpl ch = new NodeListImpl();
                    NamedNodeMap attribs = child.getAttributes();
                    short numActualAttribs = 0;
                    for (int i = 0; i < attribs.getLength(); ++i) {
                        Attr attr = (Attr)attribs.item(i);
                        if (!attr.getNodeName().startsWith("xmlns")) {
                            ch.add(attr);
                            ++numActualAttribs;
                            continue;
                        }
                        String xmlnsDecl = attr.getNodeName();
                        String prefix = xmlnsDecl.length() == 5 ? "" : xmlnsDecl.substring(6);
                        elem.addNamespaceMapping(prefix, attr.getNodeValue());
                    }
                    NodeList cl = child.getChildNodes();
                    for (int i = 0; i < cl.getLength(); ++i) {
                        Node n = cl.item(i);
                        if (n.getNodeType() == 2) continue;
                        ch.add(n);
                    }
                    elem.setChildCount(ch.getLength());
                    if (numActualAttribs != (short)numActualAttribs) {
                        throw new DOMException(13, "too many attributes");
                    }
                    elem.setAttributes(numActualAttribs);
                    lastPath.addComponent(elem.getQName());
                    broker.insertNodeAfter(transaction, last.getNode(), elem);
                    broker.indexNode(transaction, elem, lastPath);
                    broker.getIndexController().indexNode(transaction, elem, lastPath, listener);
                    elem.setChildCount(0);
                    last.setNode(elem);
                    elem.appendChildren(transaction, newNodeId.newChild(), null, last, lastPath, ch, listener);
                    broker.endElement(elem, lastPath, null);
                    broker.getIndexController().endElement(transaction, elem, lastPath, listener);
                    lastPath.removeLastComponent();
                    ElementImpl i = elem;
                    return i;
                }
                case 3: {
                    TextImpl text = new TextImpl(newNodeId, ((Text)child).getData());
                    text.setOwnerDocument(owner);
                    broker.insertNodeAfter(transaction, last.getNode(), text);
                    broker.indexNode(transaction, text, lastPath);
                    broker.getIndexController().indexNode(transaction, text, lastPath, listener);
                    last.setNode(text);
                    TextImpl n = text;
                    return n;
                }
                case 4: {
                    CDATASectionImpl cdata = new CDATASectionImpl(newNodeId, ((CDATASection)child).getData());
                    cdata.setOwnerDocument(owner);
                    broker.insertNodeAfter(transaction, last.getNode(), cdata);
                    broker.indexNode(transaction, cdata, lastPath);
                    last.setNode(cdata);
                    CDATASectionImpl prefix = cdata;
                    return prefix;
                }
                case 2: {
                    Attr attr = (Attr)child;
                    String ns = attr.getNamespaceURI();
                    String prefix = "http://www.w3.org/XML/1998/namespace".equals(ns) ? "xml" : attr.getPrefix();
                    String name = attr.getLocalName();
                    if (name == null) {
                        name = attr.getName();
                    }
                    QName attrName = new QName(name, ns, prefix);
                    AttrImpl attrib = new AttrImpl(attrName, attr.getValue());
                    attrib.setNodeId(newNodeId);
                    attrib.setOwnerDocument(owner);
                    if (ns != null && attrName.compareTo(Namespaces.XML_ID_QNAME) == 0) {
                        attrib.setValue(StringValue.trimWhitespace(StringValue.collapseWhitespace(attrib.getValue())));
                        attrib.setType(1);
                    } else {
                        attrName.setNameType((byte)1);
                    }
                    broker.insertNodeAfter(transaction, last.getNode(), attrib);
                    broker.indexNode(transaction, attrib, lastPath);
                    broker.getIndexController().indexNode(transaction, attrib, lastPath, listener);
                    last.setNode(attrib);
                    AttrImpl attrImpl = attrib;
                    return attrImpl;
                }
                case 8: {
                    CommentImpl comment = new CommentImpl(((Comment)child).getData());
                    comment.setNodeId(newNodeId);
                    comment.setOwnerDocument(owner);
                    broker.insertNodeAfter(transaction, last.getNode(), comment);
                    broker.indexNode(transaction, comment, lastPath);
                    last.setNode(comment);
                    CommentImpl commentImpl = comment;
                    return commentImpl;
                }
                case 7: {
                    ProcessingInstructionImpl pi = new ProcessingInstructionImpl(newNodeId, ((ProcessingInstruction)child).getTarget(), ((ProcessingInstruction)child).getData());
                    pi.setOwnerDocument(owner);
                    broker.insertNodeAfter(transaction, last.getNode(), pi);
                    broker.indexNode(transaction, pi, lastPath);
                    last.setNode(pi);
                    ProcessingInstructionImpl processingInstructionImpl = pi;
                    return processingInstructionImpl;
                }
            }
            try {
                throw new DOMException(13, "unknown node type: " + child.getNodeType() + " " + child.getNodeName());
            }
            catch (EXistException e) {
                LOG.warn((Object)("Exception while appending node: " + e.getMessage()), (Throwable)e);
            }
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return null;
    }

    public short getAttributesCount() {
        return this.attributes;
    }

    public void setAttributes(short attribNum) {
        this.attributes = attribNum;
    }

    public String getAttribute(String name) {
        AttrImpl attr = this.findAttribute(name);
        return attr != null ? attr.getValue() : "";
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        AttrImpl attr = this.findAttribute(new QName(localName, namespaceURI));
        return attr != null ? attr.getValue() : "";
    }

    public Attr getAttributeNode(String name) {
        return this.findAttribute(name);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.findAttribute(new QName(localName, namespaceURI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedNodeMap getAttributes() {
        NamedNodeMapImpl map = new NamedNodeMapImpl();
        if (this.getAttributesCount() > 0) {
            DBBroker broker = null;
            try {
                broker = this.ownerDocument.getBrokerPool().get(null);
                Iterator iterator = broker.getNodeIterator(this);
                iterator.next();
                int ccount = this.getChildCount();
                for (int i = 0; i < ccount; ++i) {
                    StoredNode next = (StoredNode)iterator.next();
                    if (next.getNodeType() != 2) {
                        break;
                    }
                    map.setNamedItem(next);
                }
            }
            catch (EXistException e) {
                LOG.warn((Object)("Exception while retrieving attributes: " + e.getMessage()));
            }
            finally {
                this.ownerDocument.getBrokerPool().release(broker);
            }
        }
        if (this.declaresNamespacePrefixes()) {
            Iterator i = this.namespaceMappings.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String prefix = entry.getKey().toString();
                String ns = entry.getValue().toString();
                QName attrName = new QName(prefix, "http://www.w3.org/2000/xmlns/", "xmlns");
                AttrImpl attr = new AttrImpl(attrName, ns);
                map.setNamedItem(attr);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttrImpl findAttribute(String qname) {
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            Iterator iterator = broker.getNodeIterator(this);
            iterator.next();
            AttrImpl attrImpl = this.findAttribute(qname, iterator, (StoredNode)this);
            return attrImpl;
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while retrieving attributes: " + e.getMessage()));
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return null;
    }

    private AttrImpl findAttribute(String qname, Iterator iterator, StoredNode current) {
        StoredNode next;
        int ccount = current.getChildCount();
        for (int i = 0; i < ccount && (next = (StoredNode)iterator.next()).getNodeType() == 2; ++i) {
            if (!next.getNodeName().equals(qname)) continue;
            return (AttrImpl)next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttrImpl findAttribute(QName qname) {
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            Iterator iterator = broker.getNodeIterator(this);
            iterator.next();
            AttrImpl attrImpl = this.findAttribute(qname, iterator, (StoredNode)this);
            return attrImpl;
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while retrieving attributes: " + e.getMessage()));
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return null;
    }

    private AttrImpl findAttribute(QName qname, Iterator iterator, StoredNode current) {
        StoredNode next;
        int ccount = current.getChildCount();
        for (int i = 0; i < ccount && (next = (StoredNode)iterator.next()).getNodeType() == 2; ++i) {
            if (!next.getQName().equalsSimple(qname)) continue;
            return (AttrImpl)next;
        }
        return null;
    }

    private NodeList findDupAttributes(NodeList attrs) throws DOMException {
        NodeListImpl dupList = null;
        NamedNodeMap map = this.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node duplicate;
            Node attr = attrs.item(i);
            String localName = attr.getLocalName();
            if (localName == null) {
                localName = attr.getNodeName();
            }
            if ((duplicate = map.getNamedItemNS(attr.getNamespaceURI(), localName)) == null) continue;
            if (dupList == null) {
                dupList = new NodeListImpl();
            }
            dupList.add(duplicate);
        }
        return dupList;
    }

    public int getChildCount() {
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getChildNodes() {
        NodeListImpl childList = new NodeListImpl(1);
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            EmbeddedXMLStreamReader reader = broker.getXMLStreamReader(this, true);
            while (reader.hasNext()) {
                int status = reader.next();
                if (status == 2 || !((NodeId)reader.getProperty("node-id")).isChildOf(this.nodeId)) continue;
                childList.add(reader.getNode());
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
        }
        catch (XMLStreamException e) {
            LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
        }
        catch (EXistException e) {
            LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return childList;
    }

    public NodeList getElementsByTagName(String tagName) {
        QName qname = new QName(tagName, "", null);
        return ((DocumentImpl)this.getOwnerDocument()).findElementsByTagName(this, qname);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        QName qname = new QName(localName, namespaceURI, null);
        return ((DocumentImpl)this.getOwnerDocument()).findElementsByTagName(this, qname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getFirstChild() {
        if (!this.hasChildNodes() || this.getChildCount() == this.getAttributesCount()) {
            return null;
        }
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            Iterator iterator = broker.getNodeIterator(this);
            iterator.next();
            for (int i = 0; i < this.getChildCount(); ++i) {
                StoredNode next = (StoredNode)iterator.next();
                if (next.getNodeType() == 2) continue;
                StoredNode storedNode = next;
                return storedNode;
            }
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while retrieving child node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return null;
    }

    public Node getLastChild() {
        if (!this.hasChildNodes()) {
            return null;
        }
        Node node = null;
        if (!this.isDirty) {
            NodeId child = this.nodeId.getChild(this.children);
            node = this.ownerDocument.getNode(new NodeProxy(this.ownerDocument, child));
        }
        if (node == null) {
            NodeList cl = this.getChildNodes();
            return cl.item(cl.getLength() - 1);
        }
        return node;
    }

    public String getTagName() {
        return this.nodeName.getStringValue();
    }

    public boolean hasAttribute(String name) {
        return this.findAttribute(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.findAttribute(new QName(localName, namespaceURI)) != null;
    }

    public boolean hasAttributes() {
        return this.getAttributesCount() > 0;
    }

    public boolean hasChildNodes() {
        return this.children > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeValue() {
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            String string = broker.getNodeValue(this, false);
            return string;
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while reading node value: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return "";
    }

    public void removeAttribute(String name) throws DOMException {
        throw new DOMException(9, "removeAttribute(String name) not implemented on class " + this.getClass().getName());
    }

    public void removeAttributeNS(String namespaceURI, String name) throws DOMException {
        throw new DOMException(9, "removeAttributeNS(String namespaceURI, String name) not implemented on class " + this.getClass().getName());
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DOMException(9, "removeAttributeNode(Attr oldAttr) not implemented on class " + this.getClass().getName());
    }

    public void setAttribute(String name, String value) throws DOMException {
        throw new DOMException(9, "setAttribute(String name, String value) not implemented on class " + this.getClass().getName());
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(9, "setAttributeNS(String namespaceURI, String qualifiedName, String value) not implemented on class " + this.getClass().getName());
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DOMException(9, "setAttributeNode(Attr newAttr) not implemented on class " + this.getClass().getName());
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        throw new DOMException(9, "setAttributeNodeNS(Attr newAttr) not implemented on class " + this.getClass().getName());
    }

    public void setChildCount(int count) {
        this.children = count;
    }

    public void setNamespaceMappings(Map map) {
        this.namespaceMappings = new HashMap(map);
        Iterator i = this.namespaceMappings.values().iterator();
        while (i.hasNext()) {
            String ns = (String)i.next();
            this.ownerDocument.getBrokerPool().getSymbols().getNSSymbol(ns);
        }
    }

    public Iterator getPrefixes() {
        return this.namespaceMappings.keySet().iterator();
    }

    public String getNamespaceForPrefix(String prefix) {
        return (String)this.namespaceMappings.get(prefix);
    }

    public int getPrefixCount() {
        return this.namespaceMappings.size();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean top) {
        return this.toString(top, new TreeSet());
    }

    public String toString(boolean top, TreeSet namespaces) {
        StringBuffer buf = new StringBuffer();
        StringBuffer attributes = new StringBuffer();
        StringBuffer children = new StringBuffer();
        buf.append('<');
        buf.append(this.nodeName);
        if (top) {
            // empty if block
        }
        if (this.declaresNamespacePrefixes()) {
            Iterator i = this.namespaceMappings.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String prefix = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                if (prefix.length() == 0) {
                    buf.append(" xmlns=\"");
                    buf.append("...");
                } else {
                    buf.append(" xmlns:");
                    buf.append(prefix);
                    buf.append("=\"");
                    buf.append("...");
                }
                buf.append("\" ");
                namespaces.add(namespace);
            }
        }
        if (this.nodeName.getNamespaceURI().length() > 0 && !namespaces.contains(this.nodeName.getNamespaceURI())) {
            buf.append(" xmlns:").append(this.nodeName.getPrefix()).append("=\"");
            buf.append(this.nodeName.getNamespaceURI());
            buf.append("\" ");
        }
        NodeList childNodes = this.getChildNodes();
        block5: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 2: {
                    attributes.append(' ');
                    attributes.append(((Attr)child).getName());
                    attributes.append("=\"");
                    attributes.append(this.escapeXml(child));
                    attributes.append("\"");
                    continue block5;
                }
                case 1: {
                    children.append(((ElementImpl)child).toString(false, namespaces));
                    continue block5;
                }
                default: {
                    children.append(child.toString());
                }
            }
        }
        if (attributes.length() > 0) {
            buf.append(attributes.toString());
        }
        if (childNodes.getLength() > 0) {
            buf.append(">");
            buf.append(children.toString());
            buf.append("</");
            buf.append(this.nodeName);
            buf.append(">");
        } else {
            buf.append("/>");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        if (!(refChild instanceof StoredNode)) {
            throw new DOMException(4, "wrong node type");
        }
        NodeListImpl nl = new NodeListImpl();
        nl.add(newChild);
        TransactionManager transact = this.ownerDocument.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            this.insertBefore(transaction, nl, refChild);
            broker.storeXMLResource(transaction, (DocumentImpl)this.getOwnerDocument());
            transact.commit(transaction);
            Node node = refChild.getPreviousSibling();
            return node;
        }
        catch (TransactionException e) {
            transact.abort(transaction);
            throw new DOMException(7, e.getMessage());
        }
        catch (EXistException e) {
            transact.abort(transaction);
            LOG.warn((Object)("Exception while inserting node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBefore(Txn transaction, NodeList nodes, Node refChild) throws DOMException {
        if (refChild == null) {
            this.appendChildren(transaction, nodes, -1);
            return;
        }
        if (!(refChild instanceof StoredNode)) {
            throw new DOMException(4, "wrong node type");
        }
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            NodePath path = this.getPath();
            StreamListener listener = null;
            broker.getIndexController().setDocument(this.ownerDocument);
            StoredNode reindexRoot = broker.getIndexController().getReindexRoot(this, path, true);
            broker.getIndexController().setMode(0);
            if (reindexRoot == null) {
                listener = broker.getIndexController().getStreamListener();
            } else {
                broker.getIndexController().reindex(transaction, reindexRoot, 0);
            }
            StoredNode following = (StoredNode)refChild;
            StoredNode previous = (StoredNode)following.getPreviousSibling();
            if (previous == null) {
                NodeId newId = following.getNodeId().insertBefore();
                this.appendChildren(transaction, newId, following.getNodeId(), new NodeImplRef(this), path, nodes, listener);
            } else {
                NodeId newId = previous.getNodeId().insertNode(following.getNodeId());
                this.appendChildren(transaction, newId, following.getNodeId(), new NodeImplRef(this.getLastNode(previous)), path, nodes, listener);
            }
            this.setDirty(true);
            broker.updateNode(transaction, this, true);
            broker.getIndexController().reindex(transaction, reindexRoot, 0);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while inserting node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAfter(Txn transaction, NodeList nodes, Node refChild) throws DOMException {
        if (refChild == null) {
            this.appendChildren(null, nodes, -1);
            return;
        }
        if (!(refChild instanceof StoredNode)) {
            throw new DOMException(4, "wrong node type: ");
        }
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            NodePath path = this.getPath();
            StreamListener listener = null;
            broker.getIndexController().setDocument(this.ownerDocument);
            StoredNode reindexRoot = broker.getIndexController().getReindexRoot(this, path, true);
            broker.getIndexController().setMode(0);
            if (reindexRoot == null) {
                listener = broker.getIndexController().getStreamListener();
            } else {
                broker.getIndexController().reindex(transaction, reindexRoot, 0);
            }
            StoredNode previous = (StoredNode)refChild;
            StoredNode following = (StoredNode)previous.getNextSibling();
            NodeId followingId = following == null ? null : following.getNodeId();
            NodeId newNodeId = previous.getNodeId().insertNode(followingId);
            this.appendChildren(transaction, newNodeId, followingId, new NodeImplRef(this.getLastNode(previous)), path, nodes, listener);
            this.setDirty(true);
            broker.updateNode(transaction, this, true);
            broker.getIndexController().reindex(transaction, reindexRoot, 0);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while inserting node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Txn transaction, NodeList newContent) throws DOMException {
        NodePath path = this.getPath();
        NodeList nodes = this.getChildNodes();
        StreamListener listener = null;
        DBBroker broker = null;
        try {
            int i;
            broker = this.ownerDocument.getBrokerPool().get(null);
            broker.getIndexController().setDocument(this.ownerDocument);
            StoredNode reindexRoot = broker.getIndexController().getReindexRoot(this, path, true);
            broker.getIndexController().setMode(2);
            if (reindexRoot == null) {
                listener = broker.getIndexController().getStreamListener();
            } else {
                broker.getIndexController().reindex(transaction, reindexRoot, 2);
            }
            StoredNode valueReindexRoot = broker.getValueIndex().getReindexRoot(this, path);
            broker.getValueIndex().reindex(valueReindexRoot);
            StoredNode last = this;
            for (i = nodes.getLength(); i > 0; --i) {
                StoredNode child = (StoredNode)nodes.item(i - 1);
                if (child.getNodeType() == 2) {
                    last = child;
                    break;
                }
                if (child.getNodeType() == 1) {
                    path.addComponent(child.getQName());
                }
                broker.removeAllNodes(transaction, child, path, listener);
                if (child.getNodeType() != 1) continue;
                path.removeLastComponent();
            }
            broker.getIndexController().flush();
            broker.getIndexController().setMode(0);
            broker.getIndexController().getStreamListener();
            broker.endRemove(transaction);
            this.children = i;
            NodeId newNodeId = last == this ? this.nodeId.newChild() : last.nodeId.nextSibling();
            this.appendChildren(transaction, newNodeId, null, new NodeImplRef(last), path, newContent, listener);
            broker.updateNode(transaction, this, false);
            broker.getIndexController().reindex(transaction, reindexRoot, 0);
            broker.getValueIndex().reindex(valueReindexRoot);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while inserting node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredNode updateChild(Txn transaction, Node oldChild, Node newChild) throws DOMException {
        StoredNode previousNode;
        if (!(oldChild instanceof StoredNode)) {
            throw new DOMException(4, "wrong node type");
        }
        if (!(newChild instanceof StoredNode)) {
            throw new DOMException(4, "wrong node type");
        }
        StoredNode oldNode = (StoredNode)oldChild;
        StoredNode newNode = (StoredNode)newChild;
        if (!oldNode.nodeId.getParentId().equals(this.nodeId)) {
            throw new DOMException(8, "node is not a child of this element");
        }
        if (newNode.getNodeType() == 2 && newNode.getQName().equalsSimple(Namespaces.XML_ID_QNAME)) {
            AttrImpl attr = (AttrImpl)newNode;
            attr.setValue(StringValue.trimWhitespace(StringValue.collapseWhitespace(attr.getValue())));
            attr.setType(1);
        }
        previousNode = (previousNode = (StoredNode)oldNode.getPreviousSibling()) == null ? this : this.getLastNode(previousNode);
        NodePath currentPath = this.getPath();
        NodePath oldPath = oldNode.getPath(currentPath);
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            broker.getIndexController().setDocument(this.ownerDocument);
            StoredNode reindexRoot = broker.getIndexController().getReindexRoot(oldNode, oldPath);
            if (reindexRoot == null) {
                reindexRoot = oldNode;
            }
            broker.getIndexController().reindex(transaction, reindexRoot, 2);
            StoredNode valueReindexRoot = broker.getValueIndex().getReindexRoot(this, oldPath);
            broker.getValueIndex().reindex(valueReindexRoot);
            broker.removeNode(transaction, oldNode, oldPath, null);
            broker.endRemove(transaction);
            newNode.nodeId = oldNode.nodeId;
            broker.insertNodeAfter(transaction, previousNode, newNode);
            NodePath path = newNode.getPath(currentPath);
            broker.indexNode(transaction, newNode, path);
            if (newNode.getNodeType() == 1) {
                broker.endElement(newNode, path, null);
            }
            broker.updateNode(transaction, this, true);
            broker.getIndexController().reindex(transaction, reindexRoot, 0);
            broker.getValueIndex().reindex(valueReindexRoot);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while inserting node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node removeChild(Txn transaction, Node oldChild) throws DOMException {
        if (!(oldChild instanceof StoredNode)) {
            throw new DOMException(4, "wrong node type");
        }
        StoredNode oldNode = (StoredNode)oldChild;
        if (!oldNode.nodeId.getParentId().equals(this.nodeId)) {
            throw new DOMException(8, "node is not a child of this element");
        }
        NodePath oldPath = oldNode.getPath();
        StreamListener listener = null;
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            broker.getIndexController().setDocument(this.ownerDocument);
            StoredNode reindexRoot = broker.getIndexController().getReindexRoot(oldNode, oldPath);
            broker.getIndexController().setMode(2);
            if (reindexRoot == null) {
                listener = broker.getIndexController().getStreamListener();
            } else {
                broker.getIndexController().reindex(transaction, reindexRoot, 2);
            }
            broker.removeAllNodes(transaction, oldNode, oldPath, listener);
            --this.children;
            if (oldChild.getNodeType() == 2) {
                this.attributes = (short)(this.attributes - 1);
            }
            broker.endRemove(transaction);
            this.setDirty(true);
            broker.updateNode(transaction, this, false);
            broker.flush();
            broker.getIndexController().reindex(transaction, reindexRoot, 0);
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while inserting node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return oldNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppendAttributes(Txn transaction, NodeList removeList, NodeList appendList) {
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            if (removeList != null) {
                try {
                    for (int i = 0; i < removeList.getLength(); ++i) {
                        Node oldChild = removeList.item(i);
                        if (!(oldChild instanceof StoredNode)) {
                            throw new DOMException(4, "wrong node type");
                        }
                        StoredNode old = (StoredNode)oldChild;
                        if (!old.nodeId.isChildOf(this.nodeId)) {
                            throw new DOMException(8, "node " + old.nodeId.getParentId() + " is not a child of element " + this.nodeId);
                        }
                        NodePath oldPath = old.getPath();
                        broker.getIndexController().reindex(transaction, old, 2);
                        broker.removeNode(transaction, old, oldPath, null);
                        --this.children;
                        this.attributes = (short)(this.attributes - 1);
                    }
                }
                finally {
                    broker.endRemove(transaction);
                }
            }
            NodePath path = this.getPath();
            broker.getIndexController().setDocument(this.ownerDocument, 0);
            StreamListener listener = broker.getIndexController().getStreamListener();
            if (this.children == 0) {
                this.appendChildren(transaction, this.nodeId.newChild(), null, new NodeImplRef(this), path, appendList, listener);
            } else {
                if (this.attributes == 0) {
                    StoredNode firstChild = (StoredNode)this.getFirstChild();
                    NodeId newNodeId = firstChild.nodeId.insertBefore();
                    this.appendChildren(transaction, newNodeId, firstChild.getNodeId(), new NodeImplRef(this), path, appendList, listener);
                } else {
                    AttribVisitor visitor = new AttribVisitor();
                    this.accept(visitor);
                    NodeId firstChildId = visitor.firstChild == null ? null : ((AttribVisitor)visitor).firstChild.nodeId;
                    NodeId newNodeId = ((AttribVisitor)visitor).lastAttrib.nodeId.insertNode(firstChildId);
                    this.appendChildren(transaction, newNodeId, firstChildId, new NodeImplRef(visitor.lastAttrib), path, appendList, listener);
                }
                this.setDirty(true);
            }
            this.attributes = (short)(this.attributes + appendList.getLength());
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while inserting node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            broker.updateNode(transaction, this, true);
            broker.flush();
            this.ownerDocument.getBrokerPool().release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node replaceChild(Txn transaction, Node newChild, Node oldChild) throws DOMException {
        if (!(oldChild instanceof StoredNode)) {
            throw new DOMException(4, "wrong node type");
        }
        StoredNode oldNode = (StoredNode)oldChild;
        if (!oldNode.nodeId.getParentId().equals(this.nodeId)) {
            throw new DOMException(8, "node is not a child of this element");
        }
        StoredNode previous = (StoredNode)oldNode.getPreviousSibling();
        previous = previous == null ? this : this.getLastNode(previous);
        NodePath oldPath = oldNode.getPath();
        StreamListener listener = null;
        Node newNode = null;
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            broker.getIndexController().setDocument(this.ownerDocument);
            StoredNode reindexRoot = broker.getIndexController().getReindexRoot(oldNode, oldPath);
            broker.getIndexController().setMode(2);
            if (reindexRoot == null) {
                listener = broker.getIndexController().getStreamListener();
            } else {
                broker.getIndexController().reindex(transaction, reindexRoot, 2);
            }
            broker.removeAllNodes(transaction, oldNode, oldPath, listener);
            broker.endRemove(transaction);
            broker.flush();
            broker.getIndexController().setMode(0);
            listener = broker.getIndexController().getStreamListener();
            newNode = this.appendChild(transaction, oldNode.nodeId, new NodeImplRef(previous), this.getPath(), newChild, listener);
            DocumentImpl owner = (DocumentImpl)this.getOwnerDocument();
            broker.storeXMLResource(transaction, owner);
            broker.updateNode(transaction, this, false);
            broker.getIndexController().reindex(transaction, reindexRoot, 0);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while inserting node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return newNode;
    }

    private String escapeXml(Node child) {
        String str = ((Attr)child).getValue();
        StringBuffer buffer = null;
        String entity = null;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\'': {
                    entity = "&apos;";
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public void setPreserveSpace(boolean preserveWS) {
        this.preserveWS = preserveWS;
    }

    public boolean preserveSpace() {
        return this.preserveWS;
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new DOMException(9, "getSchemaTypeInfo() not implemented on class " + this.getClass().getName());
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(9, "setIdAttribute(String name, boolean isId) not implemented on class " + this.getClass().getName());
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(9, "setIdAttributeNS(String namespaceURI, String localName, boolean isId) not implemented on class " + this.getClass().getName());
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(9, "setIdAttributeNode(Attr idAttr, boolean isId) not implemented on class " + this.getClass().getName());
    }

    public String getBaseURI() {
        String baseURI = this.getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
        if (baseURI == null) {
            baseURI = "";
        }
        StoredNode parent = (StoredNode)this.getParentNode();
        while (parent != null && parent.getBaseURI() != null) {
            baseURI = "".equals(baseURI) ? parent.getBaseURI() : parent.getBaseURI() + "/" + baseURI;
            if ((parent = (StoredNode)parent.getParentNode()) != null) continue;
            return baseURI;
        }
        if ("".equals(baseURI)) {
            baseURI = this.getDocument().getBaseURI();
        }
        return baseURI;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        throw new DOMException(9, "compareDocumentPosition(Node other) not implemented on class " + this.getClass().getName());
    }

    public String getTextContent() throws DOMException {
        throw new DOMException(9, "getTextContent() not implemented on class " + this.getClass().getName());
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new DOMException(9, "setTextContent(String textContent) not implemented on class " + this.getClass().getName());
    }

    public boolean isSameNode(Node other) {
        if (other instanceof StoredNode) {
            return this.nodeId == ((StoredNode)other).nodeId && this.ownerDocument.getDocId() == ((StoredNode)other).ownerDocument.getDocId();
        }
        throw new DOMException(9, "isSameNode(Node other) not implemented on other class " + other.getClass().getName());
    }

    public String lookupPrefix(String namespaceURI) {
        throw new DOMException(9, "lookupPrefix(String namespaceURI) not implemented on class " + this.getClass().getName());
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new DOMException(9, "isDefaultNamespace(String namespaceURI) not implemented on class " + this.getClass().getName());
    }

    public String lookupNamespaceURI(String prefix) {
        throw new DOMException(9, "lookupNamespaceURI(String prefix) not implemented on class " + this.getClass().getName());
    }

    public boolean isEqualNode(Node arg) {
        throw new DOMException(9, "isEqualNode(Node arg) not implemented on class " + this.getClass().getName());
    }

    public Object getFeature(String feature, String version) {
        throw new DOMException(9, "getFeature(String feature, String version) not implemented on class " + this.getClass().getName());
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new DOMException(9, "setUserData(String key, Object data, UserDataHandler handler) not implemented on class " + this.getClass().getName());
    }

    public Object getUserData(String key) {
        throw new DOMException(9, "getUserData(String key) not implemented on class " + this.getClass().getName());
    }

    public boolean accept(Iterator iterator, NodeVisitor visitor) {
        if (!visitor.visit(this)) {
            return false;
        }
        if (this.hasChildNodes()) {
            int ccount = this.getChildCount();
            for (int i = 0; i < ccount; ++i) {
                StoredNode next = (StoredNode)iterator.next();
                if (next.accept(iterator, visitor)) continue;
                return false;
            }
        }
        return true;
    }

    private class AttribVisitor
    implements NodeVisitor {
        private StoredNode lastAttrib = null;
        private StoredNode firstChild = null;

        private AttribVisitor() {
        }

        public boolean visit(StoredNode node) {
            if (node.getNodeType() == 2) {
                this.lastAttrib = node;
            } else if (node.nodeId.isChildOf(ElementImpl.this.nodeId)) {
                this.firstChild = node;
                return false;
            }
            return true;
        }
    }
}

