/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.exist.EXistException;
import org.exist.dom.AttrImpl;
import org.exist.dom.CDATASectionImpl;
import org.exist.dom.CommentImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeVisitor;
import org.exist.dom.ProcessingInstructionImpl;
import org.exist.dom.QName;
import org.exist.dom.TextImpl;
import org.exist.dom.Visitable;
import org.exist.numbering.NodeId;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.Signatures;
import org.exist.util.pool.NodePool;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StoredNode
extends NodeImpl
implements Visitable {
    public static final int LENGTH_SIGNATURE_LENGTH = 1;
    public static final long UNKNOWN_NODE_IMPL_ADDRESS = -1L;
    protected NodeId nodeId = null;
    protected DocumentImpl ownerDocument = null;
    private long internalAddress = -1L;
    private short nodeType = (short)-1;

    public StoredNode(short nodeType) {
        this.nodeType = nodeType;
    }

    public StoredNode(short nodeType, NodeId nodeId) {
        this.nodeType = nodeType;
        this.nodeId = nodeId;
    }

    public StoredNode(StoredNode other) {
        this.nodeType = other.nodeType;
        this.nodeId = other.nodeId;
        this.internalAddress = other.internalAddress;
        this.ownerDocument = other.ownerDocument;
    }

    public StoredNode(NodeProxy other) {
        this.ownerDocument = other.getDocument();
        this.nodeType = other.getNodeType();
        this.nodeId = other.getNodeId();
        this.internalAddress = other.getInternalAddress();
    }

    public void clear() {
        this.nodeId = null;
        this.internalAddress = -1L;
    }

    public byte[] serialize() {
        throw new DOMException(15, "Can't serialize " + this.getClass().getName());
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc) {
        return StoredNode.deserialize(data, start, len, doc, false);
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        short type = Signatures.getType(data[start]);
        switch (type) {
            case 3: {
                return TextImpl.deserialize(data, start, len, doc, pooled);
            }
            case 1: {
                return ElementImpl.deserialize(data, start, len, doc, pooled);
            }
            case 2: {
                return AttrImpl.deserialize(data, start, len, doc, pooled);
            }
            case 7: {
                return ProcessingInstructionImpl.deserialize(data, start, len, doc, pooled);
            }
            case 8: {
                return CommentImpl.deserialize(data, start, len, doc, pooled);
            }
            case 4: {
                return CDATASectionImpl.deserialize(data, start, len, doc, pooled);
            }
        }
        LOG.error((Object)("Unknown node type: " + type));
        Thread.dumpStack();
        return null;
    }

    public QName getQName() {
        switch (this.getNodeType()) {
            case 9: {
                return QName.DOCUMENT_QNAME;
            }
            case 3: {
                return QName.TEXT_QNAME;
            }
            case 8: {
                return QName.COMMENT_QNAME;
            }
            case 10: {
                return QName.DOCTYPE_QNAME;
            }
        }
        LOG.error((Object)("Unknown node type: " + this.getNodeType()));
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StoredNode)) {
            return false;
        }
        return ((StoredNode)obj).nodeId.equals(this.nodeId);
    }

    public void setNodeId(NodeId dln) {
        this.nodeId = dln;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public long getInternalAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(long internalAddress) {
        this.internalAddress = internalAddress;
    }

    public boolean isDirty() {
        return true;
    }

    public void setDirty(boolean dirty) {
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public DocumentImpl getDocument() {
        return this.ownerDocument;
    }

    public void setOwnerDocument(DocumentImpl ownerDocument) {
        this.ownerDocument = ownerDocument;
    }

    public int getDocId() {
        return this.ownerDocument.getDocId();
    }

    public Node getParentNode() {
        NodeId parentId = this.nodeId.getParentId();
        if (parentId == NodeId.DOCUMENT_NODE) {
            return null;
        }
        if (parentId.getTreeLevel() == 1 && ((DocumentImpl)this.getOwnerDocument()).getCollection().isTempCollection()) {
            return this.ownerDocument;
        }
        return this.ownerDocument.getNode(parentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getPreviousSibling() {
        StoredNode parent = (StoredNode)this.getParentNode();
        if (parent == null || parent.getNodeType() == 9) {
            return null;
        }
        if (parent.isDirty()) {
            DBBroker broker = null;
            try {
                broker = this.ownerDocument.getBrokerPool().get(null);
                EmbeddedXMLStreamReader reader = broker.getXMLStreamReader(parent, true);
                int level = this.nodeId.getTreeLevel();
                StoredNode last = null;
                while (reader.hasNext()) {
                    int status = reader.next();
                    NodeId currentId = (NodeId)reader.getProperty("node-id");
                    if (status == 2 || currentId.getTreeLevel() != level) continue;
                    if (currentId.equals(this.nodeId)) {
                        StoredNode storedNode = last;
                        return storedNode;
                    }
                    last = reader.getNode();
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
            }
            catch (XMLStreamException e) {
                LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
            }
            catch (EXistException e) {
                LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.ownerDocument.getBrokerPool().release(broker);
            }
            return null;
        }
        NodeId firstChild = parent.getNodeId().newChild();
        if (this.nodeId.equals(firstChild)) {
            return null;
        }
        NodeId siblingId = this.nodeId.precedingSibling();
        return this.ownerDocument.getNode(siblingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNextSibling() {
        if (this.nodeId.getTreeLevel() == 2 && ((DocumentImpl)this.getOwnerDocument()).getCollection().isTempCollection()) {
            return null;
        }
        StoredNode parent = (StoredNode)this.getParentNode();
        if (parent == null || parent.getNodeType() == 9) {
            return null;
        }
        if (parent.isDirty()) {
            DBBroker broker = null;
            try {
                broker = this.ownerDocument.getBrokerPool().get(null);
                EmbeddedXMLStreamReader reader = broker.getXMLStreamReader(parent, true);
                int level = this.nodeId.getTreeLevel();
                while (reader.hasNext()) {
                    int status = reader.next();
                    NodeId currentId = (NodeId)reader.getProperty("node-id");
                    if (status == 2 || currentId.getTreeLevel() != level || currentId.compareTo(this.nodeId) <= 0) continue;
                    StoredNode storedNode = reader.getNode();
                    return storedNode;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
            }
            catch (XMLStreamException e) {
                LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
            }
            catch (EXistException e) {
                LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.ownerDocument.getBrokerPool().release(broker);
            }
            return null;
        }
        NodeId siblingId = this.nodeId.nextSibling();
        return this.ownerDocument.getNode(siblingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoredNode getLastNode(StoredNode node) {
        if (!node.hasChildNodes()) {
            return node;
        }
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            EmbeddedXMLStreamReader reader = broker.getXMLStreamReader(node, true);
            while (reader.hasNext()) {
                reader.next();
            }
            StoredNode storedNode = reader.getPreviousNode();
            return storedNode;
        }
        catch (IOException e) {
            LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
        }
        catch (XMLStreamException e) {
            LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
        }
        catch (EXistException e) {
            LOG.warn((Object)("Internal error while reading child nodes: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return null;
    }

    protected StoredNode getLastNode(Iterator iterator, StoredNode node) {
        if (!node.hasChildNodes()) {
            return node;
        }
        int children = node.getChildCount();
        StoredNode next = null;
        for (int i = 0; i < children; ++i) {
            next = (StoredNode)iterator.next();
            next = this.getLastNode(iterator, next);
        }
        return next;
    }

    public NodePath getPath() {
        NodePath path = new NodePath();
        if (this.getNodeType() == 1) {
            path.addComponent(this.getQName());
        }
        for (NodeImpl parent = (NodeImpl)this.getParentNode(); parent != null && parent.getNodeType() != 9; parent = (NodeImpl)parent.getParentNode()) {
            path.addComponentAtStart(parent.getQName());
        }
        return path;
    }

    public NodePath getPath(NodePath parentPath) {
        if (this.getNodeType() == 1) {
            parentPath.addComponent(this.getQName());
        }
        return parentPath;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.nodeId.toString());
        buf.append('\t');
        buf.append(this.getQName());
        return buf.toString();
    }

    public String toString(boolean top) {
        return this.toString();
    }

    public void release() {
        this.ownerDocument = null;
        this.clear();
        NodePool.getInstance().returnNode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(NodeVisitor visitor) {
        DBBroker broker = null;
        try {
            broker = this.ownerDocument.getBrokerPool().get(null);
            Iterator iterator = broker.getNodeIterator(this);
            iterator.next();
            boolean bl = this.accept(iterator, visitor);
            return bl;
        }
        catch (EXistException e) {
            LOG.warn((Object)("Exception while reading node: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.ownerDocument.getBrokerPool().release(broker);
        }
        return false;
    }

    public boolean accept(Iterator iterator, NodeVisitor visitor) {
        return visitor.visit(this);
    }

    private static final class PreviousSiblingVisitor
    implements NodeVisitor {
        private StoredNode current;
        private StoredNode last = null;

        public PreviousSiblingVisitor(StoredNode current) {
            this.current = current;
        }

        public boolean visit(StoredNode node) {
            if (node.nodeId.equals(this.current.nodeId)) {
                return false;
            }
            if (node.nodeId.getTreeLevel() == this.current.nodeId.getTreeLevel()) {
                this.last = node;
            }
            return true;
        }
    }
}

