/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exist.scheduler.JobException;
import org.exist.scheduler.UserJavaJob;
import org.exist.storage.BrokerPool;
import org.exist.xquery.value.Sequence;

public class SessionManager {
    public static final long TIMEOUT = 120000L;
    public static final long TIMEOUT_CHECK_PERIOD = 2000L;
    public static final int NO_SESSION = -1;
    private static final Logger LOG = Logger.getLogger((Class)SessionManager.class);
    private QueryResult[] slots = new QueryResult[32];

    public SessionManager(BrokerPool pool) {
        Properties props = new Properties();
        props.put("session-manager", this);
        pool.getScheduler().createPeriodicJob(2000L, new TimeoutCheck(), 2000L, props);
    }

    public int add(String query, Sequence sequence) {
        int len = this.slots.length;
        for (int i = 0; i < len; ++i) {
            if (this.slots[i] != null) continue;
            this.slots[i] = new QueryResult(query, sequence);
            return i;
        }
        QueryResult[] t = new QueryResult[len * 3 / 2];
        System.arraycopy(this.slots, 0, t, 0, len);
        t[len] = new QueryResult(query, sequence);
        this.slots = t;
        return len;
    }

    public Sequence get(String query, int sessionId) {
        if (sessionId < 0 || sessionId >= this.slots.length) {
            return null;
        }
        QueryResult cached = this.slots[sessionId];
        if (cached == null) {
            return null;
        }
        if (cached.queryString.equals(query)) {
            return cached.sequence;
        }
        return null;
    }

    public void release(int sessionId) {
        if (sessionId < 0 || sessionId >= this.slots.length) {
            return;
        }
        this.slots[sessionId] = null;
    }

    protected void timeoutCheck() {
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || now - this.slots[i].created <= 120000L) continue;
            LOG.debug((Object)("Removing cached query result for session " + i));
            this.slots[i] = null;
        }
    }

    public static class TimeoutCheck
    extends UserJavaJob {
        public String getName() {
            return "REST_TimeoutCheck";
        }

        public void setName(String name) {
        }

        public void execute(BrokerPool brokerpool, Map params) throws JobException {
            SessionManager manager = (SessionManager)params.get("session-manager");
            if (manager == null) {
                throw new JobException(0, "parameter 'session-manager' is not set");
            }
            manager.timeoutCheck();
        }
    }

    private class QueryResult {
        long created;
        String queryString;
        Sequence sequence;

        private QueryResult(String query, Sequence sequence) {
            this.queryString = query;
            this.sequence = sequence;
            this.created = System.currentTimeMillis();
        }
    }
}

