/*
 * Decompiled with CFR 0.152.
 */
package org.exist.numbering;

import java.io.IOException;
import org.exist.numbering.DLNBase;
import org.exist.numbering.DLNFactory;
import org.exist.numbering.NodeId;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public class DLN
extends DLNBase
implements NodeId {
    public DLN() {
        this(1);
    }

    public DLN(String s) {
        this.bits = new byte[1];
        StringBuffer buf = new StringBuffer(16);
        boolean subValue = false;
        for (int p = 0; p < s.length(); ++p) {
            char ch = s.charAt(p);
            if (ch == '.' || ch == '/') {
                this.addLevelId(Integer.parseInt(buf.toString()), subValue);
                subValue = ch == '/';
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            this.addLevelId(Integer.parseInt(buf.toString()), subValue);
        }
    }

    public DLN(int id) {
        this.bits = new byte[1];
        this.addLevelId(id, false);
    }

    public DLN(DLN other) {
        super(other);
    }

    public DLN(int units, byte[] data, int startOffset) {
        super(units, data, startOffset);
    }

    public DLN(short bitCnt, VariableByteInput is) throws IOException {
        super(bitCnt, is);
    }

    public DLN(byte prefixLen, DLN previous, short bitCnt, VariableByteInput is) throws IOException {
        super(prefixLen, previous, bitCnt, is);
    }

    protected DLN(byte[] data, int nbits) {
        super(data, nbits);
    }

    public NodeId newChild() {
        DLN child = new DLN(this);
        child.addLevelId(1, false);
        return child;
    }

    public NodeId nextSibling() {
        DLN sibling = new DLN(this);
        sibling.incrementLevelId();
        return sibling;
    }

    public NodeId precedingSibling() {
        DLN sibling = new DLN(this);
        sibling.decrementLevelId();
        return sibling;
    }

    public NodeId getChild(int child) {
        DLN nodeId = new DLN(this);
        nodeId.addLevelId(child, false);
        return nodeId;
    }

    public NodeId insertNode(NodeId right) {
        DLN newNode;
        int lenRight;
        DLN rightNode = (DLN)right;
        if (right == null) {
            return this.nextSibling();
        }
        int lastLeft = this.lastLevelOffset();
        int lastRight = rightNode.lastLevelOffset();
        int lenLeft = this.getSubLevelCount(lastLeft);
        if (lenLeft > (lenRight = rightNode.getSubLevelCount(lastRight))) {
            newNode = new DLN(this);
            newNode.incrementLevelId();
        } else if (lenLeft < lenRight) {
            newNode = (DLN)rightNode.insertBefore();
        } else {
            newNode = new DLN(this);
            newNode.addLevelId(1, true);
        }
        return newNode;
    }

    public NodeId insertBefore() {
        int lastPos = this.lastFieldPosition();
        int lastId = this.getLevelId(lastPos);
        DLN newNode = new DLN(this);
        if (lastId == 1) {
            newNode.setLevelId(lastPos, 0);
            newNode.addLevelId(35, true);
        } else {
            newNode.setLevelId(lastPos, lastId - 1);
            newNode.compact();
        }
        return newNode;
    }

    public NodeId getParentId() {
        if (this == DOCUMENT_NODE) {
            return null;
        }
        int last = this.lastLevelOffset();
        if (last == 0) {
            return DOCUMENT_NODE;
        }
        return new DLN(this.bits, last - 1);
    }

    public boolean isDescendantOf(NodeId ancestor) {
        DLN other = (DLN)ancestor;
        return this.startsWith(other) && this.bitIndex > other.bitIndex && this.isLevelSeparator(other.bitIndex + 1);
    }

    public boolean isDescendantOrSelfOf(NodeId other) {
        DLN ancestor = (DLN)other;
        return this.startsWith(ancestor) && (this.bitIndex == ancestor.bitIndex || this.isLevelSeparator(ancestor.bitIndex + 1));
    }

    public boolean isChildOf(NodeId parent) {
        DLN other = (DLN)parent;
        if (!this.startsWith(other)) {
            return false;
        }
        int levels = this.getLevelCount(other.bitIndex + 2);
        return levels == 1;
    }

    public int computeRelation(NodeId ancestor) {
        DLN other = (DLN)ancestor;
        if (other == NodeId.DOCUMENT_NODE) {
            return this.getLevelCount(0) == 1 ? 1 : 2;
        }
        if (this.startsWith(other)) {
            if (this.bitIndex == other.bitIndex) {
                return 3;
            }
            if (this.bitIndex > other.bitIndex && this.isLevelSeparator(other.bitIndex + 1)) {
                if (this.getLevelCount(other.bitIndex + 2) == 1) {
                    return 1;
                }
                return 2;
            }
        }
        return -1;
    }

    public boolean isSiblingOf(NodeId sibling) {
        NodeId parent = this.getParentId();
        return sibling.isChildOf(parent);
    }

    public int getTreeLevel() {
        return this.getLevelCount(0);
    }

    public boolean equals(NodeId other) {
        return super.equals((DLNBase)((Object)other));
    }

    public int compareTo(Object other) {
        return this.compareTo((DLN)other);
    }

    public int compareTo(NodeId otherId) {
        if (otherId == null) {
            return 1;
        }
        DLN other = (DLN)otherId;
        int a1len = this.bits.length;
        int a2len = other.bits.length;
        int limit = a1len <= a2len ? a1len : a2len;
        byte[] obits = other.bits;
        for (int i = 0; i < limit; ++i) {
            byte b1 = this.bits[i];
            byte b2 = obits[i];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return a1len - a2len;
    }

    public boolean after(NodeId other, boolean isFollowing) {
        if (this.compareTo(other) > 0) {
            if (isFollowing) {
                return !this.isDescendantOf(other);
            }
            return true;
        }
        return false;
    }

    public boolean before(NodeId other, boolean isPreceding) {
        if (this.compareTo(other) < 0) {
            if (isPreceding) {
                return !other.isDescendantOf(this);
            }
            return true;
        }
        return false;
    }

    public void write(VariableByteOutputStream os) throws IOException {
        os.writeShort((short)this.units());
        os.write(this.bits, 0, this.bits.length);
    }

    public NodeId write(NodeId prevId, VariableByteOutputStream os) throws IOException {
        int i;
        if (prevId != null) {
            byte b;
            DLN previous = (DLN)prevId;
            int len = Math.min(this.bits.length, previous.bits.length);
            for (i = 0; i < len && (b = this.bits[i]) == previous.bits[i]; ++i) {
            }
        }
        os.writeByte((byte)i);
        os.writeShort((short)this.units());
        os.write(this.bits, i, this.bits.length - i);
        return this;
    }

    public static void main(String[] args) throws IOException {
        int i;
        NodeId[] ids = new NodeId[]{new DLN("1.1.7.2.1"), new DLN("1.1.7.2.2"), new DLN("1.1.8"), new DLN("1.1.8.1.1"), new DLN("1.1.8.1.1/1"), new DLN("1.1.8.1.1/2"), new DLN("1.1.8.1.2.1.5"), new DLN("1.1.8.1.2.1.7"), new DLN("1.2"), END_OF_DOCUMENT, END_OF_DOCUMENT};
        VariableByteOutputStream os = new VariableByteOutputStream();
        NodeId previous = null;
        for (int i2 = 0; i2 < ids.length; ++i2) {
            NodeId id = ids[i2];
            System.out.println(id.toString());
            id.write(previous, os);
            previous = id;
        }
        byte[] data = os.toByteArray();
        System.out.println("Data length: " + data.length);
        VariableByteArrayInput is = new VariableByteArrayInput(data);
        DLNFactory fact = new DLNFactory();
        previous = null;
        for (i = 0; i < ids.length; ++i) {
            previous = fact.createFromStream(previous, is);
            System.out.println(previous.toString());
        }
        os = new VariableByteOutputStream();
        for (i = 0; i < ids.length; ++i) {
            NodeId id = ids[i];
            System.out.println(id.toString());
            id.write(os);
        }
        data = os.toByteArray();
        System.out.println("Data length: " + data.length);
    }
}

