/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.apache.log4j.Logger;
import org.exist.protocolhandler.protocols.xmldb.Handler;

public class eXistURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final Logger LOG = Logger.getLogger((Class)eXistURLStreamHandlerFactory.class);
    public static final String JAVA_PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    public static final String EXIST_PROTOCOL_HANDLER = "org.exist.protocolhandler.protocols";

    public static void init() {
        boolean initOK = false;
        try {
            URL.setURLStreamHandlerFactory(new eXistURLStreamHandlerFactory());
            initOK = true;
            LOG.info((Object)"Succesfully registered eXistURLStreamHandlerFactory.");
        }
        catch (Error ex) {
            LOG.warn((Object)"The JVM has already an URLStreamHandlerFactory registered, skipping...");
        }
        if (!initOK) {
            String currentSystemProperty = System.getProperty(JAVA_PROTOCOL_HANDLER_PKGS);
            if (currentSystemProperty == null) {
                LOG.info((Object)"Setting java.protocol.handler.pkgs to org.exist.protocolhandler.protocols");
                System.setProperty(JAVA_PROTOCOL_HANDLER_PKGS, EXIST_PROTOCOL_HANDLER);
            } else if (currentSystemProperty.indexOf(EXIST_PROTOCOL_HANDLER) == -1) {
                currentSystemProperty = currentSystemProperty + "|" + EXIST_PROTOCOL_HANDLER;
                LOG.info((Object)("Setting java.protocol.handler.pkgs to " + currentSystemProperty));
                System.setProperty(JAVA_PROTOCOL_HANDLER_PKGS, currentSystemProperty);
            } else {
                LOG.info((Object)"System property java.protocol.handler.pkgs has not been updated.");
            }
        }
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        Handler handler = null;
        if ("xmldb".equals(protocol)) {
            LOG.debug((Object)protocol);
            handler = new Handler();
        }
        return handler;
    }
}

