/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.protocolhandler.embedded.EmbeddedUser;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.io.ExistIOException;
import org.exist.storage.serializers.Serializer;
import org.exist.xmldb.XmldbURI;

public class EmbeddedDownload {
    private static final Logger LOG = Logger.getLogger((Class)EmbeddedDownload.class);

    public void stream(XmldbURL xmldbURL, OutputStream os) throws IOException {
        this.stream(xmldbURL, os, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stream(XmldbURL xmldbURL, OutputStream os, User user) throws IOException {
        LOG.debug((Object)"Begin document download");
        DocumentImpl resource = null;
        Collection collection = null;
        BrokerPool pool = null;
        DBBroker broker = null;
        try {
            XmldbURI path = XmldbURI.create(xmldbURL.getPath());
            pool = BrokerPool.getInstance();
            if (user == null) {
                if (xmldbURL.hasUserInfo()) {
                    user = EmbeddedUser.authenticate(xmldbURL, pool);
                    if (user == null) {
                        throw new ExistIOException("Unauthorized user " + xmldbURL.getUsername());
                    }
                } else {
                    user = EmbeddedUser.getUserGuest(pool);
                }
            }
            if ((resource = (broker = pool.get(user)).getXMLResource(path, 0)) == null) {
                collection = broker.openCollection(path, 0);
                if (collection != null) throw new ExistIOException("Resource " + xmldbURL.getPath() + " is a collection.");
                throw new ExistIOException("Resource " + xmldbURL.getPath() + " not found.");
            }
            if (resource.getResourceType() == 0) {
                Serializer serializer = broker.getSerializer();
                serializer.reset();
                serializer.setProperty("output-doctype", "yes");
                OutputStreamWriter w = new OutputStreamWriter(os, "UTF-8");
                serializer.serialize(resource, w);
                ((Writer)w).close();
            } else {
                broker.readBinaryResource((BinaryDocument)resource, os);
            }
            if (resource != null) {
                resource.getUpdateLock().release(0);
            }
            if (collection != null) {
                collection.release(0);
            }
            pool.release(broker);
        }
        catch (IOException ex) {
            try {
                LOG.error((Object)ex);
                throw ex;
                catch (Exception ex2) {
                    LOG.error((Object)ex2);
                    throw new ExistIOException(ex2.getMessage(), ex2);
                }
            }
            catch (Throwable throwable) {
                if (resource != null) {
                    resource.getUpdateLock().release(0);
                }
                if (collection != null) {
                    collection.release(0);
                }
                pool.release(broker);
                LOG.debug((Object)"End document download");
                throw throwable;
            }
        }
        LOG.debug((Object)"End document download");
    }
}

