/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.protocols.xmldb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;
import org.exist.protocolhandler.embedded.EmbeddedInputStream;
import org.exist.protocolhandler.embedded.EmbeddedOutputStream;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.protocolhandler.xmlrpc.XmlrpcInputStream;
import org.exist.protocolhandler.xmlrpc.XmlrpcOutputStream;

public class Connection
extends URLConnection {
    private static final Logger LOG = Logger.getLogger((Class)Connection.class);

    protected Connection(URL url) {
        super(url);
        LOG.debug((Object)url);
        this.setDoInput(true);
        this.setDoOutput(true);
    }

    public void connect() throws IOException {
        LOG.debug((Object)this.url);
    }

    public InputStream getInputStream() throws IOException {
        LOG.debug((Object)this.url);
        InputStream inputstream = null;
        XmldbURL xmldbURL = new XmldbURL(this.url);
        inputstream = xmldbURL.isEmbedded() ? new EmbeddedInputStream(xmldbURL) : new XmlrpcInputStream(xmldbURL);
        return inputstream;
    }

    public OutputStream getOutputStream() throws IOException {
        LOG.debug((Object)this.url);
        OutputStream outputstream = null;
        XmldbURL xmldbURL = new XmldbURL(this.url);
        outputstream = xmldbURL.isEmbedded() ? new EmbeddedOutputStream(xmldbURL) : new XmlrpcOutputStream(xmldbURL);
        return outputstream;
    }
}

