/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.exist.security.RandomGUID;

public class UUIDGenerator {
    private static final Logger LOG = Logger.getLogger((Class)UUIDGenerator.class);

    private static String getJavaUUID() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.util.UUID");
        }
        catch (Exception ex) {
            LOG.debug((Object)"Skipping java.util.UUID");
            return null;
        }
        Method method = null;
        try {
            method = clazz.getMethod("randomUUID", null);
        }
        catch (Exception ex) {
            LOG.error((Object)"Method UUID.randomUUID not found", (Throwable)ex);
            return null;
        }
        Object result = null;
        try {
            result = method.invoke(null, null);
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not invoke method randomUUID", (Throwable)ex);
            return null;
        }
        LOG.debug((Object)"Using preferred java.util.UUID");
        return result.toString();
    }

    private static String getSafehausUUID() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.safehaus.uuid.UUIDGenerator");
        }
        catch (Exception ex) {
            LOG.debug((Object)"Skipping org.safehaus.uuid.UUIDGenerator");
            return null;
        }
        Method method = null;
        try {
            method = clazz.getMethod("getInstance", null);
        }
        catch (Exception ex) {
            LOG.error((Object)"Method UUIDGenerator.getInstance not found", (Throwable)ex);
            return null;
        }
        Object result = null;
        try {
            result = method.invoke(null, null);
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not invoke method UUIDGenerator.getInstance", (Throwable)ex);
            return null;
        }
        Class<?> clazz2 = result.getClass();
        Method method2 = null;
        try {
            method2 = clazz2.getMethod("generateRandomBasedUUID", null);
        }
        catch (Exception ex) {
            LOG.error((Object)"Method generateRandomBasedUUID not found.", (Throwable)ex);
            return null;
        }
        Object result2 = null;
        try {
            result2 = method2.invoke(result, null);
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not invoke method generateRandomBasedUUID", (Throwable)ex);
            return null;
        }
        LOG.debug((Object)"Fallback to org.safehaus.uuid.UUIDGenerator");
        return result2.toString();
    }

    private static String getJavaExchangeGUID() {
        LOG.debug((Object)"Fallback to org.exist.security.RandomGUID");
        RandomGUID rg = new RandomGUID(false);
        return rg.toString();
    }

    public static String getUUID() {
        String uuid = UUIDGenerator.getJavaUUID();
        if (uuid == null) {
            uuid = UUIDGenerator.getSafehausUUID();
        }
        if (uuid == null) {
            uuid = UUIDGenerator.getJavaExchangeGUID();
        }
        return uuid;
    }
}

